/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.gui.render;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.client.foundation.gui.render.DrainRenderState;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.BlitRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionfc;

public class DrainRenderer
extends PictureInPictureRenderer<DrainRenderState> {
    public static int MAX = 6;
    private int allocate = MAX;
    private static final Deque<GpuTexture> TEXTURES = new ArrayDeque<GpuTexture>(MAX);
    private final PoseStack matrices = new PoseStack();
    private int windowScaleFactor;

    public DrainRenderer(MultiBufferSource.BufferSource vertexConsumers) {
        super(vertexConsumers);
    }

    public void prepare(DrainRenderState element, GuiRenderState state, int windowScaleFactor) {
        GpuTexture texture;
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.forEach(GpuTexture::close);
            TEXTURES.clear();
            this.allocate = MAX;
        }
        int width = 26 * windowScaleFactor;
        int height = 23 * windowScaleFactor;
        if (this.allocate > 0) {
            --this.allocate;
            texture = GpuTexture.create(width, height);
        } else {
            texture = TEXTURES.poll();
            assert (texture != null);
        }
        RenderSystem.setProjectionMatrix((GpuBufferSlice)this.projectionMatrixBuffer.getBuffer((float)width, (float)height), (ProjectionType)ProjectionType.ORTHOGRAPHIC);
        texture.prepare();
        this.matrices.pushPose();
        this.matrices.translate((float)width / 2.0f, (float)height, 0.0f);
        float scale = 20 * windowScaleFactor;
        this.matrices.scale(scale, scale, scale);
        Minecraft mc = Minecraft.getInstance();
        mc.gameRenderer.getLighting().setupFor(Lighting.Entry.ENTITY_IN_UI);
        this.matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-15.5f));
        this.matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(22.5f));
        this.matrices.scale(1.0f, -1.0f, 1.0f);
        this.matrices.translate(-0.5f, 0.2f, -0.5f);
        BlockRenderDispatcher blockRenderManager = mc.getBlockRenderer();
        SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
        VertexConsumer buffer = this.bufferSource.getBuffer(Sheets.cutoutBlockSheet());
        BlockState blockState = AllBlocks.ITEM_DRAIN.defaultBlockState();
        world.blockState(blockState);
        List parts = blockRenderManager.getBlockModel(blockState).collectParts(mc.level.random);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, this.matrices, buffer, false, parts);
        float from = 0.125f;
        float to = 1.0f - from;
        FluidRenderHelper.renderFluidBox(element.fluid(), element.components(), from, from, from, to, 0.75f, to, (MultiBufferSource)this.bufferSource, this.matrices, 0xF000F0, false, true);
        this.bufferSource.endBatch();
        this.matrices.popPose();
        texture.clear();
        state.submitBlitToCurrentLayer(new BlitRenderState(RenderPipelines.GUI_TEXTURED_PREMULTIPLIED_ALPHA, TextureSetup.singleTexture((GpuTextureView)texture.textureView(), (GpuSampler)RenderSystem.getSamplerCache().getRepeat(FilterMode.NEAREST)), element.pose(), element.x0(), element.y0(), element.x1(), element.y1(), 0.0f, 1.0f, 1.0f, 0.0f, -1, null, null));
        TEXTURES.add(texture);
    }

    protected void renderToTexture(DrainRenderState state, PoseStack matrices) {
    }

    protected String getTextureLabel() {
        return "Drain";
    }

    public Class<DrainRenderState> getRenderStateClass() {
        return DrainRenderState.class;
    }
}

