/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.gui.render;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.client.foundation.gui.render.ManualBlockRenderState;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.BlitRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Quaternionfc;

public class ManualBlockRenderer
extends PictureInPictureRenderer<ManualBlockRenderState> {
    public static int MAX = 6;
    private int allocate = MAX;
    private static final Deque<GpuTexture> TEXTURES = new ArrayDeque<GpuTexture>(MAX);
    private final PoseStack matrices = new PoseStack();
    private int windowScaleFactor;

    public ManualBlockRenderer(MultiBufferSource.BufferSource vertexConsumers) {
        super(vertexConsumers);
    }

    public void prepare(ManualBlockRenderState block, GuiRenderState state, int windowScaleFactor) {
        GpuTexture texture;
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.forEach(GpuTexture::close);
            TEXTURES.clear();
            this.allocate = MAX;
        }
        int size = 27 * windowScaleFactor;
        if (this.allocate > 0) {
            --this.allocate;
            texture = GpuTexture.create(size);
        } else {
            texture = TEXTURES.poll();
            assert (texture != null);
        }
        RenderSystem.setProjectionMatrix((GpuBufferSlice)this.projectionMatrixBuffer.getBuffer((float)size, (float)size), (ProjectionType)ProjectionType.ORTHOGRAPHIC);
        texture.prepare();
        this.matrices.pushPose();
        this.matrices.translate((float)size / 2.0f, (float)size, 0.0f);
        float scale = 20 * windowScaleFactor;
        this.matrices.scale(scale, scale, scale);
        Minecraft mc = Minecraft.getInstance();
        mc.gameRenderer.getLighting().setupFor(Lighting.Entry.ENTITY_IN_UI);
        this.matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-15.5f));
        this.matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(22.5f));
        this.matrices.translate(-0.5f, -0.2f, -0.5f);
        this.matrices.scale(1.0f, -1.0f, 1.0f);
        BlockRenderDispatcher blockRenderManager = mc.getBlockRenderer();
        SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
        VertexConsumer buffer = this.bufferSource.getBuffer(Sheets.cutoutBlockSheet());
        world.blockState(block.state());
        List parts = blockRenderManager.getBlockModel(block.state()).collectParts(mc.level.random);
        blockRenderManager.renderBatched(block.state(), BlockPos.ZERO, (BlockAndTintGetter)world, this.matrices, buffer, false, parts);
        this.bufferSource.endBatch();
        this.matrices.popPose();
        texture.clear();
        state.submitBlitToCurrentLayer(new BlitRenderState(RenderPipelines.GUI_TEXTURED_PREMULTIPLIED_ALPHA, TextureSetup.singleTexture((GpuTextureView)texture.textureView(), (GpuSampler)RenderSystem.getSamplerCache().getRepeat(FilterMode.NEAREST)), block.pose(), block.x0(), block.y0(), block.x1(), block.y1(), 0.0f, 1.0f, 1.0f, 0.0f, -1, null, null));
        TEXTURES.add(texture);
    }

    protected void renderToTexture(ManualBlockRenderState state, PoseStack matrices) {
    }

    protected String getTextureLabel() {
        return "Manual Block";
    }

    public Class<ManualBlockRenderState> getRenderStateClass() {
        return ManualBlockRenderState.class;
    }
}

