/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.gui.render;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.client.foundation.gui.render.MixingBasinRenderState;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionfc;

public class MixingBasinRenderer
extends PictureInPictureRenderer<MixingBasinRenderState> {
    public MixingBasinRenderer(MultiBufferSource.BufferSource vertexConsumers) {
        super(vertexConsumers);
    }

    protected void renderToTexture(MixingBasinRenderState state, PoseStack matrices) {
        Minecraft mc = Minecraft.getInstance();
        mc.gameRenderer.getLighting().setupFor(Lighting.Entry.ENTITY_IN_UI);
        matrices.scale(1.0f, 1.0f, -1.0f);
        matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-15.5f));
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(22.5f));
        matrices.translate(-0.5f, -1.8f, -0.5f);
        matrices.scale(1.0f, -1.0f, 1.0f);
        BlockRenderDispatcher blockRenderManager = mc.getBlockRenderer();
        SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
        VertexConsumer buffer = this.bufferSource.getBuffer(Sheets.cutoutBlockSheet());
        float time = AnimationTickHolder.getRenderTime();
        float angle = MixingBasinRenderer.getCurrentAngle(time);
        BlockState blockState = AllBlocks.MECHANICAL_MIXER.defaultBlockState();
        world.blockState(blockState);
        List parts = blockRenderManager.getBlockModel(blockState).collectParts(mc.level.random);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, matrices, buffer, false, parts);
        blockState = Blocks.AIR.defaultBlockState();
        world.blockState(blockState);
        matrices.pushPose();
        parts = List.of(AllPartialModels.SHAFTLESS_COGWHEEL.get());
        matrices.translate(0.5f, 0.5f, 0.5f);
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(angle * 2.0f));
        matrices.translate(-0.5f, -0.5f, -0.5f);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, matrices, buffer, false, parts);
        matrices.popPose();
        matrices.pushPose();
        matrices.translate(0.0f, MixingBasinRenderer.getAnimatedHeadOffset(time), 0.0f);
        parts = List.of(AllPartialModels.MECHANICAL_MIXER_POLE.get());
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, matrices, buffer, false, parts);
        matrices.translate(0.5f, 0.5f, 0.5f);
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(angle * 4.0f));
        matrices.translate(-0.5f, -0.5f, -0.5f);
        parts = List.of(AllPartialModels.MECHANICAL_MIXER_HEAD.get());
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, matrices, buffer, false, parts);
        matrices.popPose();
        matrices.translate(0.0f, -1.65f, 0.0f);
        blockState = AllBlocks.BASIN.defaultBlockState();
        world.blockState(blockState);
        parts = blockRenderManager.getBlockModel(blockState).collectParts(mc.level.random);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, matrices, buffer, false, parts);
    }

    private static float getCurrentAngle(float time) {
        return time * 4.0f % 360.0f;
    }

    private static float getAnimatedHeadOffset(float time) {
        return -((Mth.sin((double)(time / 32.0f)) + 1.0f) / 5.0f + 0.5f);
    }

    protected String getTextureLabel() {
        return "Mixing Basin";
    }

    public Class<MixingBasinRenderState> getRenderStateClass() {
        return MixingBasinRenderState.class;
    }
}

