/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.gui.render;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.client.foundation.gui.render.PressRenderState;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.BlitRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionfc;

public class PressRenderer
extends PictureInPictureRenderer<PressRenderState> {
    private static final Int2ObjectMap<GpuTexture> TEXTURES = new Int2ObjectArrayMap();
    private final PoseStack matrices = new PoseStack();
    private int windowScaleFactor;

    public PressRenderer(MultiBufferSource.BufferSource vertexConsumers) {
        super(vertexConsumers);
    }

    public void prepare(PressRenderState item, GuiRenderState state, int windowScaleFactor) {
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        int width = 30 * windowScaleFactor;
        int height = 64 * windowScaleFactor;
        GpuTexture texture = (GpuTexture)TEXTURES.get(item.id());
        if (texture == null) {
            texture = GpuTexture.create(width, height);
            TEXTURES.put(item.id(), (Object)texture);
        }
        RenderSystem.setProjectionMatrix((GpuBufferSlice)this.projectionMatrixBuffer.getBuffer((float)width, (float)height), (ProjectionType)ProjectionType.ORTHOGRAPHIC);
        texture.prepare();
        this.matrices.pushPose();
        this.matrices.translate((float)width / 2.0f, (float)height, 0.0f);
        float scale = 23 * windowScaleFactor;
        this.matrices.scale(scale, scale, scale);
        Minecraft mc = Minecraft.getInstance();
        mc.gameRenderer.getLighting().setupFor(Lighting.Entry.ENTITY_IN_UI);
        this.matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-15.5f));
        this.matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(22.5f));
        this.matrices.translate(-0.5f, -1.14f, -0.5f);
        this.matrices.scale(1.0f, -1.0f, 1.0f);
        BlockRenderDispatcher blockRenderManager = mc.getBlockRenderer();
        SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
        VertexConsumer buffer = this.bufferSource.getBuffer(Sheets.cutoutBlockSheet());
        float time = AnimationTickHolder.getRenderTime();
        BlockState blockState = AllBlocks.MECHANICAL_PRESS.defaultBlockState();
        world.blockState(blockState);
        List<SimpleModelWrapper> parts = blockRenderManager.getBlockModel(blockState).collectParts(mc.level.random);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, this.matrices, buffer, false, (List)parts);
        this.matrices.pushPose();
        blockState = (BlockState)AllBlocks.SHAFT.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)Direction.Axis.Z);
        world.blockState(blockState);
        parts = blockRenderManager.getBlockModel(blockState).collectParts(mc.level.random);
        this.matrices.translate(0.5f, 0.5f, 0.5f);
        this.matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(PressRenderer.getShaftAngle(time)));
        this.matrices.translate(-0.5f, -0.5f, -0.5f);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, this.matrices, buffer, false, (List)parts);
        this.matrices.popPose();
        this.matrices.pushPose();
        blockState = Blocks.AIR.defaultBlockState();
        world.blockState(blockState);
        parts = List.of(AllPartialModels.MECHANICAL_PRESS_HEAD.get());
        this.matrices.translate(0.0f, PressRenderer.getAnimatedHeadOffset(time, item.offset()), 0.0f);
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)world, this.matrices, buffer, false, parts);
        this.matrices.popPose();
        this.bufferSource.endBatch();
        this.matrices.popPose();
        texture.clear();
        state.submitBlitToCurrentLayer(new BlitRenderState(RenderPipelines.GUI_TEXTURED_PREMULTIPLIED_ALPHA, TextureSetup.singleTexture((GpuTextureView)texture.textureView(), (GpuSampler)RenderSystem.getSamplerCache().getRepeat(FilterMode.NEAREST)), item.pose(), item.x0(), item.y0(), item.x1(), item.y1(), 0.0f, 1.0f, 1.0f, 0.0f, -1, null, null));
    }

    private static float getShaftAngle(float time) {
        return time * 4.0f % 360.0f;
    }

    private static float getAnimatedHeadOffset(float time, float offset) {
        float cycle = (time - offset * 8.0f) % 30.0f;
        if (cycle < 10.0f) {
            float progress = cycle / 10.0f;
            return -(progress * progress * progress);
        }
        if (cycle < 15.0f) {
            return -1.0f;
        }
        if (cycle < 20.0f) {
            return -1.0f + (1.0f - (20.0f - cycle) / 5.0f);
        }
        return 0.0f;
    }

    protected void renderToTexture(PressRenderState state, PoseStack matrices) {
    }

    protected String getTextureLabel() {
        return "Press";
    }

    public Class<PressRenderState> getRenderStateClass() {
        return PressRenderState.class;
    }
}

