/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.gui.render;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.foundation.gui.render.SandPaperRenderState;
import com.zurrtum.create.infrastructure.component.SandPaperItemComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.feature.FeatureRenderDispatcher;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class SandPaperRenderer
extends PictureInPictureRenderer<SandPaperRenderState> {
    private final ItemStackRenderState renderState = new ItemStackRenderState();
    private final ItemStack stack = AllItems.SAND_PAPER.getDefaultInstance();

    public SandPaperRenderer(MultiBufferSource.BufferSource vertexConsumers) {
        super(vertexConsumers);
        this.stack.set(AllDataComponents.SAND_PAPER_JEI, (Object)Unit.INSTANCE);
    }

    protected void renderToTexture(SandPaperRenderState state, PoseStack matrices) {
        matrices.translate(0.0f, -0.35f, 0.0f);
        matrices.scale(1.0f, -1.0f, -1.0f);
        Minecraft mc = Minecraft.getInstance();
        Lighting lighting = mc.gameRenderer.getLighting();
        lighting.setupFor(Lighting.Entry.ITEMS_FLAT);
        this.stack.set(AllDataComponents.SAND_PAPER_POLISHING, (Object)new SandPaperItemComponent(state.stack()));
        FeatureRenderDispatcher renderDispatcher = mc.gameRenderer.getFeatureRenderDispatcher();
        mc.getItemModelResolver().updateForTopItem(this.renderState, this.stack, ItemDisplayContext.GUI, null, null, 0);
        this.renderState.submit(matrices, (SubmitNodeCollector)renderDispatcher.getSubmitNodeStorage(), 0xF000F0, OverlayTexture.NO_OVERLAY, 0);
        renderDispatcher.renderAllFeatures();
    }

    protected String getTextureLabel() {
        return "Sand Paper";
    }

    public Class<SandPaperRenderState> getRenderStateClass() {
        return SandPaperRenderState.class;
    }
}

