/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.ponder;

import com.mojang.serialization.DynamicOps;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.data.FunctionalHelper;
import com.zurrtum.create.client.content.contraptions.glue.SuperGlueSelectionHandler;
import com.zurrtum.create.client.foundation.ponder.element.BeltItemElement;
import com.zurrtum.create.client.foundation.ponder.element.ExpandedParrotElement;
import com.zurrtum.create.client.foundation.ponder.instruction.AnimateBlockEntityInstruction;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.ParrotElement;
import com.zurrtum.create.client.ponder.api.element.ParrotPose;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.PonderSceneBuilder;
import com.zurrtum.create.client.ponder.foundation.element.ElementLinkImpl;
import com.zurrtum.create.client.ponder.foundation.instruction.CreateParrotInstruction;
import com.zurrtum.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.zurrtum.create.content.fluids.pump.PumpBlockEntity;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlock;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.zurrtum.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.kinetics.crafter.ConnectedInputHandler;
import com.zurrtum.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.zurrtum.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.zurrtum.create.content.logistics.funnel.FunnelBlockEntity;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.LinkWithBulbBlockEntity;
import com.zurrtum.create.content.trains.display.FlapDisplayBlockEntity;
import com.zurrtum.create.content.trains.signal.SignalBlockEntity;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.infrastructure.particle.RotationIndicatorParticleData;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class CreateSceneBuilder
extends PonderSceneBuilder {
    private final EffectInstructions effects = new EffectInstructions();
    private final WorldInstructions world = new WorldInstructions();
    private final SpecialInstructions special = new SpecialInstructions();

    public CreateSceneBuilder(SceneBuilder baseSceneBuilder) {
        this(baseSceneBuilder.getScene());
    }

    private CreateSceneBuilder(PonderScene ponderScene) {
        super(ponderScene);
    }

    @Override
    public EffectInstructions effects() {
        return this.effects;
    }

    @Override
    public WorldInstructions world() {
        return this.world;
    }

    @Override
    public SpecialInstructions special() {
        return this.special;
    }

    public class EffectInstructions
    extends PonderSceneBuilder.PonderEffectInstructions {
        public EffectInstructions() {
            super(CreateSceneBuilder.this);
        }

        public void superGlue(BlockPos pos, Direction side, boolean fullBlock) {
            CreateSceneBuilder.this.addInstruction(scene -> SuperGlueSelectionHandler.spawnParticles(scene.getLevel(), pos, side, fullBlock));
        }

        private void rotationIndicator(BlockPos pos, boolean direction, BlockPos displayPos) {
            CreateSceneBuilder.this.addInstruction(scene -> {
                BlockState blockState = scene.getLevel().getBlockState(pos);
                BlockEntity blockEntity = scene.getLevel().getBlockEntity(pos);
                Block patt0$temp = blockState.getBlock();
                if (!(patt0$temp instanceof KineticBlock)) {
                    return;
                }
                KineticBlock kb = (KineticBlock)patt0$temp;
                if (!(blockEntity instanceof KineticBlockEntity)) {
                    return;
                }
                KineticBlockEntity kbe = (KineticBlockEntity)blockEntity;
                Direction.Axis rotationAxis = kb.getRotationAxis(blockState);
                float speed = kbe.getTheoreticalSpeed();
                IRotate.SpeedLevel speedLevel = IRotate.SpeedLevel.of(speed);
                int color = direction ? (speed > 0.0f ? 15425035 : 1476519) : speedLevel.getColor();
                int particleSpeed = speedLevel.getParticleSpeed();
                particleSpeed = (int)((float)particleSpeed * Math.signum(speed));
                Vec3 location = VecHelper.getCenterOf((Vec3i)displayPos);
                RotationIndicatorParticleData particleData = new RotationIndicatorParticleData(color, particleSpeed, kb.getParticleInitialRadius(), kb.getParticleTargetRadius(), 20, rotationAxis);
                for (int i = 0; i < 20; ++i) {
                    scene.getLevel().addParticle(particleData, location.x, location.y, location.z, 0.0, 0.0, 0.0);
                }
            });
        }

        public void rotationSpeedIndicator(BlockPos pos) {
            this.rotationIndicator(pos, false, pos);
        }

        public void rotationDirectionIndicator(BlockPos pos) {
            this.rotationIndicator(pos, true, pos);
        }
    }

    public class WorldInstructions
    extends PonderSceneBuilder.PonderWorldInstructions {
        public WorldInstructions() {
            super(CreateSceneBuilder.this);
        }

        public void rotateBearing(BlockPos pos, float angle, int duration) {
            CreateSceneBuilder.this.addInstruction(AnimateBlockEntityInstruction.bearing(pos, angle, duration));
        }

        public void movePulley(BlockPos pos, float distance, int duration) {
            CreateSceneBuilder.this.addInstruction(AnimateBlockEntityInstruction.pulley(pos, distance, duration));
        }

        public void animateBogey(BlockPos pos, float distance, int duration) {
            CreateSceneBuilder.this.addInstruction(AnimateBlockEntityInstruction.bogey(pos, distance, duration + 1));
        }

        public void moveDeployer(BlockPos pos, float distance, int duration) {
            CreateSceneBuilder.this.addInstruction(AnimateBlockEntityInstruction.deployer(pos, distance, duration));
        }

        public void createItemOnBeltLike(BlockPos location, Direction insertionSide, ItemStack stack) {
            CreateSceneBuilder.this.addInstruction(scene -> {
                PonderLevel world = scene.getLevel();
                BlockEntity blockEntity = world.getBlockEntity(location);
                if (!(blockEntity instanceof SmartBlockEntity)) {
                    return;
                }
                SmartBlockEntity beltBlockEntity = (SmartBlockEntity)blockEntity;
                DirectBeltInputBehaviour behaviour = beltBlockEntity.getBehaviour(DirectBeltInputBehaviour.TYPE);
                if (behaviour == null) {
                    return;
                }
                behaviour.handleInsertion(stack, insertionSide.getOpposite(), false);
            });
            this.flapFunnel(location.above(), true);
        }

        public ElementLink<BeltItemElement> createItemOnBelt(BlockPos beltLocation, Direction insertionSide, ItemStack stack) {
            ElementLinkImpl<BeltItemElement> link = new ElementLinkImpl<BeltItemElement>(BeltItemElement.class);
            CreateSceneBuilder.this.addInstruction(scene -> {
                PonderLevel world = scene.getLevel();
                BlockEntity blockEntity = world.getBlockEntity(beltLocation);
                if (!(blockEntity instanceof BeltBlockEntity)) {
                    return;
                }
                BeltBlockEntity beltBlockEntity = (BeltBlockEntity)blockEntity;
                DirectBeltInputBehaviour behaviour = beltBlockEntity.getBehaviour(DirectBeltInputBehaviour.TYPE);
                behaviour.handleInsertion(stack, insertionSide.getOpposite(), false);
                BeltBlockEntity controllerBE = beltBlockEntity.getControllerBE();
                if (controllerBE != null) {
                    controllerBE.tick();
                }
                TransportedItemStackHandlerBehaviour transporter = beltBlockEntity.getBehaviour(TransportedItemStackHandlerBehaviour.TYPE);
                transporter.handleProcessingOnAllItems(tis -> {
                    BeltItemElement tracker = new BeltItemElement((TransportedItemStack)tis);
                    scene.addElement(tracker);
                    scene.linkElement(tracker, link);
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                });
            });
            this.flapFunnel(beltLocation.above(), true);
            return link;
        }

        public void removeItemsFromBelt(BlockPos beltLocation) {
            CreateSceneBuilder.this.addInstruction(scene -> {
                PonderLevel world = scene.getLevel();
                BlockEntity blockEntity = world.getBlockEntity(beltLocation);
                if (!(blockEntity instanceof SmartBlockEntity)) {
                    return;
                }
                SmartBlockEntity beltBlockEntity = (SmartBlockEntity)blockEntity;
                TransportedItemStackHandlerBehaviour transporter = beltBlockEntity.getBehaviour(TransportedItemStackHandlerBehaviour.TYPE);
                if (transporter == null) {
                    return;
                }
                transporter.handleCenteredProcessingOnAllItems(0.52f, tis -> TransportedItemStackHandlerBehaviour.TransportedResult.removeItem());
            });
        }

        public void stallBeltItem(ElementLink<BeltItemElement> link, boolean stalled) {
            CreateSceneBuilder.this.addInstruction(scene -> {
                BeltItemElement resolve = (BeltItemElement)scene.resolve(link);
                if (resolve != null) {
                    resolve.ifPresent(tis -> {
                        tis.locked = stalled;
                    });
                }
            });
        }

        public void changeBeltItemTo(ElementLink<BeltItemElement> link, ItemStack newStack) {
            CreateSceneBuilder.this.addInstruction(scene -> {
                BeltItemElement resolve = (BeltItemElement)scene.resolve(link);
                if (resolve != null) {
                    resolve.ifPresent(tis -> {
                        tis.stack = newStack;
                    });
                }
            });
        }

        public void setKineticSpeed(Selection selection, float speed) {
            this.modifyKineticSpeed(selection, f -> Float.valueOf(speed));
        }

        public void multiplyKineticSpeed(Selection selection, float modifier) {
            this.modifyKineticSpeed(selection, f -> Float.valueOf(f.floatValue() * modifier));
        }

        public void modifyKineticSpeed(Selection selection, UnaryOperator<Float> speedFunc) {
            this.modifyBlockEntityNBT(selection, SpeedGaugeBlockEntity.class, nbt -> {
                float newSpeed = ((Float)speedFunc.apply(Float.valueOf(nbt.getFloatOr("Speed", 0.0f)))).floatValue();
                nbt.putFloat("Value", SpeedGaugeBlockEntity.getDialTarget(newSpeed));
            });
            this.modifyBlockEntityNBT(selection, KineticBlockEntity.class, nbt -> nbt.putFloat("Speed", ((Float)speedFunc.apply(Float.valueOf(nbt.getFloatOr("Speed", 0.0f)))).floatValue()));
        }

        public void propagatePipeChange(BlockPos pos) {
            this.modifyBlockEntity(pos, PumpBlockEntity.class, be -> be.onSpeedChanged(0.0f));
        }

        public void setFilterData(Selection selection, Class<? extends BlockEntity> teType, ItemStack filter) {
            this.modifyBlockEntityNBT(selection, teType, nbt -> {
                if (!filter.isEmpty()) {
                    RegistryOps ops = CreateSceneBuilder.this.world().getHolderLookupProvider().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
                    nbt.store("Filter", ItemStack.CODEC, (DynamicOps)ops, (Object)filter);
                }
            });
        }

        public void instructArm(BlockPos armLocation, ArmBlockEntity.Phase phase, ItemStack heldItem, int targetedPoint) {
            this.modifyBlockEntityNBT(CreateSceneBuilder.this.scene.getSceneBuildingUtil().select().position(armLocation), ArmBlockEntity.class, compound -> {
                compound.store("Phase", ArmBlockEntity.Phase.CODEC, (Object)phase);
                if (!heldItem.isEmpty()) {
                    RegistryOps ops = CreateSceneBuilder.this.world().getHolderLookupProvider().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
                    compound.store("HeldItem", ItemStack.CODEC, (DynamicOps)ops, (Object)heldItem);
                } else {
                    compound.remove("HeldItem");
                }
                compound.putInt("TargetPointIndex", targetedPoint);
                compound.putFloat("MovementProgress", 0.0f);
            });
        }

        public void flapFunnel(BlockPos position, boolean outward) {
            this.modifyBlockEntity(position, FunnelBlockEntity.class, funnel -> funnel.flap(!outward));
        }

        public void setCraftingResult(BlockPos crafter, ItemStack output) {
            this.modifyBlockEntity(crafter, MechanicalCrafterBlockEntity.class, mct -> mct.setScriptedResult(output));
        }

        public void connectCrafterInvs(BlockPos position1, BlockPos position2) {
            CreateSceneBuilder.this.addInstruction(s -> {
                ConnectedInputHandler.toggleConnection(s.getLevel(), position1, position2);
                s.forEach(WorldSectionElement.class, WorldSectionElement::queueRedraw);
            });
        }

        public void toggleControls(BlockPos position) {
            this.cycleBlockProperty(position, (Property<?>)ControlsBlock.VIRTUAL);
        }

        public void animateTrainStation(BlockPos position, boolean trainPresent) {
            this.modifyBlockEntityNBT(CreateSceneBuilder.this.getScene().getSceneBuildingUtil().select().position(position), StationBlockEntity.class, c -> c.putBoolean("ForceFlag", trainPresent));
        }

        public void conductorBlaze(BlockPos position, boolean conductor) {
            this.modifyBlockEntityNBT(CreateSceneBuilder.this.getScene().getSceneBuildingUtil().select().position(position), BlazeBurnerBlockEntity.class, c -> c.putBoolean("TrainHat", conductor));
        }

        public void changeSignalState(BlockPos position, SignalBlockEntity.SignalState state) {
            this.modifyBlockEntityNBT(CreateSceneBuilder.this.getScene().getSceneBuildingUtil().select().position(position), SignalBlockEntity.class, c -> c.store("State", SignalBlockEntity.SignalState.CODEC, (Object)state));
        }

        public void setDisplayBoardText(BlockPos position, int line, Component text) {
            this.modifyBlockEntity(position, FlapDisplayBlockEntity.class, t -> t.applyTextManually(line, text));
        }

        public void dyeDisplayBoard(BlockPos position, int line, DyeColor color) {
            this.modifyBlockEntity(position, FlapDisplayBlockEntity.class, t -> t.setColour(line, color));
        }

        public void flashDisplayLink(BlockPos position) {
            this.modifyBlockEntity(position, LinkWithBulbBlockEntity.class, LinkWithBulbBlockEntity::pulse);
        }

        @Override
        public void restoreBlocks(Selection selection) {
            super.restoreBlocks(selection);
            this.markSmartBlockEntityVirtual(selection);
        }

        @Override
        public void setBlocks(Selection selection, BlockState state, boolean spawnParticles) {
            super.setBlocks(selection, state, spawnParticles);
            this.markSmartBlockEntityVirtual(selection);
        }

        @Override
        public void modifyBlocks(Selection selection, UnaryOperator<BlockState> stateFunc, boolean spawnParticles) {
            super.modifyBlocks(selection, stateFunc, spawnParticles);
            this.markSmartBlockEntityVirtual(selection);
        }

        private void markSmartBlockEntityVirtual(Selection selection) {
            CreateSceneBuilder.this.addInstruction(scene -> selection.forEach(pos -> {
                BlockEntity patt0$temp = scene.getLevel().getBlockEntity((BlockPos)pos);
                if (patt0$temp instanceof SmartBlockEntity) {
                    SmartBlockEntity smartBlockEntity = (SmartBlockEntity)patt0$temp;
                    smartBlockEntity.markVirtual();
                }
            }));
        }
    }

    public class SpecialInstructions
    extends PonderSceneBuilder.PonderSpecialInstructions {
        public SpecialInstructions() {
            super(CreateSceneBuilder.this);
        }

        @Override
        public ElementLink<ParrotElement> createBirb(Vec3 location, Supplier<? extends ParrotPose> pose) {
            ElementLinkImpl<ParrotElement> link = new ElementLinkImpl<ParrotElement>(ParrotElement.class);
            ParrotElement parrot = ExpandedParrotElement.create(location, pose);
            CreateSceneBuilder.this.addInstruction(new CreateParrotInstruction(10, Direction.DOWN, parrot));
            CreateSceneBuilder.this.addInstruction(scene -> scene.linkElement(parrot, link));
            return link;
        }

        public ElementLink<ParrotElement> birbOnTurntable(BlockPos pos) {
            return this.createBirb(VecHelper.getCenterOf((Vec3i)pos), () -> new ParrotSpinOnComponentPose(pos));
        }

        public ElementLink<ParrotElement> birbOnSpinnyShaft(BlockPos pos) {
            return this.createBirb(VecHelper.getCenterOf((Vec3i)pos).add(0.0, 0.5, 0.0), () -> new ParrotSpinOnComponentPose(pos));
        }

        public void conductorBirb(ElementLink<ParrotElement> birb, boolean conductor) {
            CreateSceneBuilder.this.addInstruction(scene -> scene.resolveOptional(birb).map(FunctionalHelper.filterAndCast(ExpandedParrotElement.class)).ifPresent(expandedBirb -> expandedBirb.setConductor(conductor)));
        }

        public static class ParrotSpinOnComponentPose
        extends ParrotPose {
            private final BlockPos componentPos;

            public ParrotSpinOnComponentPose(BlockPos componentPos) {
                this.componentPos = componentPos;
            }

            @Override
            public void tick(PonderScene scene, Parrot entity, Vec3 location) {
                BlockEntity blockEntity = scene.getLevel().getBlockEntity(this.componentPos);
                if (!(blockEntity instanceof KineticBlockEntity)) {
                    return;
                }
                float rpm = ((KineticBlockEntity)blockEntity).getSpeed();
                entity.yRotO = entity.getYRot();
                entity.setYRot(entity.yRotO + rpm * 0.3f);
            }
        }
    }
}

