/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.itemGroup;

import com.zurrtum.create.client.infrastructure.itemGroup.FabricCreativeInventoryScreen;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;

public class FabricCreativeGuiComponents {
    private static final Identifier BUTTON_TEX = Identifier.fromNamespaceAndPath((String)"fabric", (String)"textures/gui/creative_buttons.png");
    private static final double TABS_PER_PAGE = 10.0;
    public static final Set<CreativeModeTab> COMMON_GROUPS = Set.of(CreativeModeTabs.SEARCH, CreativeModeTabs.INVENTORY, CreativeModeTabs.HOTBAR, CreativeModeTabs.OP_BLOCKS).stream().map(arg_0 -> ((Registry)BuiltInRegistries.CREATIVE_MODE_TAB).getValueOrThrow(arg_0)).collect(Collectors.toSet());

    public static int getPageCount() {
        return (int)Math.ceil((double)((long)CreativeModeTabs.tabs().size() - COMMON_GROUPS.stream().filter(CreativeModeTab::shouldDisplay).count()) / 10.0);
    }

    public static enum Type {
        NEXT((Component)Component.literal((String)">"), FabricCreativeInventoryScreen::fabric_switchToNextPage, screen -> screen.fabric_getCurrentPage() + 1 < screen.fabric_getPageCount()),
        PREVIOUS((Component)Component.literal((String)"<"), FabricCreativeInventoryScreen::fabric_switchToPreviousPage, screen -> screen.fabric_getCurrentPage() != 0);

        final Component text;
        final Consumer<FabricCreativeInventoryScreen> clickConsumer;
        final Predicate<FabricCreativeInventoryScreen> isEnabled;

        private Type(Component text, Consumer<FabricCreativeInventoryScreen> clickConsumer, Predicate<FabricCreativeInventoryScreen> isEnabled) {
            this.text = text;
            this.clickConsumer = clickConsumer;
            this.isEnabled = isEnabled;
        }
    }

    public static class ItemGroupButtonWidget
    extends Button {
        final FabricCreativeInventoryScreen screen;
        final Type type;

        public ItemGroupButtonWidget(int x, int y, Type type, FabricCreativeInventoryScreen screen) {
            super(x, y, 10, 12, type.text, bw -> type.clickConsumer.accept(screen), Button.DEFAULT_NARRATION);
            this.type = type;
            this.screen = screen;
        }

        protected void renderContents(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            this.active = this.type.isEnabled.test(this.screen);
            this.visible = this.screen.fabric_hasAdditionalPages();
            if (!this.visible) {
                return;
            }
            int u = this.active && this.isHovered() ? 20 : 0;
            int v = this.active ? 0 : 12;
            drawContext.blit(RenderPipelines.GUI_TEXTURED, BUTTON_TEX, this.getX(), this.getY(), (float)(u + (this.type == Type.NEXT ? 10 : 0)), (float)v, 10, 12, 256, 256);
            if (this.isHovered()) {
                drawContext.setTooltipForNextFrame(Minecraft.getInstance().font, (Component)Component.translatable((String)"fabric.gui.creativeTabPage", (Object[])new Object[]{this.screen.fabric_getCurrentPage() + 1, FabricCreativeGuiComponents.getPageCount()}), mouseX, mouseY);
            }
        }
    }
}

