/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.foundation.block.connected.CTSpriteShiftEntry;
import com.zurrtum.create.client.foundation.block.connected.CTType;
import com.zurrtum.create.client.foundation.block.connected.ConnectedTextureBehaviour;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import com.zurrtum.create.client.model.NormalsBakedQuad;
import com.zurrtum.create.content.decoration.copycat.CopycatBlock;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.client.model.geom.builders.UVPair;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class CTModel
extends WrapperBlockStateModel {
    private final ConnectedTextureBehaviour behaviour;

    public CTModel(BlockState state, BlockStateModel.UnbakedRoot unbaked, ConnectedTextureBehaviour behaviour) {
        super(state, unbaked);
        this.behaviour = behaviour;
    }

    public static BiFunction<BlockState, BlockStateModel.UnbakedRoot, BlockStateModel.UnbakedRoot> of(ConnectedTextureBehaviour behaviour) {
        return (state, unbaked) -> new CTModel((BlockState)state, (BlockStateModel.UnbakedRoot)unbaked, behaviour);
    }

    @Override
    public void addPartsWithInfo(BlockAndTintGetter world, BlockPos pos, BlockState state, RandomSource random, List<BlockModelPart> parts) {
        int[] indices = this.createCTData(world, pos, state);
        for (BlockModelPart part : this.model.collectParts(random)) {
            QuadCollection.Builder builder = new QuadCollection.Builder();
            for (BakedQuad quad : part.getQuads(null)) {
                builder.addUnculledFace(this.replaceQuad(state, random, indices[quad.direction().get3DDataValue()], quad));
            }
            for (Direction direction : Iterate.directions) {
                this.addQuads(builder, part, direction, state, random, indices[direction.get3DDataValue()]);
            }
            parts.add((BlockModelPart)new SimpleModelWrapper(builder.build(), part.useAmbientOcclusion(), part.particleIcon()));
        }
    }

    protected void addQuads(QuadCollection.Builder builder, BlockModelPart part, Direction direction, BlockState state, RandomSource random, int index) {
        for (BakedQuad quad : part.getQuads(direction)) {
            builder.addCulledFace(direction, this.replaceQuad(state, random, index, quad));
        }
    }

    private static long calcSpriteUv(long packedUv, CTSpriteShiftEntry spriteShift, int index) {
        float u = UVPair.unpackU((long)packedUv);
        float v = UVPair.unpackV((long)packedUv);
        return UVPair.pack((float)spriteShift.getTargetU(u, index), (float)spriteShift.getTargetV(v, index));
    }

    protected BakedQuad replaceQuad(BlockState state, RandomSource random, int index, BakedQuad quad) {
        if (index == -1) {
            return quad;
        }
        CTSpriteShiftEntry spriteShift = this.behaviour.getShift(state, random, quad.direction(), quad.sprite());
        if (spriteShift == null || quad.sprite() != spriteShift.getOriginal()) {
            return quad;
        }
        BakedQuad newQuad = new BakedQuad(quad.position0(), quad.position1(), quad.position2(), quad.position3(), CTModel.calcSpriteUv(quad.packedUV0(), spriteShift, index), CTModel.calcSpriteUv(quad.packedUV1(), spriteShift, index), CTModel.calcSpriteUv(quad.packedUV2(), spriteShift, index), CTModel.calcSpriteUv(quad.packedUV3(), spriteShift, index), quad.tintIndex(), quad.direction(), quad.sprite(), quad.shade(), quad.lightEmission());
        NormalsBakedQuad.setNormals(newQuad, NormalsBakedQuad.getNormals(quad));
        return newQuad;
    }

    protected int[] createCTData(BlockAndTintGetter world, BlockPos pos, BlockState state) {
        int[] indices = new int[6];
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction face : Iterate.directions) {
            CopycatBlock ufb;
            Block block;
            BlockState actualState = world.getBlockState(pos);
            if (!(this.behaviour.buildContextForOccludedDirections() || Block.shouldRenderFace((BlockState)state, (BlockState)world.getBlockState((BlockPos)mutablePos.setWithOffset((Vec3i)pos, face)), (Direction)face) || (block = actualState.getBlock()) instanceof CopycatBlock && !(ufb = (CopycatBlock)block).canFaceBeOccluded(actualState, face))) {
                indices[face.get3DDataValue()] = -1;
                continue;
            }
            CTType dataType = this.behaviour.getDataType(world, pos, state, face);
            if (dataType == null) {
                indices[face.get3DDataValue()] = -1;
                continue;
            }
            ConnectedTextureBehaviour.CTContext context = this.behaviour.buildContext(world, pos, state, face, dataType.getContextRequirement());
            indices[face.get3DDataValue()] = dataType.getTextureIndex(context);
        }
        return indices;
    }
}

