/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Suppliers;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.infrastructure.component.ClipboardContent;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

public class ClipboardModel
implements ItemModel {
    public static final Identifier ID = Identifier.fromNamespaceAndPath((String)"create", (String)"model/clipboard");
    public static final Identifier EMPTY_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/clipboard_0");
    public static final Identifier WRITTEN_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/clipboard_1");
    public static final Identifier EDITING_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/clipboard_2");
    private final RenderType layer = Sheets.translucentItemSheet();
    private final ModelData[] models;

    public ClipboardModel(ModelData[] models) {
        this.models = models;
    }

    public void update(ItemStackRenderState state, ItemStack stack, ItemModelResolver resolver, ItemDisplayContext displayContext, @Nullable ClientLevel world, @Nullable ItemOwner user, int seed) {
        int index = ((ClipboardContent)stack.getOrDefault(AllDataComponents.CLIPBOARD_CONTENT, (Object)ClipboardContent.EMPTY)).type().ordinal();
        state.appendModelIdentityElement((Object)this);
        state.appendModelIdentityElement((Object)index);
        this.models[index].update(state, this.layer, displayContext);
    }

    public record ModelData(List<BakedQuad> quads, ModelRenderProperties settings, Supplier<Vector3fc[]> vector) {
        public static ModelData bake(ModelBaker baker, Identifier id) {
            ResolvedModel model = baker.getModel(id);
            TextureSlots textures = model.getTopTextureSlots();
            List quads = model.bakeTopGeometry(textures, baker, (ModelState)BlockModelRotation.IDENTITY).getAll();
            ModelRenderProperties settings = ModelRenderProperties.fromResolvedModel((ModelBaker)baker, (ResolvedModel)model, (TextureSlots)textures);
            return new ModelData(quads, settings, (Supplier<Vector3fc[]>)Suppliers.memoize(() -> BlockModelWrapper.computeExtents((List)quads)));
        }

        public void update(ItemStackRenderState state, RenderType layer, ItemDisplayContext displayContext) {
            ItemStackRenderState.LayerRenderState layerRenderState = state.newLayer();
            layerRenderState.setRenderType(layer);
            layerRenderState.setExtents(this.vector);
            this.settings.applyToLayer(layerRenderState, displayContext);
            layerRenderState.prepareQuadList().addAll(this.quads);
        }
    }

    public static class Unbaked
    implements ItemModel.Unbaked {
        public static final MapCodec<Unbaked> CODEC = MapCodec.unit(Unbaked::new);

        public MapCodec<Unbaked> type() {
            return CODEC;
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.markDependency(EMPTY_ID);
            resolver.markDependency(WRITTEN_ID);
            resolver.markDependency(EDITING_ID);
        }

        public ItemModel bake(ItemModel.BakingContext context) {
            ModelBaker baker = context.blockModelBaker();
            ModelData[] models = new ModelData[]{ModelData.bake(baker, EMPTY_ID), ModelData.bake(baker, WRITTEN_ID), ModelData.bake(baker, EDITING_ID)};
            return new ClipboardModel(models);
        }
    }
}

