/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import com.zurrtum.create.content.decoration.copycat.CopycatBlock;
import com.zurrtum.create.content.decoration.copycat.CopycatBlockEntity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class CopycatModel
extends WrapperBlockStateModel {
    public CopycatModel(BlockState state, BlockStateModel.UnbakedRoot unbaked) {
        super(state, unbaked);
    }

    public static ChunkSectionLayer getLayer(BlockAndTintGetter world, BlockPos pos) {
        return ItemBlockRenderTypes.getChunkRenderType((BlockState)CopycatBlock.getMaterial((BlockGetter)world, pos));
    }

    public static int getColor(BlockState state, BlockAndTintGetter world, BlockPos pos, int i) {
        if (world == null || pos == null) {
            return GrassColor.getDefaultColor();
        }
        return Minecraft.getInstance().getBlockColors().getColor(CopycatBlock.getMaterial((BlockGetter)world, pos), world, pos, i);
    }

    @Override
    public void addPartsWithInfo(BlockAndTintGetter world, BlockPos pos, BlockState state, RandomSource random, List<BlockModelPart> parts) {
        Block block = state.getBlock();
        if (!(block instanceof CopycatBlock)) {
            return;
        }
        CopycatBlock block2 = (CopycatBlock)block;
        CopycatBlockEntity copycat = (CopycatBlockEntity)world.getBlockEntity(pos);
        BlockState material = copycat == null ? AllBlocks.COPYCAT_BASE.defaultBlockState() : copycat.getMaterial();
        this.addPartsWithInfo(world, pos, state, block2, material, random, parts);
    }

    protected abstract void addPartsWithInfo(BlockAndTintGetter var1, BlockPos var2, BlockState var3, CopycatBlock var4, BlockState var5, RandomSource var6, List<BlockModelPart> var7);

    protected static BlockStateModel getModelOf(BlockState material) {
        return Minecraft.getInstance().getBlockRenderer().getBlockModel(material);
    }

    @Override
    public TextureAtlasSprite particleSpriteWithInfo(BlockAndTintGetter world, BlockPos pos, BlockState state) {
        CopycatBlockEntity copycat = (CopycatBlockEntity)world.getBlockEntity(pos);
        if (copycat == null) {
            return this.model.particleIcon();
        }
        return CopycatModel.getModelOf(copycat.getMaterial()).particleIcon();
    }

    protected void addModelParts(BlockAndTintGetter world, BlockPos pos, BlockState material, RandomSource random, BlockStateModel model, List<BlockModelPart> parts) {
        BlockStateModel blockStateModel = WrapperBlockStateModel.unwrapCompat(model);
        if (blockStateModel instanceof WrapperBlockStateModel) {
            WrapperBlockStateModel wrapper = (WrapperBlockStateModel)blockStateModel;
            wrapper.addPartsWithInfo(world, pos, material, random, parts);
        } else {
            model.collectParts(random, parts);
        }
    }

    protected List<BlockModelPart> getMaterialParts(BlockAndTintGetter world, BlockPos pos, BlockState material, RandomSource random, BlockStateModel model) {
        ObjectArrayList parts = new ObjectArrayList();
        this.addModelParts(world, pos, material, random, model, (List<BlockModelPart>)parts);
        return parts;
    }

    protected OcclusionData gatherOcclusionData(BlockAndTintGetter world, BlockPos pos, BlockState state, BlockState material, CopycatBlock copycatBlock) {
        OcclusionData occlusionData = new OcclusionData();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction face : Iterate.directions) {
            if (!copycatBlock.canFaceBeOccluded(state, face) || Block.shouldRenderFace((BlockState)material, (BlockState)world.getBlockState((BlockPos)mutablePos.setWithOffset((Vec3i)pos, face)), (Direction)face)) continue;
            occlusionData.occlude(face);
        }
        return occlusionData;
    }

    protected static class OcclusionData {
        private final boolean[] occluded = new boolean[6];

        public void occlude(Direction face) {
            this.occluded[face.get3DDataValue()] = true;
        }

        public boolean isOccluded(Direction face) {
            return face != null && this.occluded[face.get3DDataValue()];
        }
    }
}

