/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.foundation.model.BakedModelHelper;
import com.zurrtum.create.client.infrastructure.model.CopycatModel;
import com.zurrtum.create.client.model.NormalsBakedQuad;
import com.zurrtum.create.content.decoration.copycat.CopycatBlock;
import com.zurrtum.create.content.decoration.copycat.CopycatPanelBlock;
import com.zurrtum.create.content.decoration.copycat.CopycatSpecialCases;
import com.zurrtum.create.foundation.block.WrenchableDirectionalBlock;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CopycatPanelModel
extends CopycatModel {
    protected static final AABB CUBE_AABB = new AABB(BlockPos.ZERO);

    public CopycatPanelModel(BlockState state, BlockStateModel.UnbakedRoot unbaked) {
        super(state, unbaked);
    }

    @Override
    public void addPartsWithInfo(BlockAndTintGetter world, BlockPos pos, BlockState state, CopycatBlock block, BlockState material, RandomSource random, List<BlockModelPart> parts) {
        if (CopycatSpecialCases.isTrapdoorMaterial(material)) {
            this.addModelParts(world, pos, material, random, CopycatPanelModel.getModelOf(material), parts);
            return;
        }
        CopycatModel.OcclusionData occlusionData = this.gatherOcclusionData(world, pos, state, material, block);
        if (CopycatSpecialCases.isBarsMaterial(material)) {
            Direction facing = (Direction)state.getValueOrElse(CopycatPanelBlock.FACING, (Comparable)Direction.UP);
            BlockState bars = (BlockState)AllBlocks.COPYCAT_BARS.defaultBlockState().setValue((Property)WrenchableDirectionalBlock.FACING, (Comparable)facing);
            BlockStateModel model = CopycatPanelModel.getModelOf(material);
            this.addBarsParts(occlusionData, state, block, model.particleIcon(), this.getMaterialParts(world, pos, material, random, model), this.getMaterialParts(world, pos, material, random, CopycatPanelModel.getModelOf(bars)), parts);
        } else {
            this.addPanelParts(occlusionData, state, block, this.getMaterialParts(world, pos, material, random, CopycatPanelModel.getModelOf(material)), parts);
        }
    }

    protected void addBarsParts(CopycatModel.OcclusionData occlusionData, BlockState state, CopycatBlock block, TextureAtlasSprite particle, List<BlockModelPart> material, List<BlockModelPart> original, List<BlockModelPart> parts) {
        boolean vertical = ((Direction)state.getValue(CopycatPanelBlock.FACING)).getAxis() == Direction.Axis.Y;
        TextureAtlasSprite findSprite = null;
        for (BlockModelPart part : original) {
            QuadCollection.Builder builder = new QuadCollection.Builder();
            this.addBarsCroppedQuads(particle, part.getQuads(null), arg_0 -> ((QuadCollection.Builder)builder).addUnculledFace(arg_0));
            for (Direction direction : Iterate.directions) {
                if (occlusionData.isOccluded(direction)) continue;
                List quads = part.getQuads(direction);
                TextureAtlasSprite targetSprite = particle;
                if (vertical || direction.getAxis() == Direction.Axis.Y) {
                    if (findSprite != null) {
                        targetSprite = findSprite;
                    } else {
                        block2: for (BlockModelPart materialPart : material) {
                            for (BakedQuad quad2 : materialPart.getQuads(null)) {
                                if (quad2.direction() != Direction.UP) continue;
                                targetSprite = findSprite = quad2.sprite();
                                continue block2;
                            }
                        }
                        if (findSprite == null) {
                            findSprite = particle;
                        }
                    }
                }
                this.addBarsCroppedQuads(targetSprite, quads, block.shouldFaceAlwaysRender(state, direction) ? arg_0 -> ((QuadCollection.Builder)builder).addUnculledFace(arg_0) : quad -> builder.addCulledFace(direction, quad));
            }
            parts.add((BlockModelPart)new SimpleModelWrapper(builder.build(), part.useAmbientOcclusion(), part.particleIcon()));
        }
    }

    protected void addBarsCroppedQuads(TextureAtlasSprite targetSprite, List<BakedQuad> quads, Consumer<BakedQuad> consumer) {
        if (targetSprite == null) {
            quads.forEach(consumer);
            return;
        }
        for (BakedQuad quad : quads) {
            TextureAtlasSprite original = quad.sprite();
            BakedQuad newQuad = new BakedQuad(quad.position0(), quad.position1(), quad.position2(), quad.position3(), BakedModelHelper.calcSpriteUv(quad.packedUV0(), original, targetSprite), BakedModelHelper.calcSpriteUv(quad.packedUV1(), original, targetSprite), BakedModelHelper.calcSpriteUv(quad.packedUV2(), original, targetSprite), BakedModelHelper.calcSpriteUv(quad.packedUV3(), original, targetSprite), quad.tintIndex(), quad.direction(), quad.sprite(), quad.shade(), quad.lightEmission());
            NormalsBakedQuad.setNormals(newQuad, NormalsBakedQuad.getNormals(quad));
            consumer.accept(newQuad);
        }
    }

    protected void addPanelParts(CopycatModel.OcclusionData occlusionData, BlockState state, CopycatBlock block, List<BlockModelPart> original, List<BlockModelPart> parts) {
        if (original.isEmpty()) {
            return;
        }
        Direction facing = (Direction)state.getValueOrElse(CopycatPanelBlock.FACING, (Comparable)Direction.UP);
        Vec3 normal = Vec3.atLowerCornerOf((Vec3i)facing.getUnitVec3i());
        Vec3 normalScaled14 = normal.scale(0.875);
        Vec3 frontNormalScaledN13 = normal.scale(0.0);
        Vec3 normalScaledN13 = normal.scale(-0.8125);
        double frontContract = 0.9375;
        double contract = 0.875;
        AABB frontBB = CUBE_AABB.contract(normal.x * frontContract, normal.y * frontContract, normal.z * frontContract);
        AABB bb = CUBE_AABB.contract(normal.x * contract, normal.y * contract, normal.z * contract).move(normalScaled14);
        for (BlockModelPart part : original) {
            QuadCollection.Builder builder = new QuadCollection.Builder();
            this.addPanelCroppedQuads(facing, frontBB, bb, frontNormalScaledN13, normalScaledN13, part.getQuads(null), arg_0 -> ((QuadCollection.Builder)builder).addUnculledFace(arg_0));
            for (Direction direction : Iterate.directions) {
                if (occlusionData.isOccluded(direction)) continue;
                this.addPanelCroppedQuads(facing, frontBB, bb, frontNormalScaledN13, normalScaledN13, part.getQuads(direction), block.shouldFaceAlwaysRender(state, direction) ? arg_0 -> ((QuadCollection.Builder)builder).addUnculledFace(arg_0) : quad -> builder.addCulledFace(direction, quad));
            }
            parts.add((BlockModelPart)new SimpleModelWrapper(builder.build(), part.useAmbientOcclusion(), part.particleIcon()));
        }
    }

    protected void addPanelCroppedQuads(Direction facing, AABB frontBB, AABB bb, Vec3 frontNormalScaledN13, Vec3 normalScaledN13, List<BakedQuad> quads, Consumer<BakedQuad> consumer) {
        int size = quads.size();
        if (size == 0) {
            return;
        }
        for (boolean front : Iterate.trueAndFalse) {
            Vec3 move;
            AABB crop;
            if (front) {
                crop = frontBB;
                move = frontNormalScaledN13;
            } else {
                crop = bb;
                move = normalScaledN13;
            }
            for (int i = 0; i < size; ++i) {
                BakedQuad quad = quads.get(i);
                Direction direction = quad.direction();
                if (front && direction == facing || !front && direction == facing.getOpposite()) continue;
                consumer.accept(BakedModelHelper.cropAndMove(quad, crop, move));
            }
        }
    }
}

