/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.content.equipment.extendoGrip.ExtendoGripRenderHandler;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class ExtendoGripModel
implements ItemModel,
SpecialModelRenderer<RenderData> {
    public static final Identifier ID = Identifier.fromNamespaceAndPath((String)"create", (String)"model/extendo_grip");
    public static final Identifier ITEM_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/extendo_grip/item");
    public static final Identifier POLE_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/extendo_grip/pole");
    public static final Identifier COG_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/extendo_grip/cog");
    public static final Identifier THIN_SHORT_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/extendo_grip/thin_short");
    public static final Identifier WIDE_SHORT_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/extendo_grip/wide_short");
    public static final Identifier THIN_LONG_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/extendo_grip/thin_long");
    public static final Identifier WIDE_LONG_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/extendo_grip/wide_long");
    public static final Identifier DEPLOYER_HAND_POINTING = Identifier.fromNamespaceAndPath((String)"create", (String)"block/deployer/hand_pointing");
    public static final Identifier DEPLOYER_HAND_PUNCHING = Identifier.fromNamespaceAndPath((String)"create", (String)"block/deployer/hand_punching");
    public static final Identifier DEPLOYER_HAND_HOLDING = Identifier.fromNamespaceAndPath((String)"create", (String)"block/deployer/hand_holding");
    private final RenderType itemLayer = Sheets.translucentItemSheet();
    private final RenderType blockLayer = Sheets.translucentBlockItemSheet();
    private final int[] tints = new int[0];
    private final ModelRenderProperties settings;
    private final Supplier<Vector3fc[]> vector;
    private final List<BakedQuad> item;
    private final List<BakedQuad> pole;
    private final List<BakedQuad> cog;
    private final List<BakedQuad> thinShort;
    private final List<BakedQuad> wideShort;
    private final List<BakedQuad> thinLong;
    private final List<BakedQuad> wideLong;
    private final List<BakedQuad> pointing;
    private final List<BakedQuad> punching;
    private final List<BakedQuad> holding;

    public ExtendoGripModel(ModelRenderProperties settings, List<BakedQuad> item, List<BakedQuad> pole, List<BakedQuad> cog, List<BakedQuad> thinShort, List<BakedQuad> wideShort, List<BakedQuad> thinLong, List<BakedQuad> wideLong, List<BakedQuad> pointing, List<BakedQuad> punching, List<BakedQuad> holding) {
        this.settings = settings;
        this.item = item;
        this.pole = pole;
        this.vector = Suppliers.memoize(() -> BlockModelWrapper.computeExtents((List)item));
        this.cog = cog;
        this.thinShort = thinShort;
        this.wideShort = wideShort;
        this.thinLong = thinLong;
        this.wideLong = wideLong;
        this.pointing = pointing;
        this.punching = punching;
        this.holding = holding;
    }

    public void update(ItemStackRenderState state, ItemStack stack, ItemModelResolver resolver, ItemDisplayContext displayContext, @Nullable ClientLevel world, @Nullable ItemOwner ctx, int seed) {
        boolean rightHand;
        state.appendModelIdentityElement((Object)this);
        state.setAnimated();
        RenderData data = new RenderData();
        data.animation = 0.25f;
        boolean leftHand = displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
        boolean bl = rightHand = displayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
        if (leftHand || rightHand) {
            data.animation = Mth.lerp((float)AnimationTickHolder.getPartialTicks(), (float)ExtendoGripRenderHandler.lastMainHandAnimation, (float)ExtendoGripRenderHandler.mainHandAnimation);
        }
        data.animation = data.animation * data.animation * data.animation;
        float extensionAngle = Mth.lerp((float)data.animation, (float)24.0f, (float)156.0f);
        data.state = state.newLayer();
        data.state.setRenderType(this.itemLayer);
        data.state.setExtents(this.vector);
        this.settings.applyToLayer(data.state, displayContext);
        data.state.prepareQuadList().addAll(this.item);
        data.halfAngle = extensionAngle / 2.0f;
        data.oppositeAngle = 180.0f - extensionAngle;
        data.hand = leftHand || rightHand ? (ExtendoGripRenderHandler.holding ? this.holding : this.punching) : this.pointing;
        data.angle = AnimationTickHolder.getRenderTime() * -2.0f;
        if (leftHand || rightHand) {
            data.angle += 360.0f * data.animation;
        }
        data.angle %= 360.0f;
        if (stack == null) {
            data.self = true;
        } else if (!stack.is((Item)AllItems.EXTENDO_GRIP)) {
            data.item = new ItemStackRenderState();
            data.item.displayContext = displayContext;
            resolver.appendItemLayers(data.item, stack, displayContext, (Level)world, ctx, seed);
            HumanoidArm mainArm = HumanoidArm.RIGHT;
            if (ctx instanceof Avatar) {
                Avatar entity = (Avatar)ctx;
                mainArm = entity.getMainArm();
            } else {
                LocalPlayer player = Minecraft.getInstance().player;
                if (player != null) {
                    mainArm = player.getMainArm();
                }
            }
            data.flip = rightHand ^ mainArm == HumanoidArm.LEFT ? 1 : -1;
        }
        data.state.setupSpecialModel((SpecialModelRenderer)this, (Object)data);
    }

    public void submit(RenderData data, ItemDisplayContext displayContext, PoseStack matrices, SubmitNodeCollector queue, int light, int overlay, boolean glint, int i) {
        assert (data != null);
        if (data.self) {
            data.self = false;
            matrices.pushPose();
            matrices.translate(0.45f, 0.65f, -0.7f - data.animation * 2.25f);
            this.settings.transforms().getTransform(displayContext).apply(displayContext.leftHand(), matrices.last());
            this.submit(data, displayContext, matrices, queue, light, overlay, glint, i);
            matrices.popPose();
        } else if (data.item != null) {
            matrices.pushPose();
            matrices.translate(0.45f, 0.65f, -0.7f - data.animation * 2.25f);
            if (data.item.usesBlockLight()) {
                matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)(data.flip * 45)));
                matrices.translate((float)data.flip * 0.15f, -0.15f, -0.05f);
                matrices.scale(1.25f, 1.25f, 1.25f);
            }
            data.item.submit(matrices, queue, light, overlay, i);
            matrices.popPose();
        }
        ItemStackRenderState.LayerRenderState grip = data.state;
        queue.submitItem(matrices, displayContext, light, overlay, 0, grip.tintLayers, grip.quads, grip.renderType, grip.foilType);
        this.renderQuads(displayContext, matrices, queue, light, overlay, this.pole, this.blockLayer);
        matrices.pushPose();
        matrices.translate(0.0f, 0.5625f, 0.0625f);
        matrices.scale(1.0f, 1.0f, 1.0f + data.animation);
        matrices.pushPose();
        matrices.mulPose((Quaternionfc)Axis.XN.rotationDegrees(data.halfAngle));
        this.renderQuads(displayContext, matrices, queue, light, overlay, this.thinShort, this.itemLayer);
        matrices.translate(0.0f, 0.34375f, 0.0f);
        matrices.mulPose((Quaternionfc)Axis.XN.rotationDegrees(data.oppositeAngle));
        this.renderQuads(displayContext, matrices, queue, light, overlay, this.wideLong, this.itemLayer);
        matrices.translate(0.0f, 0.6875f, 0.0f);
        matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(data.oppositeAngle));
        matrices.translate(0.0f, 0.03125f, 0.0f);
        this.renderQuads(displayContext, matrices, queue, light, overlay, this.thinShort, this.itemLayer);
        matrices.popPose();
        matrices.pushPose();
        matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-180.0f + data.halfAngle));
        this.renderQuads(displayContext, matrices, queue, light, overlay, this.wideShort, this.itemLayer);
        matrices.translate(0.0f, 0.34375f, 0.0f);
        matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(data.oppositeAngle));
        this.renderQuads(displayContext, matrices, queue, light, overlay, this.thinLong, this.itemLayer);
        matrices.translate(0.0f, 0.6875f, 0.0f);
        matrices.mulPose((Quaternionfc)Axis.XN.rotationDegrees(data.oppositeAngle));
        matrices.translate(0.0f, 0.03125f, 0.0f);
        this.renderQuads(displayContext, matrices, queue, light, overlay, this.wideShort, this.itemLayer);
        matrices.translate(0.0f, 0.34375f, 0.0f);
        matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f - data.halfAngle));
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        matrices.translate(0.0f, 0.0f, -0.25f);
        matrices.scale(1.0f, 1.0f, 1.0f / (1.0f + data.animation));
        matrices.translate(-1.0f, -0.5f, -0.5f);
        this.renderQuads(displayContext, matrices, queue, light, overlay, data.hand, this.blockLayer);
        matrices.popPose();
        matrices.popPose();
        matrices.pushPose();
        matrices.translate(0.5f, 0.5625f, 0.5f);
        matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(data.angle));
        matrices.translate(-0.5f, -0.5625f, -0.5f);
        this.renderQuads(displayContext, matrices, queue, light, overlay, this.cog, this.blockLayer);
        matrices.popPose();
    }

    private void renderQuads(ItemDisplayContext displayContext, PoseStack matrices, SubmitNodeCollector queue, int light, int overlay, List<BakedQuad> quads, RenderType layer) {
        queue.submitItem(matrices, displayContext, light, overlay, 0, this.tints, quads, layer, ItemStackRenderState.FoilType.NONE);
    }

    public void getExtents(Consumer<Vector3fc> output) {
        throw new UnsupportedOperationException();
    }

    public RenderData extractArgument(ItemStack stack) {
        throw new UnsupportedOperationException();
    }

    public static class RenderData {
        ItemStackRenderState item;
        ItemStackRenderState.LayerRenderState state;
        List<BakedQuad> hand;
        float halfAngle;
        float oppositeAngle;
        float animation;
        float angle;
        boolean self;
        int flip;
    }

    public static class Unbaked
    implements ItemModel.Unbaked {
        public static final MapCodec<Unbaked> CODEC = MapCodec.unit(Unbaked::new);

        public MapCodec<Unbaked> type() {
            return CODEC;
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.markDependency(ITEM_ID);
            resolver.markDependency(POLE_ID);
            resolver.markDependency(COG_ID);
            resolver.markDependency(THIN_SHORT_ID);
            resolver.markDependency(WIDE_SHORT_ID);
            resolver.markDependency(THIN_LONG_ID);
            resolver.markDependency(WIDE_LONG_ID);
            resolver.markDependency(DEPLOYER_HAND_POINTING);
            resolver.markDependency(DEPLOYER_HAND_PUNCHING);
            resolver.markDependency(DEPLOYER_HAND_HOLDING);
        }

        public ItemModel bake(ItemModel.BakingContext context) {
            ModelBaker baker = context.blockModelBaker();
            ResolvedModel model = baker.getModel(ITEM_ID);
            TextureSlots textures = model.getTopTextureSlots();
            List quads = model.bakeTopGeometry(textures, baker, (ModelState)BlockModelRotation.IDENTITY).getAll();
            ModelRenderProperties settings = ModelRenderProperties.fromResolvedModel((ModelBaker)baker, (ResolvedModel)model, (TextureSlots)textures);
            return new ExtendoGripModel(settings, quads, Unbaked.bakeQuads(baker, POLE_ID), Unbaked.bakeQuads(baker, COG_ID), Unbaked.bakeQuads(baker, THIN_SHORT_ID), Unbaked.bakeQuads(baker, WIDE_SHORT_ID), Unbaked.bakeQuads(baker, THIN_LONG_ID), Unbaked.bakeQuads(baker, WIDE_LONG_ID), Unbaked.bakeQuads(baker, DEPLOYER_HAND_POINTING), Unbaked.bakeQuads(baker, DEPLOYER_HAND_PUNCHING), Unbaked.bakeQuads(baker, DEPLOYER_HAND_HOLDING));
        }

        private static List<BakedQuad> bakeQuads(ModelBaker baker, Identifier id) {
            ResolvedModel model = baker.getModel(id);
            return model.bakeTopGeometry(model.getTopTextureSlots(), baker, (ModelState)BlockModelRotation.IDENTITY).getAll();
        }
    }
}

