/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.content.redstone.link.controller.LinkedControllerClientHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.util.Util;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class LinkedControllerModel
implements ItemModel,
SpecialModelRenderer<RenderData> {
    public static final Identifier ID = Identifier.fromNamespaceAndPath((String)"create", (String)"model/linked_controller");
    public static final Identifier ITEM_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/linked_controller/item");
    public static final Identifier POWERED_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/linked_controller/powered");
    public static final Identifier TORCH_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/linked_controller/torch");
    public static final Identifier TORCH_OFF_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/linked_controller/torch_off");
    public static final Identifier BUTTON_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/linked_controller/button");
    private static final LerpedFloat equipProgress = LerpedFloat.linear().startWithValue(0.0);
    private static final List<LerpedFloat> buttons = (List)Util.make(new ArrayList(6), list -> {
        for (int i = 0; i < 6; ++i) {
            list.add(LerpedFloat.linear().startWithValue(0.0));
        }
    });
    private final RenderType itemLayer = Sheets.translucentItemSheet();
    private final RenderType blockLayer = Sheets.cutoutBlockSheet();
    private final RenderType cutoutLayer = RenderTypes.cutoutMovingBlock();
    private final int[] tints = new int[0];
    private final ModelRenderProperties settings;
    private final Supplier<Vector3fc[]> vector;
    private final List<BakedQuad> item;
    private final List<BakedQuad> powered;
    private final List<BakedQuad> torch;
    private final List<BakedQuad> torchOff;
    private final List<BakedQuad> button;

    public static void tick(Minecraft mc) {
        if (mc.isPaused()) {
            return;
        }
        boolean active = LinkedControllerClientHandler.MODE != LinkedControllerClientHandler.Mode.IDLE;
        equipProgress.chase(active ? 1.0 : 0.0, 0.2f, LerpedFloat.Chaser.EXP);
        equipProgress.tickChaser();
        if (!active) {
            return;
        }
        for (int i = 0; i < buttons.size(); ++i) {
            LerpedFloat lerpedFloat = buttons.get(i);
            lerpedFloat.chase(LinkedControllerClientHandler.currentlyPressed.contains(i) ? 1.0 : 0.0, 0.4f, LerpedFloat.Chaser.EXP);
            lerpedFloat.tickChaser();
        }
    }

    public static void resetButtons() {
        for (LerpedFloat button : buttons) {
            button.startWithValue(0.0);
        }
    }

    public LinkedControllerModel(ModelRenderProperties settings, List<BakedQuad> item, List<BakedQuad> powered, List<BakedQuad> torch, List<BakedQuad> torchOff, List<BakedQuad> button) {
        this.settings = settings;
        this.item = item;
        this.vector = Suppliers.memoize(() -> BlockModelWrapper.computeExtents((List)item));
        this.powered = powered;
        this.torch = torch;
        this.torchOff = torchOff;
        this.button = button;
    }

    public void update(ItemStackRenderState state, ItemStack stack, ItemModelResolver resolver, ItemDisplayContext displayContext, @Nullable ClientLevel world, @Nullable ItemOwner user, int seed) {
        boolean noControllerInMain;
        state.appendModelIdentityElement((Object)this);
        state.setAnimated();
        ItemStackRenderState.LayerRenderState layerRenderState = state.newLayer();
        layerRenderState.setExtents(this.vector);
        this.settings.applyToLayer(layerRenderState, displayContext);
        RenderData data = new RenderData();
        Minecraft mc = Minecraft.getInstance();
        boolean rightHanded = mc.options.mainHand().get() == HumanoidArm.RIGHT;
        ItemDisplayContext mainHand = rightHanded ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
        ItemDisplayContext offHand = rightHanded ? ItemDisplayContext.FIRST_PERSON_LEFT_HAND : ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
        boolean bl = noControllerInMain = !mc.player.getMainHandItem().is((Item)AllItems.LINKED_CONTROLLER);
        if (displayContext == mainHand || displayContext == offHand && noControllerInMain) {
            data.equip = true;
            data.active = true;
        }
        if (displayContext == ItemDisplayContext.GUI) {
            if (stack == mc.player.getMainHandItem()) {
                data.active = true;
            }
            if (stack == mc.player.getOffhandItem() && noControllerInMain) {
                data.active = true;
            }
        }
        data.active = data.active & LinkedControllerClientHandler.MODE != LinkedControllerClientHandler.Mode.IDLE;
        layerRenderState.setupSpecialModel((SpecialModelRenderer)this, (Object)data);
    }

    public void submit(RenderData data, ItemDisplayContext displayContext, PoseStack matrices, SubmitNodeCollector queue, int light, int overlay, boolean glint, int i) {
        assert (data != null);
        this.render(displayContext, matrices, queue, light, overlay, true, data.equip, data.active, true);
    }

    public void renderInLectern(ItemDisplayContext displayContext, PoseStack matrices, SubmitNodeCollector queue, int light, int overlay, boolean active, boolean renderDepression) {
        this.render(displayContext, matrices, queue, light, overlay, false, false, active, renderDepression);
    }

    private void render(ItemDisplayContext displayContext, PoseStack matrices, SubmitNodeCollector queue, int light, int overlay, boolean normal, boolean equip, boolean active, boolean renderDepression) {
        float pt = -1.0f;
        matrices.pushPose();
        if (equip) {
            pt = AnimationTickHolder.getPartialTicks();
            float progress = equipProgress.getValue(pt);
            int handModifier = displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND ? -1 : 1;
            matrices.translate(0.0f, progress / 4.0f, progress / 4.0f * (float)handModifier);
            matrices.translate(0.5f, 0.5f, 0.5f);
            matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(progress * -30.0f * (float)handModifier));
            matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(progress * -30.0f));
            matrices.translate(-0.5f, -0.5f, -0.5f);
        }
        this.renderQuads(displayContext, matrices, queue, light, overlay, this.itemLayer, active ? this.powered : this.item);
        if (!active) {
            this.renderQuads(displayContext, matrices, queue, light, overlay, this.blockLayer, this.torchOff);
            matrices.popPose();
            return;
        }
        this.renderQuads(displayContext, matrices, queue, light, overlay, this.cutoutLayer, this.torch);
        if (normal && LinkedControllerClientHandler.MODE == LinkedControllerClientHandler.Mode.BIND) {
            int i = Mth.lerpInt((float)((Mth.sin((double)(AnimationTickHolder.getRenderTime() / 4.0f)) + 1.0f) / 2.0f), (int)5, (int)15);
            light = i << 20;
        }
        float s = 0.0625f;
        float b = s * -0.75f;
        int index = 0;
        if (pt == -1.0f) {
            pt = AnimationTickHolder.getPartialTicks();
        }
        matrices.pushPose();
        matrices.translate(2.0f * s, 0.0f, 8.0f * s);
        this.renderButton(displayContext, matrices, queue, light, overlay, this.button, pt, b, index++, renderDepression);
        matrices.translate(4.0f * s, 0.0f, 0.0f);
        this.renderButton(displayContext, matrices, queue, light, overlay, this.button, pt, b, index++, renderDepression);
        matrices.translate(-2.0f * s, 0.0f, 2.0f * s);
        this.renderButton(displayContext, matrices, queue, light, overlay, this.button, pt, b, index++, renderDepression);
        matrices.translate(0.0f, 0.0f, -4.0f * s);
        this.renderButton(displayContext, matrices, queue, light, overlay, this.button, pt, b, index++, renderDepression);
        matrices.popPose();
        matrices.translate(3.0f * s, 0.0f, 3.0f * s);
        this.renderButton(displayContext, matrices, queue, light, overlay, this.button, pt, b, index++, renderDepression);
        matrices.translate(2.0f * s, 0.0f, 0.0f);
        this.renderButton(displayContext, matrices, queue, light, overlay, this.button, pt, b, index, renderDepression);
        matrices.popPose();
    }

    private void renderButton(ItemDisplayContext displayContext, PoseStack matrices, SubmitNodeCollector queue, int light, int overlay, List<BakedQuad> button, float pt, float b, int index, boolean renderDepression) {
        matrices.pushPose();
        if (renderDepression) {
            float depression = b * buttons.get(index).getValue(pt);
            matrices.translate(0.0f, depression, 0.0f);
        }
        this.renderQuads(displayContext, matrices, queue, light, overlay, this.itemLayer, button);
        matrices.popPose();
    }

    private void renderQuads(ItemDisplayContext displayContext, PoseStack matrices, SubmitNodeCollector queue, int light, int overlay, RenderType layer, List<BakedQuad> quads) {
        queue.submitItem(matrices, displayContext, light, overlay, 0, this.tints, quads, layer, ItemStackRenderState.FoilType.NONE);
    }

    public void getExtents(Consumer<Vector3fc> output) {
        throw new UnsupportedOperationException();
    }

    public RenderData extractArgument(ItemStack stack) {
        throw new UnsupportedOperationException();
    }

    public static class RenderData {
        boolean equip;
        boolean active;
    }

    public static class Unbaked
    implements ItemModel.Unbaked {
        public static final MapCodec<Unbaked> CODEC = MapCodec.unit(Unbaked::new);

        public MapCodec<Unbaked> type() {
            return CODEC;
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.markDependency(ITEM_ID);
            resolver.markDependency(POWERED_ID);
            resolver.markDependency(TORCH_ID);
            resolver.markDependency(TORCH_OFF_ID);
            resolver.markDependency(BUTTON_ID);
        }

        public ItemModel bake(ItemModel.BakingContext context) {
            ModelBaker baker = context.blockModelBaker();
            ResolvedModel model = baker.getModel(ITEM_ID);
            TextureSlots textures = model.getTopTextureSlots();
            List quads = model.bakeTopGeometry(textures, baker, (ModelState)BlockModelRotation.IDENTITY).getAll();
            ModelRenderProperties settings = ModelRenderProperties.fromResolvedModel((ModelBaker)baker, (ResolvedModel)model, (TextureSlots)textures);
            return new LinkedControllerModel(settings, quads, Unbaked.bakeQuads(baker, POWERED_ID), Unbaked.bakeQuads(baker, TORCH_ID), Unbaked.bakeQuads(baker, TORCH_OFF_ID), Unbaked.bakeQuads(baker, BUTTON_ID));
        }

        private static List<BakedQuad> bakeQuads(ModelBaker baker, Identifier id) {
            ResolvedModel model = baker.getModel(id);
            return model.bakeTopGeometry(model.getTopTextureSlots(), baker, (ModelState)BlockModelRotation.IDENTITY).getAll();
        }
    }
}

