/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.color.item.ItemTintSources;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

public class TranslucentModel
implements ItemModel {
    public static final Identifier ID = Identifier.fromNamespaceAndPath((String)"create", (String)"model/translucent");
    private final RenderType layer = Sheets.translucentBlockItemSheet();
    private final List<ItemTintSource> tints;
    private final List<BakedQuad> quads;
    private final Supplier<Vector3fc[]> vector;
    private final ModelRenderProperties settings;
    private final boolean animated;

    public TranslucentModel(List<ItemTintSource> tints, List<BakedQuad> quads, ModelRenderProperties settings) {
        this.tints = tints;
        this.quads = quads;
        this.settings = settings;
        this.vector = Suppliers.memoize(() -> BlockModelWrapper.computeExtents((List)quads));
        boolean bl = false;
        for (BakedQuad bakedQuad : quads) {
            if (!bakedQuad.sprite().contents().isAnimated()) continue;
            bl = true;
            break;
        }
        this.animated = bl;
    }

    public void update(ItemStackRenderState state, ItemStack stack, ItemModelResolver resolver, ItemDisplayContext displayContext, @Nullable ClientLevel world, @Nullable ItemOwner heldItemContext, int seed) {
        state.appendModelIdentityElement((Object)this);
        ItemStackRenderState.LayerRenderState layerRenderState = state.newLayer();
        if (stack.hasFoil()) {
            layerRenderState.setFoilType(ItemStackRenderState.FoilType.STANDARD);
            state.setAnimated();
            state.appendModelIdentityElement((Object)ItemStackRenderState.FoilType.STANDARD);
        }
        int i = this.tints.size();
        int[] is = layerRenderState.prepareTintLayers(i);
        for (int j = 0; j < i; ++j) {
            int k;
            is[j] = k = this.tints.get(j).calculate(stack, world, heldItemContext == null ? null : heldItemContext.asLivingEntity());
            state.appendModelIdentityElement((Object)k);
        }
        layerRenderState.setExtents(this.vector);
        layerRenderState.setRenderType(this.layer);
        this.settings.applyToLayer(layerRenderState, displayContext);
        layerRenderState.prepareQuadList().addAll(this.quads);
        if (this.animated) {
            state.setAnimated();
        }
    }

    public record Unbaked(Identifier model, List<ItemTintSource> tints) implements ItemModel.Unbaked
    {
        public static final MapCodec<Unbaked> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Identifier.CODEC.fieldOf("model").forGetter(Unbaked::model), (App)ItemTintSources.CODEC.listOf().optionalFieldOf("tints", List.of()).forGetter(Unbaked::tints)).apply((Applicative)instance, Unbaked::new));

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.markDependency(this.model);
        }

        public ItemModel bake(ItemModel.BakingContext context) {
            ModelBaker baker = context.blockModelBaker();
            ResolvedModel bakedSimpleModel = baker.getModel(this.model);
            TextureSlots modelTextures = bakedSimpleModel.getTopTextureSlots();
            List list = bakedSimpleModel.bakeTopGeometry(modelTextures, baker, (ModelState)BlockModelRotation.IDENTITY).getAll();
            ModelRenderProperties modelSettings = ModelRenderProperties.fromResolvedModel((ModelBaker)baker, (ResolvedModel)bakedSimpleModel, (TextureSlots)modelTextures);
            return new TranslucentModel(this.tints, list, modelSettings);
        }

        public MapCodec<Unbaked> type() {
            return CODEC;
        }
    }
}

