/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.client.foundation.render.CreateRenderTypes;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.feature.FeatureRenderDispatcher;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.ModelRenderProperties;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class WorldshaperModel
implements ItemModel,
SpecialModelRenderer<RenderData> {
    public static final Identifier ID = Identifier.fromNamespaceAndPath((String)"create", (String)"model/handheld_worldshaper");
    public static final Identifier ITEM_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/handheld_worldshaper/item");
    public static final Identifier CORE_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/handheld_worldshaper/core");
    public static final Identifier CORE_GLOW_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/handheld_worldshaper/core_glow");
    public static final Identifier ACCELERATOR_ID = Identifier.fromNamespaceAndPath((String)"create", (String)"item/handheld_worldshaper/accelerator");
    private static final int[] TINTS = new int[0];
    private static final RandomSource random = RandomSource.create();
    private static final PoseStack matrices = new PoseStack();
    private final RenderType blockLayer = Sheets.translucentBlockItemSheet();
    private final RenderType itemLayer = CreateRenderTypes.itemGlowingSolid();
    private final RenderType translucent = CreateRenderTypes.itemGlowingTranslucent();
    private final ModelRenderProperties settings;
    private final List<BakedQuad> item;
    private final List<BakedQuad> core;
    private final List<BakedQuad> coreGlow;
    private final List<BakedQuad> accelerator;
    private final Supplier<Vector3fc[]> vector;

    public WorldshaperModel(ModelRenderProperties settings, List<BakedQuad> item, List<BakedQuad> core, List<BakedQuad> coreGlow, List<BakedQuad> accelerator) {
        this.settings = settings;
        this.item = item;
        this.core = core;
        this.coreGlow = coreGlow;
        this.accelerator = accelerator;
        this.vector = Suppliers.memoize(() -> {
            HashSet<Vector3fc> set = new HashSet<Vector3fc>();
            WorldshaperModel.addPosition(set, item);
            WorldshaperModel.addPosition(set, core);
            WorldshaperModel.addPosition(set, coreGlow);
            WorldshaperModel.addPosition(set, accelerator);
            return (Vector3fc[])set.toArray(Vector3fc[]::new);
        });
    }

    private static void addPosition(Set<Vector3fc> set, List<BakedQuad> quads) {
        for (BakedQuad bakedQuad : quads) {
            set.add(bakedQuad.position0());
            set.add(bakedQuad.position1());
            set.add(bakedQuad.position2());
            set.add(bakedQuad.position3());
        }
    }

    public void update(ItemStackRenderState state, ItemStack stack, ItemModelResolver resolver, ItemDisplayContext displayContext, @Nullable ClientLevel world, @Nullable ItemOwner user, int seed) {
        state.appendModelIdentityElement((Object)this);
        state.setAnimated();
        ItemStackRenderState.LayerRenderState renderState = state.newLayer();
        renderState.setExtents(this.vector);
        renderState.setUsesBlockLight(this.settings.usesBlockLight());
        renderState.setParticleIcon(this.settings.particleIcon());
        RenderData data = new RenderData();
        data.transform = this.settings.transforms().getTransform(displayContext);
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        boolean mainHand = player.getMainHandItem() == stack;
        data.rightHand = mainHand ^ player.getMainArm() == HumanoidArm.LEFT;
        boolean bl = data.inHand = mainHand || player.getOffhandItem() == stack;
        if (displayContext == ItemDisplayContext.GUI) {
            data.state = (BlockState)stack.get(AllDataComponents.SHAPER_BLOCK_USED);
            data.used = UsedRenderState.create(mc, data.state, displayContext, world, user, seed);
        }
        state.appendModelIdentityElement((Object)data);
        renderState.setupSpecialModel((SpecialModelRenderer)this, (Object)data);
    }

    public void submit(RenderData data, ItemDisplayContext displayContext, PoseStack matrices, SubmitNodeCollector queue, int light, int overlay, boolean glint, int i) {
        assert (data != null);
        matrices.pushPose();
        matrices.translate(0.5f, 0.5f, 0.5f);
        matrices.pushPose();
        data.transform.apply(displayContext.leftHand(), matrices.last());
        WorldshaperModel.renderItem(displayContext, matrices, queue, light, overlay, this.item, this.blockLayer);
        float pt = AnimationTickHolder.getPartialTicks();
        float worldTime = AnimationTickHolder.getRenderTime() / 20.0f;
        float animation = Mth.clamp((float)(Create.ZAPPER_RENDER_HANDLER.getAnimation(data.rightHand, pt) * 5.0f), (float)0.0f, (float)1.0f);
        float multiplier = data.inHand ? animation : Mth.sin((double)(worldTime * 5.0f));
        int lightItensity = (int)(15.0f * Mth.clamp((float)multiplier, (float)0.0f, (float)1.0f));
        int glowLight = LightTexture.pack((int)lightItensity, (int)Math.max(lightItensity, 4));
        WorldshaperModel.renderItem(displayContext, matrices, queue, glowLight, overlay, this.core, this.itemLayer);
        WorldshaperModel.renderItem(displayContext, matrices, queue, glowLight, overlay, this.coreGlow, this.translucent);
        float angle = worldTime * -25.0f;
        if (data.inHand) {
            angle += 360.0f * animation;
        }
        matrices.translate(0.5f, 0.345f, 0.5f);
        matrices.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(angle %= 360.0f));
        matrices.translate(-0.5f, -0.345f, -0.5f);
        WorldshaperModel.renderItem(displayContext, matrices, queue, light, overlay, this.accelerator, this.blockLayer);
        matrices.popPose();
        if (data.used != null) {
            data.used.render(matrices, queue, light, overlay);
        }
        matrices.popPose();
    }

    private static void renderItem(ItemDisplayContext displayContext, PoseStack matrices, SubmitNodeCollector queue, int light, int overlay, List<BakedQuad> item, RenderType layer) {
        queue.submitItem(matrices, displayContext, light, overlay, 0, TINTS, item, layer, ItemStackRenderState.FoilType.NONE);
    }

    public void getExtents(Consumer<Vector3fc> output) {
        throw new UnsupportedOperationException();
    }

    public RenderData extractArgument(ItemStack stack) {
        throw new UnsupportedOperationException();
    }

    public static class RenderData {
        public ItemTransform transform;
        public BlockState state;
        public boolean rightHand;
        public boolean inHand;
        public UsedRenderState used;

        public boolean equals(Object o) {
            if (!(o instanceof RenderData)) {
                return false;
            }
            RenderData data = (RenderData)o;
            return this.transform == data.transform && this.state == data.state && this.rightHand == data.rightHand && this.inHand == data.inHand;
        }

        public int hashCode() {
            return Objects.hash(this.rightHand, this.inHand);
        }
    }

    public static interface UsedRenderState {
        public static UsedRenderState create(Minecraft mc, BlockState state, ItemDisplayContext displayContext, @Nullable ClientLevel world, @Nullable ItemOwner user, int seed) {
            if (state == null) {
                return null;
            }
            Block block = state.getBlock();
            if (block instanceof CrossCollisionBlock) {
                CrossCollisionBlock block2 = (CrossCollisionBlock)block;
                return UsedItemRenderState.create(mc, block2, displayContext, world, user, seed);
            }
            return UsedBlockRenderState.create(mc, state, random, matrices);
        }

        public void render(PoseStack var1, SubmitNodeCollector var2, int var3, int var4);
    }

    public record UsedBlockRenderState(RenderType layer, BlockRenderDispatcher blockRenderManager, PoseStack matrices, SinglePosVirtualBlockGetter world, BlockState state, List<BlockModelPart> parts) implements UsedRenderState,
    SubmitNodeCollector.CustomGeometryRenderer
    {
        public static UsedBlockRenderState create(Minecraft mc, BlockState state, RandomSource random, PoseStack matrices) {
            RenderType layer = ItemBlockRenderTypes.getChunkRenderType((BlockState)state) == ChunkSectionLayer.TRANSLUCENT ? Sheets.translucentItemSheet() : Sheets.cutoutBlockSheet();
            BlockRenderDispatcher blockRenderManager = mc.getBlockRenderer();
            SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
            world.blockState(state);
            random.setSeed(42L);
            List parts = blockRenderManager.getBlockModel(state).collectParts(random);
            return new UsedBlockRenderState(layer, blockRenderManager, matrices, world, state, parts);
        }

        @Override
        public void render(PoseStack matrices, SubmitNodeCollector queue, int light, int overlay) {
            matrices.translate(-0.42f, -0.385f, 0.0f);
            matrices.scale(0.25f, 0.25f, 0.25f);
            matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(30.0f));
            matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(45.0f));
            queue.submitCustomGeometry(matrices, this.layer, (SubmitNodeCollector.CustomGeometryRenderer)this);
        }

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.matrices.last().set(matricesEntry);
            this.blockRenderManager.renderBatched(this.state, BlockPos.ZERO, (BlockAndTintGetter)this.world, this.matrices, vertexConsumer, false, this.parts);
        }
    }

    public record UsedItemRenderState(Lighting diffuseLighting, MultiBufferSource.BufferSource entityVertexConsumers, FeatureRenderDispatcher entityRenderDispatcher, ItemStackRenderState state) implements UsedRenderState
    {
        public static UsedItemRenderState create(Minecraft mc, CrossCollisionBlock block, ItemDisplayContext displayContext, @Nullable ClientLevel world, @Nullable ItemOwner user, int seed) {
            ItemStackRenderState item = new ItemStackRenderState();
            item.displayContext = displayContext;
            mc.getItemModelResolver().appendItemLayers(item, block.asItem().getDefaultInstance(), displayContext, (Level)world, user, seed);
            if (item.usesBlockLight()) {
                return new UsedItemRenderState(null, null, null, item);
            }
            GameRenderer gameRenderer = mc.gameRenderer;
            return new UsedItemRenderState(gameRenderer.getLighting(), mc.renderBuffers().bufferSource(), gameRenderer.getFeatureRenderDispatcher(), item);
        }

        @Override
        public void render(PoseStack matrices, SubmitNodeCollector queue, int light, int overlay) {
            if (this.diffuseLighting != null) {
                this.entityRenderDispatcher.renderAllFeatures();
                this.entityVertexConsumers.endBatch();
                this.diffuseLighting.setupFor(Lighting.Entry.ITEMS_FLAT);
            }
            matrices.translate(-0.242f, -0.278f, 0.0f);
            matrices.scale(0.25f, 0.25f, 0.25f);
            matrices.mulPose((Quaternionfc)Axis.XP.rotationDegrees(30.0f));
            matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(45.0f));
            this.state.submit(matrices, queue, light, overlay, 0);
        }
    }

    public static class Unbaked
    implements ItemModel.Unbaked {
        public static final MapCodec<Unbaked> CODEC = MapCodec.unit(Unbaked::new);

        public MapCodec<? extends ItemModel.Unbaked> type() {
            return CODEC;
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.markDependency(ITEM_ID);
            resolver.markDependency(CORE_ID);
            resolver.markDependency(CORE_GLOW_ID);
            resolver.markDependency(ACCELERATOR_ID);
        }

        public ItemModel bake(ItemModel.BakingContext context) {
            ModelBaker baker = context.blockModelBaker();
            ResolvedModel model = baker.getModel(ITEM_ID);
            TextureSlots textures = model.getTopTextureSlots();
            List quads = model.bakeTopGeometry(textures, baker, (ModelState)BlockModelRotation.IDENTITY).getAll();
            ModelRenderProperties settings = ModelRenderProperties.fromResolvedModel((ModelBaker)baker, (ResolvedModel)model, (TextureSlots)textures);
            return new WorldshaperModel(settings, quads, Unbaked.bake(baker, CORE_ID), Unbaked.bake(baker, CORE_GLOW_ID), Unbaked.bake(baker, ACCELERATOR_ID));
        }

        private static List<BakedQuad> bake(ModelBaker baker, Identifier id) {
            ResolvedModel model = baker.getModel(id);
            return model.bakeTopGeometry(model.getTopTextureSlots(), baker, (ModelState)BlockModelRotation.IDENTITY).getAll();
        }
    }
}

