/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.model;

import java.util.List;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public abstract class WrapperBlockStateModel
implements BlockStateModel,
BlockStateModel.UnbakedRoot {
    private static final boolean FABRIC = FabricLoader.getInstance().isModLoaded("fabric-model-loading-api-v1");
    protected BlockStateModel model;
    protected Function<ModelBaker, BlockStateModel> bake;

    public WrapperBlockStateModel() {
    }

    public WrapperBlockStateModel(BlockState state, BlockStateModel.UnbakedRoot unbaked) {
        this.bake = baker -> unbaked.bake(state, baker);
    }

    public void addPartsWithInfo(BlockAndTintGetter world, BlockPos pos, BlockState state, RandomSource random, List<BlockModelPart> parts) {
        this.collectParts(random, parts);
    }

    public void collectParts(RandomSource random, List<BlockModelPart> parts) {
        this.model.collectParts(random, parts);
    }

    public TextureAtlasSprite particleSpriteWithInfo(BlockAndTintGetter world, BlockPos pos, BlockState state) {
        return this.particleIcon();
    }

    public TextureAtlasSprite particleIcon() {
        return this.model.particleIcon();
    }

    public BlockStateModel bake(BlockState state, ModelBaker baker) {
        if (this.bake != null) {
            this.model = this.bake.apply(baker);
            this.bake = null;
        }
        return this;
    }

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
    }

    public Object visualEqualityGroup(BlockState state) {
        return this;
    }

    public static BlockStateModel unwrapCompat(BlockStateModel model) {
        return model;
    }
}

