/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.particle;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllFluidConfigs;
import com.zurrtum.create.client.infrastructure.fluid.FluidConfig;
import com.zurrtum.create.client.infrastructure.particle.FluidParticle;
import com.zurrtum.create.content.processing.basin.BasinBlock;
import com.zurrtum.create.content.processing.basin.BasinBlockEntity;
import com.zurrtum.create.infrastructure.particle.FluidParticleData;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class BasinFluidParticle
extends FluidParticle {
    BlockPos basinPos;
    Vec3 targetPos;
    Vec3 centerOfBasin;
    float yOffset;

    public BasinFluidParticle(ClientLevel world, Fluid fluid, DataComponentPatch components, FluidConfig config, double x, double y, double z, double vx, double vy, double vz, RandomSource random) {
        super(world, fluid, components, config, x, y, z, vx, vy, vz, random);
        this.gravity = 0.0f;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.yOffset = random.nextFloat() * 1.0f / 32.0f;
        this.quadSize = 0.0f;
        this.lifetime = 60;
        Vec3 currentPos = new Vec3(x, y += (double)this.yOffset, z);
        this.basinPos = BlockPos.containing((Position)currentPos);
        this.centerOfBasin = VecHelper.getCenterOf((Vec3i)this.basinPos);
        if (vx != 0.0) {
            this.lifetime = 20;
            Vec3 centerOf = VecHelper.getCenterOf((Vec3i)this.basinPos);
            Vec3 diff = currentPos.subtract(centerOf).multiply(1.0, 0.0, 1.0).normalize().scale(0.375);
            this.targetPos = centerOf.add(diff);
            this.xo = this.x = this.centerOfBasin.x;
            this.zo = this.z = this.centerOfBasin.z;
        }
    }

    @Override
    public void tick() {
        super.tick();
        float f = this.quadSize = this.targetPos != null ? Math.max(0.03125f, 1.0f * (float)this.age / (float)this.lifetime / 8.0f) : 0.125f * (1.0f - (float)Math.abs(this.age - this.lifetime / 2) / (1.0f * (float)this.lifetime));
        if (this.age % 2 == 0) {
            if (!this.level.getBlockState(this.basinPos).is((Block)AllBlocks.BASIN) && !BasinBlock.isBasin((LevelReader)this.level, this.basinPos)) {
                this.remove();
                return;
            }
            BlockEntity blockEntity = this.level.getBlockEntity(this.basinPos);
            if (blockEntity instanceof BasinBlockEntity) {
                float totalUnits = ((BasinBlockEntity)blockEntity).getTotalFluidUnits(0.0f);
                if (totalUnits < 1.0f) {
                    totalUnits = 0.0f;
                }
                float fluidLevel = Mth.clamp((float)(totalUnits / 162000.0f), (float)0.0f, (float)1.0f);
                this.y = 0.125f + (float)this.basinPos.getY() + 0.75f * fluidLevel + this.yOffset;
            }
        }
        if (this.targetPos != null) {
            float progess = 1.0f * (float)this.age / (float)this.lifetime;
            Vec3 currentPos = this.centerOfBasin.add(this.targetPos.subtract(this.centerOfBasin).scale((double)progess));
            this.x = currentPos.x;
            this.z = currentPos.z;
        }
    }

    @Override
    protected void updateColor() {
        this.alpha = 0.9f;
    }

    @Override
    protected int getLightColor(float p_189214_1_) {
        return 0xF000F0;
    }

    public void extract(QuadParticleRenderState submittable, Camera info, float pt) {
        Quaternionf rotation = info.rotation();
        Quaternionf prevRotation = new Quaternionf((Quaternionfc)rotation);
        rotation.set(-1.0f, 0.0f, 0.0f, 1.0f);
        rotation.normalize();
        super.extract(submittable, info, pt);
        rotation.set(0.0f, 0.0f, 0.0f, 1.0f);
        rotation.mul((Quaternionfc)prevRotation);
    }

    @Override
    protected boolean canEvaporate() {
        return false;
    }

    public static class Factory
    implements ParticleProvider<FluidParticleData> {
        public Particle createParticle(FluidParticleData data, ClientLevel world, double x, double y, double z, double vx, double vy, double vz, RandomSource random) {
            FluidConfig config = AllFluidConfigs.get(data.fluid());
            if (config == null) {
                return null;
            }
            return new BasinFluidParticle(world, data.fluid(), data.components(), config, x, y, z, vx, vy, vz, random);
        }
    }
}

