/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.particle;

import com.zurrtum.create.client.infrastructure.particle.CubeParticleRenderer;
import com.zurrtum.create.client.infrastructure.particle.CubeParticleSubmittable;
import com.zurrtum.create.infrastructure.particle.CubeParticleData;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;

public class CubeParticle
extends Particle {
    protected float scale;
    protected boolean hot;
    protected float red = 1.0f;
    protected float green = 1.0f;
    protected float blue = 1.0f;
    protected float alpha = 1.0f;
    private boolean billowing = false;

    public CubeParticle(ClientLevel world, CubeParticleData data, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z);
        this.xd = motionX;
        this.yd = motionY;
        this.zd = motionZ;
        this.setColor(data.red(), data.green(), data.blue());
        this.setScale(data.scale());
        this.averageAge(data.avgAge());
        this.setHot(data.hot());
    }

    public void setColor(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.setSize(scale * 0.5f, scale * 0.5f);
    }

    public void averageAge(int age) {
        this.lifetime = (int)((double)age + (this.random.nextDouble() * 2.0 - 1.0) * 8.0);
    }

    public void setHot(boolean hot) {
        this.hot = hot;
    }

    public void tick() {
        if (this.hot && this.age > 0) {
            if (this.yo == this.y) {
                this.billowing = true;
                this.stoppedByCollision = false;
                if (this.xd == 0.0 && this.zd == 0.0) {
                    Vec3 diff = Vec3.atLowerCornerOf((Vec3i)BlockPos.containing((double)this.x, (double)this.y, (double)this.z)).add(0.5, 0.5, 0.5).subtract(this.x, this.y, this.z);
                    this.xd = -diff.x * 0.1;
                    this.zd = -diff.z * 0.1;
                }
                this.xd *= 1.1;
                this.yd *= 0.9;
                this.zd *= 1.1;
            } else if (this.billowing) {
                this.yd *= 1.2;
            }
        }
        super.tick();
    }

    public void render(CubeParticleSubmittable submittable, Camera camera, float tickProgress) {
        Vec3 projectedView = camera.position();
        float lerpedX = (float)(Mth.lerp((double)tickProgress, (double)this.xo, (double)this.x) - projectedView.x());
        float lerpedY = (float)(Mth.lerp((double)tickProgress, (double)this.yo, (double)this.y) - projectedView.y());
        float lerpedZ = (float)(Mth.lerp((double)tickProgress, (double)this.zo, (double)this.z) - projectedView.z());
        double ageMultiplier = 1.0 - Math.pow(Mth.clamp((float)((float)this.age + tickProgress), (float)0.0f, (float)this.lifetime), 3.0) / Math.pow(this.lifetime, 3.0);
        float scale = (float)((double)this.scale * ageMultiplier);
        int color = ARGB.colorFromFloat((float)this.alpha, (float)this.red, (float)this.green, (float)this.blue);
        submittable.render(lerpedX, lerpedY, lerpedZ, scale, color);
    }

    public ParticleRenderType getGroup() {
        return CubeParticleRenderer.SHEET;
    }

    public boolean shouldRender(Frustum frustum) {
        return frustum.pointInFrustum(this.x, this.y, this.z);
    }

    public static class Factory
    implements ParticleProvider<CubeParticleData> {
        public Particle createParticle(CubeParticleData data, ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, RandomSource random) {
            return new CubeParticle(world, data, x, y, z, motionX, motionY, motionZ);
        }
    }
}

