/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.particle;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.zurrtum.create.client.infrastructure.particle.CubeParticleRenderer;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.feature.ParticleFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.state.ParticleGroupRenderState;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class CubeParticleSubmittable
implements SubmitNodeCollector.ParticleGroupRenderer,
ParticleGroupRenderState {
    public static final Vector3f[] CUBE = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 1.0f), new Vector3f(-1.0f, -1.0f, -1.0f), new Vector3f(1.0f, -1.0f, -1.0f), new Vector3f(1.0f, -1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, -1.0f), new Vector3f(1.0f, -1.0f, -1.0f), new Vector3f(-1.0f, -1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, 1.0f), new Vector3f(-1.0f, -1.0f, 1.0f), new Vector3f(1.0f, -1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, -1.0f, 1.0f), new Vector3f(1.0f, -1.0f, -1.0f), new Vector3f(1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, 1.0f, -1.0f), new Vector3f(-1.0f, -1.0f, -1.0f), new Vector3f(-1.0f, -1.0f, 1.0f), new Vector3f(-1.0f, 1.0f, 1.0f)};
    private final Vertices vertices = new Vertices();
    private int particles;

    public void render(float x, float y, float z, float scale, int color) {
        this.vertices.vertex(x, y, z, scale, color);
        ++this.particles;
    }

    public void clear() {
        this.vertices.reset();
        this.particles = 0;
    }

    public QuadParticleRenderState.PreparedBuffers prepare(ParticleFeatureRenderer.ParticleBufferCache cache) {
        int i = this.particles * 24;
        try (ByteBufferBuilder bufferAllocator = ByteBufferBuilder.exactlySized((int)(i * DefaultVertexFormat.PARTICLE.getVertexSize()));){
            BufferBuilder bufferBuilder = new BufferBuilder(bufferAllocator, VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
            this.vertices.render((x, y, z, scale, color) -> this.drawFace((VertexConsumer)bufferBuilder, x, y, z, scale, color));
            QuadParticleRenderState.PreparedLayer layer = new QuadParticleRenderState.PreparedLayer(0, this.vertices.nextVertexIndex() * 36);
            MeshData builtBuffer = bufferBuilder.build();
            if (builtBuffer != null) {
                cache.write(builtBuffer.vertexBuffer());
                RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS).getBuffer(builtBuffer.drawState().indexCount());
                GpuBufferSlice gpuBufferSlice = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f());
                QuadParticleRenderState.PreparedBuffers preparedBuffers = new QuadParticleRenderState.PreparedBuffers(builtBuffer.drawState().indexCount(), gpuBufferSlice, Map.of(CubeParticleRenderer.RENDER_TYPE, layer));
                return preparedBuffers;
            }
        }
        return null;
    }

    private void drawFace(VertexConsumer buffer, float x, float y, float z, float scale, int color) {
        int light = 0xF000F0;
        Vector3f vec = new Vector3f();
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 4; ++j) {
                CUBE[i * 4 + j].mul(scale, vec).add(x, y, z);
                buffer.addVertex(vec.x, vec.y, vec.z).setUv((float)j / 2.0f, (float)(j % 2)).setColor(color).setLight(light);
            }
        }
    }

    public void render(QuadParticleRenderState.PreparedBuffers buffers, ParticleFeatureRenderer.ParticleBufferCache cache, RenderPass renderPass, TextureManager manager, boolean translucent) {
        if (translucent) {
            return;
        }
        RenderSystem.AutoStorageIndexBuffer shapeIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS);
        renderPass.setVertexBuffer(0, cache.get());
        renderPass.setIndexBuffer(shapeIndexBuffer.getBuffer(buffers.indexCount()), shapeIndexBuffer.type());
        renderPass.setUniform("DynamicTransforms", buffers.dynamicTransforms());
        for (Map.Entry entry : buffers.layers().entrySet()) {
            renderPass.setPipeline(((SingleQuadParticle.Layer)entry.getKey()).pipeline());
            AbstractTexture texture = manager.getTexture(((SingleQuadParticle.Layer)entry.getKey()).textureAtlasLocation());
            renderPass.bindTexture("Sampler0", texture.getTextureView(), texture.getSampler());
            renderPass.drawIndexed(0, 0, ((QuadParticleRenderState.PreparedLayer)entry.getValue()).indexCount(), 1);
        }
    }

    public void submit(SubmitNodeCollector queue, CameraRenderState cameraRenderState) {
        if (this.particles > 0) {
            queue.submitParticleGroup((SubmitNodeCollector.ParticleGroupRenderer)this);
        }
    }

    public static class Vertices {
        private int maxVertices = 1024;
        private float[] floatData = new float[12288];
        private int[] intData = new int[2048];
        private int nextVertexIndex;

        public void vertex(float x, float y, float z, float scale, int color) {
            if (this.nextVertexIndex >= this.maxVertices) {
                this.increaseCapacity();
            }
            int i = this.nextVertexIndex * 4;
            this.floatData[i++] = x;
            this.floatData[i++] = y;
            this.floatData[i++] = z;
            this.floatData[i] = scale;
            this.intData[this.nextVertexIndex * 2] = color;
            ++this.nextVertexIndex;
        }

        public void render(Consumer consumer) {
            for (int i = 0; i < this.nextVertexIndex; ++i) {
                int j = i * 4;
                consumer.consume(this.floatData[j++], this.floatData[j++], this.floatData[j++], this.floatData[j], this.intData[i]);
            }
        }

        public void reset() {
            this.nextVertexIndex = 0;
        }

        private void increaseCapacity() {
            this.maxVertices *= 2;
            this.floatData = Arrays.copyOf(this.floatData, this.maxVertices * 4);
            this.intData = Arrays.copyOf(this.intData, this.maxVertices);
        }

        public int nextVertexIndex() {
            return this.nextVertexIndex;
        }
    }

    @FunctionalInterface
    public static interface Consumer {
        public void consume(float var1, float var2, float var3, float var4, int var5);
    }
}

