/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.particle;

import com.zurrtum.create.AllFluids;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllFluidConfigs;
import com.zurrtum.create.client.infrastructure.fluid.FluidConfig;
import com.zurrtum.create.infrastructure.particle.FluidParticleData;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.material.Fluid;

public class FluidParticle
extends SingleQuadParticle {
    private final float uo;
    private final float vo;
    private final Fluid fluid;
    private final DataComponentPatch components;
    private final FluidConfig config;

    public FluidParticle(ClientLevel world, Fluid fluid, DataComponentPatch components, FluidConfig config, double x, double y, double z, double vx, double vy, double vz, RandomSource random) {
        super(world, x, y, z, vx, vy, vz, config.still().get());
        this.fluid = fluid;
        this.components = components;
        this.config = config;
        this.gravity = 1.0f;
        this.updateColor();
        this.multiplyColor(config.tint().apply(components));
        this.xd = vx;
        this.yd = vy;
        this.zd = vz;
        this.quadSize /= 2.0f;
        this.uo = random.nextFloat() * 3.0f;
        this.vo = random.nextFloat() * 3.0f;
    }

    protected int getLightColor(float p_189214_1_) {
        int brightnessForRender = super.getLightColor(p_189214_1_);
        int skyLight = brightnessForRender >> 20;
        int blockLight = brightnessForRender >> 4 & 0xF;
        blockLight = Math.max(blockLight, this.fluid.defaultFluidState().createLegacyBlock().getLightEmission());
        return skyLight << 20 | blockLight << 4;
    }

    protected void updateColor() {
        this.rCol = 0.8f;
        this.gCol = 0.8f;
        this.bCol = 0.8f;
    }

    protected void multiplyColor(int color) {
        this.rCol *= (float)(color >> 16 & 0xFF) / 255.0f;
        this.gCol *= (float)(color >> 8 & 0xFF) / 255.0f;
        this.bCol *= (float)(color & 0xFF) / 255.0f;
    }

    protected float getU0() {
        return this.sprite.getU((this.uo + 1.0f) / 4.0f);
    }

    protected float getU1() {
        return this.sprite.getU(this.uo / 4.0f);
    }

    protected float getV0() {
        return this.sprite.getV(this.vo / 4.0f);
    }

    protected float getV1() {
        return this.sprite.getV((this.vo + 1.0f) / 4.0f);
    }

    public void tick() {
        super.tick();
        if (!this.canEvaporate()) {
            return;
        }
        if (this.onGround) {
            this.remove();
        }
        if (!this.removed) {
            return;
        }
        if (!this.onGround && this.random.nextFloat() < 0.125f) {
            return;
        }
        Color color = new Color(this.config.tint().apply(this.components));
        this.level.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)color.getRedAsFloat(), (float)color.getGreenAsFloat(), (float)color.getBlueAsFloat()), this.x, this.y, this.z, 0.0, 0.0, 0.0);
    }

    protected boolean canEvaporate() {
        return this.fluid == AllFluids.POTION;
    }

    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.TERRAIN;
    }

    public static class Factory
    implements ParticleProvider<FluidParticleData> {
        public Particle createParticle(FluidParticleData data, ClientLevel world, double x, double y, double z, double vx, double vy, double vz, RandomSource random) {
            FluidConfig config = AllFluidConfigs.get(data.fluid());
            if (config == null) {
                return null;
            }
            return new FluidParticle(world, data.fluid(), data.components(), config, x, y, z, vx, vy, vz, random);
        }
    }
}

