/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.particle;

import com.mojang.math.Axis;
import com.zurrtum.create.client.infrastructure.particle.SteamJetParticleRenderer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.state.QuadParticleRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class SteamJetParticle
extends SimpleAnimatedParticle {
    private final float yaw;
    private final float pitch;

    protected SteamJetParticle(ClientLevel world, double x, double y, double z, double dx, double dy, double dz, SpriteSet sprite, RandomSource random) {
        super(world, x, y, z, sprite, random.nextFloat() * 0.5f);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.gravity = 0.0f;
        this.quadSize = 0.375f;
        this.setLifetime(21);
        this.setPos(x, y, z);
        this.roll = this.oRoll = random.nextFloat() * (float)Math.PI;
        this.yaw = (float)Mth.atan2((double)dx, (double)dz) - (float)Math.PI;
        this.pitch = (float)Mth.atan2((double)dy, (double)Math.sqrt(dx * dx + dz * dz)) - 1.5707964f;
        this.setSpriteFromAge(sprite);
    }

    public SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.OPAQUE;
    }

    public ParticleRenderType getGroup() {
        return SteamJetParticleRenderer.SHEET;
    }

    public void extract(QuadParticleRenderState submittable, Camera camera, float tickProgress) {
        Vec3 vec3 = camera.position();
        float f = (float)(this.x - vec3.x);
        float f1 = (float)(this.y - vec3.y);
        float f2 = (float)(this.z - vec3.z);
        float f3 = Mth.lerp((float)tickProgress, (float)this.oRoll, (float)this.roll);
        float f7 = this.getU0();
        float f8 = this.getU1();
        float f5 = this.getV0();
        float f6 = this.getV1();
        float f4 = this.getQuadSize(tickProgress);
        SingleQuadParticle.Layer renderType = this.getLayer();
        int color = ARGB.colorFromFloat((float)this.alpha, (float)this.rCol, (float)this.gCol, (float)this.bCol);
        int brightness = this.getLightColor(tickProgress);
        for (int i = 0; i < 4; ++i) {
            Quaternionf rotation = Axis.YP.rotation(this.yaw);
            rotation.mul((Quaternionfc)Axis.XP.rotation(this.pitch));
            rotation.mul((Quaternionfc)Axis.YP.rotation(f3 + 1.5707964f * (float)i + this.roll));
            submittable.add(renderType, f, f1, f2, rotation.x, rotation.y, rotation.z, rotation.w, f4, f7, f8, f5, f6, color, brightness);
        }
    }

    public int getLightColor(float partialTick) {
        BlockPos blockpos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        return this.level.isLoaded(blockpos) ? LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)blockpos) : 0;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet animatedSprite) {
            this.spriteSet = animatedSprite;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            return new SteamJetParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, random);
        }
    }
}

