/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.particle;

import com.zurrtum.create.client.infrastructure.particle.CustomRotationParticle;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import org.joml.Quaternionf;

public class WiFiParticle
extends CustomRotationParticle {
    private final boolean downward;

    public WiFiParticle(SimpleParticleType type, SpriteSet spriteSet, ClientLevel worldIn, double x, double y, double z, double vx, double vy, double vz, RandomSource random) {
        super(worldIn, x, y + (double)(vy < 0.0 ? -1 : 1), z, spriteSet, 0.0f);
        this.quadSize = 0.5f;
        this.setSize(this.quadSize, this.quadSize);
        this.loopLength = 16;
        this.lifetime = 16;
        this.setSpriteFromAge(spriteSet);
        this.stoppedByCollision = true;
        this.downward = vy < 0.0;
    }

    public void tick() {
        this.setSpriteFromAge(this.sprites);
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
    }

    @Override
    public Quaternionf getCustomRotation(Camera camera, float partialTicks) {
        Quaternionf rotation = camera.rotation();
        Quaternionf quaternionf = new Quaternionf(0.0f, rotation.y, 0.0f, rotation.w);
        if (this.downward) {
            quaternionf.rotateZ((float)Math.PI);
        }
        return quaternionf;
    }
}

