/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.mixin;

import com.zurrtum.create.client.content.equipment.armor.CardboardRenderState;
import com.zurrtum.create.client.foundation.render.SkyhookRenderState;
import java.util.UUID;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={AvatarRenderState.class})
public class AvatarRenderStateMixin
implements CardboardRenderState,
SkyhookRenderState {
    @Unique
    private boolean flying;
    @Unique
    private boolean skip;
    @Unique
    private boolean onGround;
    @Unique
    private float lastYaw;
    @Unique
    private float yaw;
    @Unique
    private double lastX;
    @Unique
    private double lastY;
    @Unique
    private double lastZ;
    @Unique
    private Vec3 pos;
    @Unique
    private float tickProgress;
    @Unique
    private UUID uuid;
    @Unique
    private ItemStack mainStack;

    @Override
    public void create$setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public UUID create$getUuid() {
        return this.uuid;
    }

    @Override
    public void create$setMainStack(ItemStack stack) {
        this.mainStack = stack;
    }

    @Override
    public ItemStack create$getMainStack() {
        return this.mainStack;
    }

    @Override
    public <T extends Avatar> void create$update(T player, float tickProgress) {
        if (player instanceof AbstractClientPlayer) {
            AbstractClientPlayer clientPlayer = (AbstractClientPlayer)player;
            if (clientPlayer.getAbilities().flying) {
                this.flying = true;
                return;
            }
        }
        this.flying = false;
        Minecraft mc = Minecraft.getInstance();
        if (player == mc.player && mc.options.getCameraType() == CameraType.FIRST_PERSON) {
            this.skip = true;
            return;
        }
        this.skip = false;
        this.onGround = player.onGround();
        this.lastYaw = player.yRotO;
        this.yaw = player.getYRot();
        this.lastX = player.xo;
        this.lastY = player.yo;
        this.lastZ = player.zo;
        this.pos = player.position();
        this.tickProgress = tickProgress;
    }

    @Override
    public boolean create$isFlying() {
        return this.flying;
    }

    @Override
    public boolean create$isSkip() {
        return this.skip;
    }

    @Override
    public boolean create$isOnGround() {
        return this.onGround;
    }

    @Override
    public double create$getMovement() {
        return this.pos.subtract(this.lastX, this.lastY, this.lastZ).length();
    }

    @Override
    public float create$getInterpolatedYaw() {
        return Mth.lerp((float)this.tickProgress, (float)this.lastYaw, (float)this.yaw);
    }
}

