/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Transformation;
import com.zurrtum.create.client.model.NamedBlockRenderLayer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.context.ContextKey;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.util.context.ContextMap;
import org.jetbrains.annotations.Nullable;

public final class NeoForgeModelProperties {
    public static final ContextKey<Transformation> TRANSFORM = ContextKey.vanilla((String)"transform");
    public static final ContextKey<RenderType> RENDER_TYPE = ContextKey.vanilla((String)"render_type");
    public static final ContextKey<Map<String, Boolean>> PART_VISIBILITY = ContextKey.vanilla((String)"part_visibility");
    public static final ContextKeySet EMPTY_TYPE = new ContextKeySet.Builder().build();
    public static final ContextKeySet TYPE = new ContextKeySet.Builder().optional(TRANSFORM).optional(RENDER_TYPE).optional(PART_VISIBILITY).build();

    private NeoForgeModelProperties() {
    }

    @Nullable
    public static Transformation deserializeRootTransform(JsonObject jsonObject, JsonDeserializationContext context) {
        if (jsonObject.has("transform")) {
            JsonElement transform = jsonObject.get("transform");
            return (Transformation)context.deserialize(transform, Transformation.class);
        }
        return null;
    }

    @Nullable
    public static ChunkSectionLayer deserializeRenderType(JsonObject jsonObject) {
        if (jsonObject.has("render_type")) {
            return NamedBlockRenderLayer.get(GsonHelper.getAsString((JsonObject)jsonObject, (String)"render_type"));
        }
        return null;
    }

    public static Map<String, Boolean> deserializePartVisibility(JsonObject jsonObject) {
        HashMap<String, Boolean> partVisibility = new HashMap<String, Boolean>();
        if (jsonObject.has("visibility")) {
            JsonObject visibility = GsonHelper.getAsJsonObject((JsonObject)jsonObject, (String)"visibility");
            for (Map.Entry part : visibility.entrySet()) {
                partVisibility.put((String)part.getKey(), ((JsonElement)part.getValue()).getAsBoolean());
            }
        }
        return Map.copyOf(partVisibility);
    }

    public static void fillRootTransformProperty(ContextMap.Builder propertiesBuilder, @Nullable Transformation rootTransform) {
        if (rootTransform != null) {
            propertiesBuilder.withParameter(TRANSFORM, (Object)rootTransform);
        }
    }

    public static void fillPartVisibilityProperty(ContextMap.Builder propertiesBuilder, Map<String, Boolean> partVisibility) {
        if (!partVisibility.isEmpty()) {
            Map<String, Boolean> visibility = (Map<String, Boolean>)propertiesBuilder.getOptionalParameter(PART_VISIBILITY);
            if (visibility != null) {
                visibility = new HashMap<String, Boolean>(visibility);
                visibility.putAll(partVisibility);
            } else {
                visibility = partVisibility;
            }
            visibility = Map.copyOf(visibility);
            propertiesBuilder.withParameter(PART_VISIBILITY, visibility);
        }
    }
}

