/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.model.obj;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.mojang.math.Transformation;
import com.zurrtum.create.client.model.ExtendedUnbakedGeometry;
import com.zurrtum.create.client.model.NeoForgeModelProperties;
import com.zurrtum.create.client.model.StandardModelParameters;
import com.zurrtum.create.client.model.obj.ObjLoader;
import com.zurrtum.create.client.model.obj.ObjMaterialLibrary;
import com.zurrtum.create.client.model.obj.ObjTokenizer;
import com.zurrtum.create.client.model.obj.QuadBakingVertexConsumer;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import joptsimple.internal.Strings;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.phys.Vec2;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class ObjGeometry
implements ExtendedUnbakedGeometry {
    private static final Vector4f COLOR_WHITE = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private static final Vec2[] DEFAULT_COORDS = new Vec2[]{new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(1.0f, 1.0f), new Vec2(1.0f, 0.0f)};
    private final Multimap<String, ModelGroup> parts = MultimapBuilder.linkedHashKeys().arrayListValues().build();
    private final List<Vector3f> positions = Lists.newArrayList();
    private final List<Vec2> texCoords = Lists.newArrayList();
    private final List<Vector3f> normals = Lists.newArrayList();
    private final List<Vector4f> colors = Lists.newArrayList();
    public final boolean automaticCulling;
    public final boolean shadeQuads;
    public final boolean flipV;
    public final boolean emissiveAmbient;
    @Nullable
    public final String mtlOverride;
    public final StandardModelParameters parameters;
    public final Identifier modelLocation;

    private ObjGeometry(Settings settings) {
        this.modelLocation = settings.modelLocation();
        this.automaticCulling = settings.automaticCulling();
        this.shadeQuads = settings.shadeQuads();
        this.flipV = settings.flipV();
        this.emissiveAmbient = settings.emissiveAmbient();
        this.mtlOverride = settings.mtlOverride();
        this.parameters = settings.parameters();
    }

    public static ObjGeometry parse(ObjTokenizer tokenizer, Settings settings) throws IOException {
        String[] line;
        Identifier modelLocation = settings.modelLocation();
        String materialLibraryOverrideLocation = settings.mtlOverride();
        ObjGeometry model = new ObjGeometry(settings);
        String modelDomain = modelLocation.getNamespace();
        String modelPath = modelLocation.getPath();
        int lastSlash = modelPath.lastIndexOf(47);
        modelPath = lastSlash >= 0 ? modelPath.substring(0, lastSlash + 1) : "";
        ObjMaterialLibrary mtllib = ObjMaterialLibrary.EMPTY;
        ObjMaterialLibrary.Material currentMat = null;
        String currentSmoothingGroup = null;
        ModelObject currentGroup = null;
        ModelObject currentObject = null;
        ModelMesh currentMesh = null;
        boolean objAboveGroup = false;
        if (materialLibraryOverrideLocation != null) {
            String lib = materialLibraryOverrideLocation;
            mtllib = lib.contains(":") ? ObjLoader.INSTANCE.loadMaterialLibrary(Identifier.parse((String)lib)) : ObjLoader.INSTANCE.loadMaterialLibrary(Identifier.fromNamespaceAndPath((String)modelDomain, (String)(modelPath + lib)));
        }
        while ((line = tokenizer.readAndSplitLine(true)) != null) {
            switch (line[0]) {
                case "mtllib": {
                    if (materialLibraryOverrideLocation != null) break;
                    String lib = line[1];
                    if (lib.contains(":")) {
                        mtllib = ObjLoader.INSTANCE.loadMaterialLibrary(Identifier.parse((String)lib));
                        break;
                    }
                    mtllib = ObjLoader.INSTANCE.loadMaterialLibrary(Identifier.fromNamespaceAndPath((String)modelDomain, (String)(modelPath + lib)));
                    break;
                }
                case "usemtl": {
                    String mat = Strings.join((String[])Arrays.copyOfRange(line, 1, line.length), (String)" ");
                    ObjMaterialLibrary.Material newMat = mtllib.getMaterial(mat);
                    if (Objects.equals(newMat, currentMat)) break;
                    currentMat = newMat;
                    if (currentMesh != null && currentMesh.mat == null && currentMesh.faces.size() == 0) {
                        currentMesh.mat = currentMat;
                        break;
                    }
                    currentMesh = null;
                    break;
                }
                case "v": {
                    model.positions.add(ObjGeometry.parseVector4To3(line));
                    break;
                }
                case "vt": {
                    model.texCoords.add(ObjGeometry.parseVector2(line));
                    break;
                }
                case "vn": {
                    model.normals.add(ObjGeometry.parseVector3(line));
                    break;
                }
                case "vc": {
                    model.colors.add(ObjGeometry.parseVector4(line));
                    break;
                }
                case "f": {
                    if (currentMesh == null) {
                        ObjGeometry objGeometry = model;
                        Objects.requireNonNull(objGeometry);
                        currentMesh = objGeometry.new ModelMesh(currentMat, currentSmoothingGroup);
                        if (currentObject != null) {
                            currentObject.meshes.add(currentMesh);
                        } else {
                            if (currentGroup == null) {
                                ObjGeometry objGeometry2 = model;
                                Objects.requireNonNull(objGeometry2);
                                currentGroup = new ModelGroup(objGeometry2, "");
                                model.parts.put((Object)"", (Object)currentGroup);
                            }
                            ((ModelGroup)currentGroup).meshes.add(currentMesh);
                        }
                    }
                    int[][] vertices = new int[line.length - 1][];
                    for (int i = 0; i < vertices.length; ++i) {
                        String vertexData = line[i + 1];
                        String[] vertexParts = vertexData.split("/");
                        int[] vertex = Arrays.stream(vertexParts).mapToInt(num -> Strings.isNullOrEmpty((String)num) ? 0 : Integer.parseInt(num)).toArray();
                        vertex[0] = vertex[0] < 0 ? model.positions.size() + vertex[0] : vertex[0] - 1;
                        if (vertex.length > 1) {
                            vertex[1] = vertex[1] < 0 ? model.texCoords.size() + vertex[1] : vertex[1] - 1;
                            if (vertex.length > 2) {
                                vertex[2] = vertex[2] < 0 ? model.normals.size() + vertex[2] : vertex[2] - 1;
                                if (vertex.length > 3) {
                                    vertex[3] = vertex[3] < 0 ? model.colors.size() + vertex[3] : vertex[3] - 1;
                                }
                            }
                        }
                        vertices[i] = vertex;
                    }
                    currentMesh.faces.add(vertices);
                    break;
                }
                case "s": {
                    String smoothingGroup;
                    String string = smoothingGroup = "off".equals(line[1]) ? null : line[1];
                    if (Objects.equals(currentSmoothingGroup, smoothingGroup)) break;
                    currentSmoothingGroup = smoothingGroup;
                    if (currentMesh != null && currentMesh.smoothingGroup == null && currentMesh.faces.size() == 0) {
                        currentMesh.smoothingGroup = currentSmoothingGroup;
                        break;
                    }
                    currentMesh = null;
                    break;
                }
                case "g": {
                    String name = line[1];
                    if (objAboveGroup) {
                        ObjGeometry objGeometry = model;
                        Objects.requireNonNull(objGeometry);
                        currentObject = new ModelObject(objGeometry, currentGroup.name() + "/" + name);
                        ((ModelGroup)currentGroup).parts.put((Object)name, (Object)currentObject);
                    } else {
                        ObjGeometry objGeometry = model;
                        Objects.requireNonNull(objGeometry);
                        currentGroup = new ModelGroup(objGeometry, name);
                        model.parts.put((Object)name, (Object)currentGroup);
                        currentObject = null;
                    }
                    currentMesh = null;
                    break;
                }
                case "o": {
                    String name = line[1];
                    if (objAboveGroup || currentGroup == null) {
                        objAboveGroup = true;
                        ObjGeometry objGeometry = model;
                        Objects.requireNonNull(objGeometry);
                        currentGroup = new ModelGroup(objGeometry, name);
                        model.parts.put((Object)name, (Object)currentGroup);
                        currentObject = null;
                    } else {
                        ObjGeometry objGeometry = model;
                        Objects.requireNonNull(objGeometry);
                        currentObject = new ModelObject(objGeometry, currentGroup.name() + "/" + name);
                        ((ModelGroup)currentGroup).parts.put((Object)name, (Object)currentObject);
                    }
                    currentMesh = null;
                    break;
                }
            }
        }
        return model;
    }

    private static Vector3f parseVector4To3(String[] line) {
        Vector4f vec4 = ObjGeometry.parseVector4(line);
        return new Vector3f(vec4.x() / vec4.w(), vec4.y() / vec4.w(), vec4.z() / vec4.w());
    }

    private static Vec2 parseVector2(String[] line) {
        return switch (line.length) {
            case 1 -> new Vec2(0.0f, 0.0f);
            case 2 -> new Vec2(Float.parseFloat(line[1]), 0.0f);
            default -> new Vec2(Float.parseFloat(line[1]), Float.parseFloat(line[2]));
        };
    }

    private static Vector3f parseVector3(String[] line) {
        return switch (line.length) {
            case 1 -> new Vector3f();
            case 2 -> new Vector3f(Float.parseFloat(line[1]), 0.0f, 0.0f);
            case 3 -> new Vector3f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), 0.0f);
            default -> new Vector3f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]));
        };
    }

    static Vector4f parseVector4(String[] line) {
        return switch (line.length) {
            case 1 -> new Vector4f();
            case 2 -> new Vector4f(Float.parseFloat(line[1]), 0.0f, 0.0f, 1.0f);
            case 3 -> new Vector4f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), 0.0f, 1.0f);
            case 4 -> new Vector4f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]), 1.0f);
            default -> new Vector4f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]), Float.parseFloat(line[4]));
        };
    }

    @Override
    public QuadCollection bake(TextureSlots textureSlots, ModelBaker baker, ModelState state, ModelDebugName debugName) {
        ContextMap.Builder propertiesBuilder = new ContextMap.Builder();
        NeoForgeModelProperties.fillRootTransformProperty(propertiesBuilder, this.parameters.rootTransform());
        NeoForgeModelProperties.fillPartVisibilityProperty(propertiesBuilder, this.parameters.partVisibility());
        return this.bake(textureSlots, baker, state, debugName, propertiesBuilder.create(NeoForgeModelProperties.TYPE));
    }

    @Override
    public QuadCollection bake(TextureSlots textureSlots, ModelBaker baker, ModelState state, ModelDebugName debugName, ContextMap additionalProperties) {
        Map partVisibility = (Map)additionalProperties.getOrDefault(NeoForgeModelProperties.PART_VISIBILITY, Map.of());
        QuadCollection.Builder builder = new QuadCollection.Builder();
        this.parts.values().stream().filter(part -> partVisibility.getOrDefault(part.name(), true)).forEach(part -> part.addQuads(builder, textureSlots, baker, state, debugName, additionalProperties));
        return builder.build();
    }

    private Transformation blockCenterToCorner(Transformation transform) {
        if (transform.equals((Object)Transformation.identity())) {
            return Transformation.identity();
        }
        Matrix4f ret = transform.getMatrixCopy();
        Vector3f origin = new Vector3f(0.5f, 0.5f, 0.5f);
        Matrix4f tmp = new Matrix4f().translation(origin.x(), origin.y(), origin.z());
        tmp.mul((Matrix4fc)ret, ret);
        tmp.translation(-origin.x(), -origin.y(), -origin.z());
        ret.mul((Matrix4fc)tmp);
        return new Transformation((Matrix4fc)ret);
    }

    private Pair<BakedQuad, Direction> makeQuad(int[][] indices, int tintIndex, Vector4f colorTint, Vector4f ambientColor, TextureAtlasSprite texture, Transformation transform) {
        boolean needsNormalRecalculation = false;
        for (int[] ints : indices) {
            needsNormalRecalculation |= ints.length < 3;
        }
        Vector3f faceNormal = new Vector3f();
        if (needsNormalRecalculation) {
            Vector3f a = this.positions.get(indices[0][0]);
            Vector3f ab = this.positions.get(indices[1][0]);
            Vector3f ac = this.positions.get(indices[2][0]);
            Vector3f abs = new Vector3f((Vector3fc)ab);
            abs.sub((Vector3fc)a);
            Vector3f acs = new Vector3f((Vector3fc)ac);
            acs.sub((Vector3fc)a);
            abs.cross((Vector3fc)acs);
            abs.normalize();
            faceNormal = abs;
        }
        QuadBakingVertexConsumer quadBaker = new QuadBakingVertexConsumer();
        quadBaker.setSprite(texture);
        quadBaker.setTintIndex(tintIndex);
        int uv2 = 0;
        if (this.emissiveAmbient) {
            int fakeLight = (int)((ambientColor.x() + ambientColor.y() + ambientColor.z()) * 15.0f / 3.0f);
            uv2 = LightTexture.pack((int)fakeLight, (int)fakeLight);
            quadBaker.setShade(fakeLight == 0 && this.shadeQuads);
        } else {
            quadBaker.setShade(this.shadeQuads);
        }
        boolean hasTransform = !transform.equals((Object)Transformation.identity());
        Transformation transformation = hasTransform ? this.blockCenterToCorner(transform) : transform;
        Vector4f[] pos = new Vector4f[4];
        Vector3f[] norm = new Vector3f[4];
        for (int i = 0; i < 4; ++i) {
            Vector4f color;
            Vector3f norm0;
            int[] index = indices[Math.min(i, indices.length - 1)];
            Vector4f position = new Vector4f((Vector3fc)this.positions.get(index[0]), 1.0f);
            Vec2 texCoord = index.length >= 2 && this.texCoords.size() > 0 ? this.texCoords.get(index[1]) : DEFAULT_COORDS[i];
            Vector3f normal = norm0 = !needsNormalRecalculation && index.length >= 3 && this.normals.size() > 0 ? this.normals.get(index[2]) : faceNormal;
            Vector4f vector4f = color = index.length >= 4 && this.colors.size() > 0 ? this.colors.get(index[3]) : COLOR_WHITE;
            if (hasTransform) {
                normal = new Vector3f((Vector3fc)norm0);
                position.mul(transformation.getMatrix());
                Matrix3f normalTransform = new Matrix3f(transformation.getMatrix());
                normalTransform.invert();
                normalTransform.transpose();
                normal.mul((Matrix3fc)normalTransform);
                normal.normalize();
            }
            Vector4f tintedColor = new Vector4f(color.x() * colorTint.x(), color.y() * colorTint.y(), color.z() * colorTint.z(), color.w() * colorTint.w());
            quadBaker.addVertex(position.x(), position.y(), position.z());
            quadBaker.setColor(tintedColor.x(), tintedColor.y(), tintedColor.z(), tintedColor.w());
            quadBaker.setUv(texture.getU(texCoord.x), texture.getV(this.flipV ? 1.0f - texCoord.y : texCoord.y));
            quadBaker.setLight(uv2);
            quadBaker.setNormal(normal.x(), normal.y(), normal.z());
            if (i == 0) {
                quadBaker.setDirection(Direction.getApproximateNearest((float)normal.x(), (float)normal.y(), (float)normal.z()));
            }
            pos[i] = position;
            norm[i] = normal;
        }
        Direction cull = null;
        if (this.automaticCulling) {
            if (Mth.equal((float)pos[0].x(), (float)0.0f) && Mth.equal((float)pos[1].x(), (float)0.0f) && Mth.equal((float)pos[2].x(), (float)0.0f) && Mth.equal((float)pos[3].x(), (float)0.0f) && norm[0].x() < 0.0f) {
                cull = Direction.WEST;
            } else if (Mth.equal((float)pos[0].x(), (float)1.0f) && Mth.equal((float)pos[1].x(), (float)1.0f) && Mth.equal((float)pos[2].x(), (float)1.0f) && Mth.equal((float)pos[3].x(), (float)1.0f) && norm[0].x() > 0.0f) {
                cull = Direction.EAST;
            } else if (Mth.equal((float)pos[0].z(), (float)0.0f) && Mth.equal((float)pos[1].z(), (float)0.0f) && Mth.equal((float)pos[2].z(), (float)0.0f) && Mth.equal((float)pos[3].z(), (float)0.0f) && norm[0].z() < 0.0f) {
                cull = Direction.NORTH;
            } else if (Mth.equal((float)pos[0].z(), (float)1.0f) && Mth.equal((float)pos[1].z(), (float)1.0f) && Mth.equal((float)pos[2].z(), (float)1.0f) && Mth.equal((float)pos[3].z(), (float)1.0f) && norm[0].z() > 0.0f) {
                cull = Direction.SOUTH;
            } else if (Mth.equal((float)pos[0].y(), (float)0.0f) && Mth.equal((float)pos[1].y(), (float)0.0f) && Mth.equal((float)pos[2].y(), (float)0.0f) && Mth.equal((float)pos[3].y(), (float)0.0f) && norm[0].y() < 0.0f) {
                cull = Direction.DOWN;
            } else if (Mth.equal((float)pos[0].y(), (float)1.0f) && Mth.equal((float)pos[1].y(), (float)1.0f) && Mth.equal((float)pos[2].y(), (float)1.0f) && Mth.equal((float)pos[3].y(), (float)1.0f) && norm[0].y() > 0.0f) {
                cull = Direction.UP;
            }
        }
        return Pair.of((Object)quadBaker.bakeQuad(), cull);
    }

    public record Settings(Identifier modelLocation, boolean automaticCulling, boolean shadeQuads, boolean flipV, boolean emissiveAmbient, @Nullable String mtlOverride, StandardModelParameters parameters) {
    }

    private class ModelMesh {
        @Nullable
        public ObjMaterialLibrary.Material mat;
        @Nullable
        public String smoothingGroup;
        public final List<int[][]> faces = Lists.newArrayList();

        public ModelMesh(@Nullable ObjMaterialLibrary.Material currentMat, String currentSmoothingGroup) {
            this.mat = currentMat;
            this.smoothingGroup = currentSmoothingGroup;
        }

        public void addQuads(QuadCollection.Builder builder, TextureSlots slots, ModelBaker baker, ModelState state, ModelDebugName debugName, ContextMap additionalProperties) {
            if (this.mat == null) {
                return;
            }
            TextureAtlasSprite texture = baker.sprites().resolveSlot(slots, this.mat.diffuseColorMap, debugName);
            int tintIndex = this.mat.diffuseTintIndex;
            Vector4f colorTint = this.mat.diffuseColor;
            Transformation rootTransform = (Transformation)additionalProperties.getOrDefault(NeoForgeModelProperties.TRANSFORM, (Object)Transformation.identity());
            Transformation transform = rootTransform.equals((Object)Transformation.identity()) ? state.transformation() : state.transformation().compose(rootTransform);
            for (int[][] face : this.faces) {
                Pair<BakedQuad, Direction> quad = ObjGeometry.this.makeQuad(face, tintIndex, colorTint, this.mat.ambientColor, texture, transform);
                if (quad.getRight() == null) {
                    builder.addUnculledFace((BakedQuad)quad.getLeft());
                    continue;
                }
                builder.addCulledFace((Direction)quad.getRight(), (BakedQuad)quad.getLeft());
            }
        }
    }

    public class ModelObject {
        public final String name;
        List<ModelMesh> meshes = Lists.newArrayList();

        ModelObject(ObjGeometry this$0, String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public void addQuads(QuadCollection.Builder builder, TextureSlots slots, ModelBaker baker, ModelState state, ModelDebugName debugName, ContextMap additionalProperties) {
            for (ModelMesh mesh : this.meshes) {
                mesh.addQuads(builder, slots, baker, state, debugName, additionalProperties);
            }
        }

        protected void addNamesRecursively(Set<String> names) {
            names.add(this.name());
        }
    }

    public class ModelGroup
    extends ModelObject {
        final Multimap<String, ModelObject> parts = MultimapBuilder.linkedHashKeys().arrayListValues().build();

        ModelGroup(ObjGeometry this$0, String name) {
            super(this$0, name);
        }

        @Override
        public void addQuads(QuadCollection.Builder builder, TextureSlots slots, ModelBaker baker, ModelState state, ModelDebugName debugName, ContextMap additionalProperties) {
            super.addQuads(builder, slots, baker, state, debugName, additionalProperties);
            Map partVisibility = (Map)additionalProperties.getOrDefault(NeoForgeModelProperties.PART_VISIBILITY, Map.of());
            this.parts.values().stream().filter(part -> partVisibility.getOrDefault("%s.%s".formatted(this.name(), part.name()), true)).forEach(part -> part.addQuads(builder, slots, baker, state, debugName, additionalProperties));
        }

        @Override
        protected void addNamesRecursively(Set<String> names) {
            super.addNamesRecursively(names);
            for (ModelObject object : this.parts.values()) {
                object.addNamesRecursively(names);
            }
        }
    }
}

