/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.model.obj;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.zurrtum.create.client.model.StandardModelParameters;
import com.zurrtum.create.client.model.UnbakedModelLoader;
import com.zurrtum.create.client.model.obj.ObjGeometry;
import com.zurrtum.create.client.model.obj.ObjMaterialLibrary;
import com.zurrtum.create.client.model.obj.ObjModel;
import com.zurrtum.create.client.model.obj.ObjTokenizer;
import java.io.FileNotFoundException;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;

public class ObjLoader
implements UnbakedModelLoader<ObjModel>,
ResourceManagerReloadListener {
    public static ObjLoader INSTANCE = new ObjLoader();
    private final Map<ObjGeometry.Settings, ObjGeometry> geometryCache = Maps.newConcurrentMap();
    private final Map<Identifier, ObjMaterialLibrary> materialCache = Maps.newConcurrentMap();
    private final ResourceManager manager = Minecraft.getInstance().getResourceManager();

    public void onResourceManagerReload(ResourceManager resourceManager) {
        this.geometryCache.clear();
        this.materialCache.clear();
    }

    @Override
    public ObjModel read(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (!jsonObject.has("model")) {
            throw new JsonParseException("OBJ Loader requires a 'model' key that points to a valid .OBJ model.");
        }
        String modelLocation = jsonObject.get("model").getAsString();
        boolean automaticCulling = GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"automatic_culling", (boolean)true);
        boolean shadeQuads = GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"shade_quads", (boolean)true);
        boolean flipV = GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"flip_v", (boolean)false);
        boolean emissiveAmbient = GsonHelper.getAsBoolean((JsonObject)jsonObject, (String)"emissive_ambient", (boolean)true);
        String mtlOverride = GsonHelper.getAsString((JsonObject)jsonObject, (String)"mtl_override", null);
        StandardModelParameters parameters = StandardModelParameters.parse(jsonObject, jsonDeserializationContext);
        ObjGeometry geometry = this.loadGeometry(new ObjGeometry.Settings(Identifier.parse((String)modelLocation), automaticCulling, shadeQuads, flipV, emissiveAmbient, mtlOverride, parameters));
        return new ObjModel(parameters, geometry);
    }

    public ObjGeometry loadGeometry(ObjGeometry.Settings settings) {
        return this.geometryCache.computeIfAbsent(settings, data -> {
            ObjGeometry objGeometry;
            Resource resource = (Resource)this.manager.getResource(settings.modelLocation()).orElseThrow();
            ObjTokenizer tokenizer = new ObjTokenizer(resource.open());
            try {
                objGeometry = ObjGeometry.parse(tokenizer, data);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        tokenizer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Could not find OBJ model", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read OBJ model", e);
                }
            }
            tokenizer.close();
            return objGeometry;
        });
    }

    public ObjMaterialLibrary loadMaterialLibrary(Identifier materialLocation) {
        return this.materialCache.computeIfAbsent(materialLocation, location -> {
            ObjMaterialLibrary objMaterialLibrary;
            Resource resource = (Resource)this.manager.getResource(location).orElseThrow();
            ObjTokenizer rdr = new ObjTokenizer(resource.open());
            try {
                objMaterialLibrary = new ObjMaterialLibrary(rdr);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        rdr.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Could not find OBJ material library", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not read OBJ material library", e);
                }
            }
            rdr.close();
            return objMaterialLibrary;
        });
    }
}

