/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.model.obj;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.zurrtum.create.client.model.NormalsBakedQuad;
import com.zurrtum.create.client.model.obj.UnitTextureAtlasSprite;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.ARGB;
import net.minecraft.util.Util;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class QuadBakingVertexConsumer
implements VertexConsumer {
    public static final int STRIDE = DefaultVertexFormat.BLOCK.getVertexSize() / 4;
    public static final int POSITION = QuadBakingVertexConsumer.findOffset(VertexFormatElement.POSITION);
    public static final int COLOR = QuadBakingVertexConsumer.findOffset(VertexFormatElement.COLOR);
    public static final int UV0 = QuadBakingVertexConsumer.findOffset(VertexFormatElement.UV0);
    public static final int UV1 = QuadBakingVertexConsumer.findOffset(VertexFormatElement.UV1);
    public static final int UV2 = QuadBakingVertexConsumer.findOffset(VertexFormatElement.UV2);
    public static final int NORMAL = QuadBakingVertexConsumer.findOffset(VertexFormatElement.NORMAL);
    private final Map<VertexFormatElement, Integer> ELEMENT_OFFSETS = (Map)Util.make(new IdentityHashMap(), map -> {
        for (VertexFormatElement element : DefaultVertexFormat.BLOCK.getElements()) {
            map.put(element, DefaultVertexFormat.BLOCK.getOffset(element) / 4);
        }
    });
    private static final int QUAD_DATA_SIZE = STRIDE * 4;
    private final int[] quadData = new int[QUAD_DATA_SIZE];
    private int vertexIndex = 0;
    private boolean building = false;
    private int tintIndex = -1;
    private Direction direction = Direction.DOWN;
    private TextureAtlasSprite sprite = UnitTextureAtlasSprite.INSTANCE;
    private boolean shade;
    private int lightEmission;
    private boolean hasAmbientOcclusion;

    private static int findOffset(VertexFormatElement element) {
        if (DefaultVertexFormat.BLOCK.contains(element)) {
            return DefaultVertexFormat.BLOCK.getOffset(element) / 4;
        }
        return -1;
    }

    public VertexConsumer addVertex(float x, float y, float z) {
        if (this.building && ++this.vertexIndex > 4) {
            throw new IllegalStateException("Expected quad export after fourth vertex");
        }
        this.building = true;
        int offset = this.vertexIndex * STRIDE + POSITION;
        this.quadData[offset] = Float.floatToRawIntBits(x);
        this.quadData[offset + 1] = Float.floatToRawIntBits(y);
        this.quadData[offset + 2] = Float.floatToRawIntBits(z);
        return this;
    }

    public VertexConsumer setNormal(float x, float y, float z) {
        int offset = this.vertexIndex * STRIDE + NORMAL;
        this.quadData[offset] = (int)(x * 127.0f) & 0xFF | ((int)(y * 127.0f) & 0xFF) << 8 | ((int)(z * 127.0f) & 0xFF) << 16;
        return this;
    }

    public VertexConsumer setLineWidth(float width) {
        return this;
    }

    public VertexConsumer setColor(int color) {
        int offset = this.vertexIndex * STRIDE + COLOR;
        this.quadData[offset] = ARGB.toABGR((int)color);
        return this;
    }

    public VertexConsumer setColor(int r, int g, int b, int a) {
        int offset = this.vertexIndex * STRIDE + COLOR;
        this.quadData[offset] = (a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF;
        return this;
    }

    public VertexConsumer setUv(float u, float v) {
        int offset = this.vertexIndex * STRIDE + UV0;
        this.quadData[offset] = Float.floatToRawIntBits(u);
        this.quadData[offset + 1] = Float.floatToRawIntBits(v);
        return this;
    }

    public VertexConsumer setUv1(int u, int v) {
        if (UV1 >= 0) {
            int offset = this.vertexIndex * STRIDE + UV1;
            this.quadData[offset] = u & 0xFFFF | (v & 0xFFFF) << 16;
        }
        return this;
    }

    public VertexConsumer setUv2(int u, int v) {
        int offset = this.vertexIndex * STRIDE + UV2;
        this.quadData[offset] = u & 0xFFFF | (v & 0xFFFF) << 16;
        return this;
    }

    public VertexConsumer misc(VertexFormatElement element, int ... rawData) {
        Integer baseOffset = this.ELEMENT_OFFSETS.get(element);
        if (baseOffset != null) {
            int offset = this.vertexIndex * STRIDE + baseOffset;
            System.arraycopy(rawData, 0, this.quadData, offset, rawData.length);
        }
        return this;
    }

    public void setTintIndex(int tintIndex) {
        this.tintIndex = tintIndex;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void setSprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
    }

    public void setShade(boolean shade) {
        this.shade = shade;
    }

    private Vector3f getVertex(int vertexIndex) {
        int offset = vertexIndex * STRIDE + POSITION;
        return new Vector3f(Float.intBitsToFloat(this.quadData[offset]), Float.intBitsToFloat(this.quadData[offset + 1]), Float.intBitsToFloat(this.quadData[offset + 2]));
    }

    private long getUv(int vertexIndex) {
        int offset = vertexIndex * STRIDE + UV0;
        long high = (long)this.quadData[offset] & 0xFFFFFFFFL;
        long low = (long)this.quadData[offset + 1] & 0xFFFFFFFFL;
        return high << 32 | low;
    }

    private int getNormal(int vertexIndex) {
        return this.quadData[vertexIndex * STRIDE + NORMAL];
    }

    public BakedQuad bakeQuad() {
        if (!this.building || ++this.vertexIndex != 4) {
            throw new IllegalStateException("Not enough vertices available. Vertices in buffer: " + this.vertexIndex);
        }
        BakedQuad quad = new BakedQuad((Vector3fc)this.getVertex(0), (Vector3fc)this.getVertex(1), (Vector3fc)this.getVertex(2), (Vector3fc)this.getVertex(3), this.getUv(0), this.getUv(1), this.getUv(2), this.getUv(3), this.tintIndex, this.direction, this.sprite, this.shade, this.lightEmission);
        NormalsBakedQuad.setNormals(quad, new int[]{this.getNormal(0), this.getNormal(1), this.getNormal(2), this.getNormal(3)});
        this.vertexIndex = 0;
        this.building = false;
        Arrays.fill(this.quadData, 0);
        return quad;
    }
}

