/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.api.element;

import com.mojang.blaze3d.platform.Window;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.ui.PonderUI;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class ParrotPose {
    private static final Parrot.Variant[] VARIANTS = new Parrot.Variant[]{Parrot.Variant.RED_BLUE, Parrot.Variant.GREEN, Parrot.Variant.YELLOW_BLUE, Parrot.Variant.GRAY};

    public abstract void tick(PonderScene var1, Parrot var2, Vec3 var3);

    public Parrot create(PonderLevel world) {
        Parrot entity = new Parrot(EntityType.PARROT, (Level)world);
        int nextInt = world.random.nextInt(VARIANTS.length);
        entity.setVariant(VARIANTS[nextInt]);
        return entity;
    }

    public static class FaceCursorPose
    extends FaceVecPose {
        @Override
        protected Vec3 getFacedVec(PonderScene scene) {
            Minecraft minecraft = Minecraft.getInstance();
            Window w = minecraft.getWindow();
            double mouseX = minecraft.mouseHandler.xpos() * (double)w.getGuiScaledWidth() / (double)w.getScreenWidth();
            double mouseY = minecraft.mouseHandler.ypos() * (double)w.getGuiScaledHeight() / (double)w.getScreenHeight();
            return scene.getTransform().screenToScene(mouseX, mouseY, 300, 0.0f);
        }
    }

    public static class FacePointOfInterestPose
    extends FaceVecPose {
        @Override
        protected Vec3 getFacedVec(PonderScene scene) {
            return scene.getPointOfInterest();
        }
    }

    public static abstract class FaceVecPose
    extends ParrotPose {
        @Override
        public void tick(PonderScene scene, Parrot entity, Vec3 location) {
            Vec3 p_200602_2_ = this.getFacedVec(scene);
            Vec3 Vector3d2 = location.add(entity.getEyePosition(0.0f));
            double d0 = p_200602_2_.x - Vector3d2.x;
            double d1 = p_200602_2_.y - Vector3d2.y;
            double d2 = p_200602_2_.z - Vector3d2.z;
            double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
            float targetPitch = Mth.wrapDegrees((float)((float)(-(Mth.atan2((double)d1, (double)d3) * 57.2957763671875))));
            float targetYaw = Mth.wrapDegrees((float)((float)(-(Mth.atan2((double)d2, (double)d0) * 57.2957763671875)) + 90.0f));
            entity.setXRot(AngleHelper.angleLerp(0.4f, entity.getXRot(), targetPitch));
            entity.setYRot(AngleHelper.angleLerp(0.4f, entity.getYRot(), targetYaw));
        }

        protected abstract Vec3 getFacedVec(PonderScene var1);
    }

    public static class FlappyPose
    extends ParrotPose {
        @Override
        public void tick(PonderScene scene, Parrot entity, Vec3 location) {
            double length = entity.position().subtract(entity.xOld, entity.yOld, entity.zOld).length();
            entity.setOnGround(false);
            double phase = Math.min(length * 15.0, 8.0);
            float f = (float)((double)(PonderUI.ponderTicks % 100) * phase);
            entity.flapSpeed = Mth.sin((double)f) + 1.0f;
            if (length == 0.0) {
                entity.flapSpeed = 0.0f;
            }
        }
    }

    public static class DancePose
    extends ParrotPose {
        @Override
        public Parrot create(PonderLevel world) {
            Parrot entity = super.create(world);
            entity.setRecordPlayingNearby(BlockPos.ZERO, true);
            return entity;
        }

        @Override
        public void tick(PonderScene scene, Parrot entity, Vec3 location) {
            entity.yRotO = entity.getYRot();
            entity.setYRot(entity.yRotO - 2.0f);
        }
    }
}

