/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation;

import com.zurrtum.create.client.ponder.api.registration.StoryBoardEntry;
import com.zurrtum.create.client.ponder.api.scene.PonderStoryBoard;
import com.zurrtum.create.client.ponder.foundation.PonderTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.Identifier;

public class PonderStoryBoardEntry
implements StoryBoardEntry {
    private final PonderStoryBoard board;
    private final String namespace;
    private final Identifier schematicLocation;
    private final Identifier component;
    private final List<Identifier> tags;
    private final List<StoryBoardEntry.SceneOrderingEntry> orderingEntries;

    public PonderStoryBoardEntry(PonderStoryBoard board, String namespace, Identifier schematicLocation, Identifier component) {
        this.board = board;
        this.namespace = namespace;
        this.schematicLocation = schematicLocation;
        this.component = component;
        this.tags = new ArrayList<Identifier>();
        this.orderingEntries = new ArrayList<StoryBoardEntry.SceneOrderingEntry>();
    }

    public PonderStoryBoardEntry(PonderStoryBoard board, String namespace, String schematicPath, Identifier component) {
        this(board, namespace, Identifier.fromNamespaceAndPath((String)namespace, (String)schematicPath), component);
    }

    @Override
    public PonderStoryBoard getBoard() {
        return this.board;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Identifier getSchematicLocation() {
        return this.schematicLocation;
    }

    @Override
    public Identifier getComponent() {
        return this.component;
    }

    @Override
    public List<Identifier> getTags() {
        return this.tags;
    }

    @Override
    public List<StoryBoardEntry.SceneOrderingEntry> getOrderingEntries() {
        return this.orderingEntries;
    }

    @Override
    public StoryBoardEntry orderBefore(String namespace, String otherSceneId) {
        this.orderingEntries.add(StoryBoardEntry.SceneOrderingEntry.before(namespace, otherSceneId));
        return this;
    }

    @Override
    public StoryBoardEntry orderAfter(String namespace, String otherSceneId) {
        this.orderingEntries.add(StoryBoardEntry.SceneOrderingEntry.after(namespace, otherSceneId));
        return this;
    }

    @Override
    public StoryBoardEntry highlightTag(Identifier tag) {
        this.tags.add(tag);
        return this;
    }

    @Override
    public StoryBoardEntry highlightTags(Identifier ... tags) {
        Collections.addAll(this.tags, tags);
        return this;
    }

    @Override
    public StoryBoardEntry highlightAllTags() {
        this.tags.add(PonderTag.Highlight.ALL);
        return this;
    }
}

