/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.element;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.ponder.api.element.ParrotElement;
import com.zurrtum.create.client.ponder.api.element.ParrotPose;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.element.AnimatedSceneElementBase;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class ParrotElementImpl
extends AnimatedSceneElementBase
implements ParrotElement {
    protected Vec3 location;
    @Nullable
    protected Parrot entity;
    protected ParrotPose pose;
    protected Supplier<? extends ParrotPose> initialPose;

    public static ParrotElement create(Vec3 location, Supplier<? extends ParrotPose> pose) {
        return new ParrotElementImpl(location, pose);
    }

    protected ParrotElementImpl(Vec3 location, Supplier<? extends ParrotPose> pose) {
        this.location = location;
        this.initialPose = pose;
        this.pose = this.initialPose.get();
    }

    @Override
    public void reset(PonderScene scene) {
        super.reset(scene);
        this.setPose(this.initialPose.get());
        this.entity.setPosRaw(0.0, 0.0, 0.0);
        this.entity.xo = 0.0;
        this.entity.yo = 0.0;
        this.entity.zo = 0.0;
        this.entity.xOld = 0.0;
        this.entity.yOld = 0.0;
        this.entity.zOld = 0.0;
        this.entity.xRotO = 0.0f;
        this.entity.setXRot(0.0f);
        this.entity.yRotO = 180.0f;
        this.entity.setYRot(180.0f);
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        if (this.entity == null) {
            this.entity = this.pose.create(scene.getLevel());
            this.entity.yRotO = 180.0f;
            this.entity.setYRot(180.0f);
        }
        ++this.entity.tickCount;
        this.entity.yHeadRotO = this.entity.yHeadRot;
        this.entity.oFlapSpeed = this.entity.flapSpeed;
        this.entity.oFlap = this.entity.flap;
        this.entity.setOnGround(true);
        this.entity.xo = this.entity.getX();
        this.entity.yo = this.entity.getY();
        this.entity.zo = this.entity.getZ();
        this.entity.yRotO = this.entity.getYRot();
        this.entity.xRotO = this.entity.getXRot();
        this.pose.tick(scene, this.entity, this.location);
        this.entity.xOld = this.entity.getX();
        this.entity.yOld = this.entity.getY();
        this.entity.zOld = this.entity.getZ();
    }

    @Override
    public void setPositionOffset(Vec3 position, boolean immediate) {
        if (this.entity == null) {
            return;
        }
        this.entity.setPosRaw(position.x, position.y, position.z);
        if (!immediate) {
            return;
        }
        this.entity.xo = position.x;
        this.entity.yo = position.y;
        this.entity.zo = position.z;
    }

    @Override
    public void setRotation(Vec3 eulers, boolean immediate) {
        if (this.entity == null) {
            return;
        }
        this.entity.setXRot((float)eulers.x);
        this.entity.setYRot((float)eulers.y);
        if (!immediate) {
            return;
        }
        this.entity.xRotO = this.entity.getXRot();
        this.entity.yo = this.entity.getYRot();
    }

    @Override
    public Vec3 getPositionOffset() {
        return this.entity != null ? this.entity.position() : Vec3.ZERO;
    }

    @Override
    public Vec3 getRotation() {
        return this.entity != null ? new Vec3((double)this.entity.getXRot(), (double)this.entity.getYRot(), 0.0) : Vec3.ZERO;
    }

    @Override
    protected void renderLast(EntityRenderDispatcher entityRenderManager, ItemModelResolver itemModelManager, PonderLevel world, MultiBufferSource buffer, SubmitNodeCollector queue, Camera camera, CameraRenderState cameraRenderState, PoseStack poseStack, float fade, float pt) {
        if (this.entity == null) {
            this.entity = this.pose.create(world);
            this.entity.yRotO = 180.0f;
            this.entity.setYRot(180.0f);
        }
        poseStack.pushPose();
        poseStack.translate(this.location.x, this.location.y, this.location.z);
        poseStack.translate(Mth.lerp((double)pt, (double)this.entity.xo, (double)this.entity.getX()), Mth.lerp((double)pt, (double)this.entity.yo, (double)this.entity.getY()), Mth.lerp((double)pt, (double)this.entity.zo, (double)this.entity.getZ()));
        float angle = AngleHelper.angleLerp(pt, this.entity.yRotO, this.entity.getYRot());
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(angle));
        EntityRenderState state = entityRenderManager.extractEntity((Entity)this.entity, pt);
        state.shadowPieces.clear();
        entityRenderManager.submit(state, cameraRenderState, 0.0, 0.0, 0.0, poseStack, queue);
        poseStack.popPose();
    }

    @Override
    public void setPose(ParrotPose pose) {
        this.pose = pose;
    }
}

