/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.instruction;

import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.element.WorldSectionElementImpl;
import com.zurrtum.create.client.ponder.foundation.instruction.FadeIntoSceneInstruction;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public class DisplayWorldSectionInstruction
extends FadeIntoSceneInstruction<WorldSectionElement> {
    private final Selection initialSelection;
    @Nullable
    private final Supplier<WorldSectionElement> mergeOnto;
    private BlockPos glue;

    public DisplayWorldSectionInstruction(int fadeInTicks, Direction fadeInFrom, Selection selection, @Nullable Supplier<WorldSectionElement> mergeOnto) {
        this(fadeInTicks, fadeInFrom, selection, mergeOnto, null);
    }

    public DisplayWorldSectionInstruction(int fadeInTicks, Direction fadeInFrom, Selection selection, @Nullable Supplier<WorldSectionElement> mergeOnto, @Nullable BlockPos glue) {
        super(fadeInTicks, fadeInFrom, new WorldSectionElementImpl(selection));
        this.initialSelection = selection;
        this.mergeOnto = mergeOnto;
        this.glue = glue;
    }

    @Override
    protected void firstTick(PonderScene scene) {
        super.firstTick(scene);
        Optional.ofNullable(this.mergeOnto).ifPresent(wse -> ((WorldSectionElement)this.element).setAnimatedOffset(((WorldSectionElement)wse.get()).getAnimatedOffset(), true));
        ((WorldSectionElement)this.element).set(this.initialSelection);
        ((WorldSectionElement)this.element).setVisible(true);
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        if (this.remainingTicks > 0) {
            return;
        }
        Optional.ofNullable(this.mergeOnto).ifPresent(c -> ((WorldSectionElement)this.element).mergeOnto((WorldSectionElement)c.get()));
    }

    @Override
    protected Class<WorldSectionElement> getElementClass() {
        return WorldSectionElement.class;
    }
}

