/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.instruction;

import com.zurrtum.create.client.ponder.api.element.AnimatedSceneElement;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.instruction.TickingInstruction;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public class FadeOutOfSceneInstruction<T extends AnimatedSceneElement>
extends TickingInstruction {
    private final Direction fadeOutTo;
    private final ElementLink<T> link;
    private T element;

    public FadeOutOfSceneInstruction(int fadeOutTicks, Direction fadeOutTo, ElementLink<T> link) {
        super(false, fadeOutTicks);
        this.fadeOutTo = fadeOutTo == null ? null : fadeOutTo.getOpposite();
        this.link = link;
    }

    @Override
    protected void firstTick(PonderScene scene) {
        super.firstTick(scene);
        this.element = (AnimatedSceneElement)scene.resolve(this.link);
        if (this.element == null) {
            return;
        }
        this.element.setVisible(true);
        this.element.setFade(1.0f);
        this.element.setFadeVec(this.fadeOutTo == null ? Vec3.ZERO : Vec3.atLowerCornerOf((Vec3i)this.fadeOutTo.getUnitVec3i()).scale(0.5));
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        if (this.element == null) {
            return;
        }
        float fade = (float)this.remainingTicks / (float)this.totalTicks;
        this.element.setFade(1.0f - (1.0f - fade) * (1.0f - fade));
        if (this.remainingTicks == 0) {
            this.element.setVisible(false);
            this.element.setFade(0.0f);
        }
    }
}

