/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.instruction;

import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.instruction.WorldModifyInstruction;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ReplaceBlocksInstruction
extends WorldModifyInstruction {
    private final UnaryOperator<BlockState> stateToUse;
    private final boolean replaceAir;
    private final boolean spawnParticles;

    public ReplaceBlocksInstruction(Selection selection, UnaryOperator<BlockState> stateToUse, boolean replaceAir, boolean spawnParticles) {
        super(selection);
        this.stateToUse = stateToUse;
        this.replaceAir = replaceAir;
        this.spawnParticles = spawnParticles;
    }

    @Override
    protected void runModification(Selection selection, PonderScene scene) {
        PonderLevel level = scene.getLevel();
        selection.forEach(pos -> {
            if (!level.getBounds().isInside((Vec3i)pos)) {
                return;
            }
            BlockState prevState = level.getBlockState((BlockPos)pos);
            if (!this.replaceAir && prevState == Blocks.AIR.defaultBlockState()) {
                return;
            }
            if (this.spawnParticles) {
                level.addBlockDestroyEffects((BlockPos)pos, prevState);
            }
            level.setBlockAndUpdate((BlockPos)pos, (BlockState)this.stateToUse.apply(prevState));
        });
    }

    @Override
    protected boolean needsRedraw() {
        return true;
    }
}

