/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.level;

import com.zurrtum.create.client.ponder.foundation.level.PonderChunk;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.FluidState;

public class PonderChunkSection
extends LevelChunkSection {
    public final PonderChunk owner;
    protected final BlockPos.MutableBlockPos scratchPos;
    public final int xStart;
    public final int yStart;
    public final int zStart;
    public boolean empty;

    public PonderChunkSection(PonderChunk owner, BlockPos.MutableBlockPos scratchPos, ChunkPos pos, int yBase, boolean hasBlock) {
        super(owner.world.palettedContainerFactory());
        this.owner = owner;
        this.scratchPos = scratchPos;
        this.xStart = pos.getMinBlockX();
        this.yStart = yBase;
        this.zStart = pos.getMinBlockZ();
        this.empty = !hasBlock;
    }

    public BlockState getBlockState(int x, int y, int z) {
        return this.owner.world.getBlockState((BlockPos)this.scratchPos.set(x + this.xStart, y + this.yStart, z + this.zStart));
    }

    public FluidState getFluidState(int x, int y, int z) {
        return this.getBlockState(x, y, z).getFluidState();
    }

    public BlockState setBlockState(int x, int y, int z, BlockState state, boolean useLocks) {
        throw new UnsupportedOperationException("Chunk sections cannot be mutated in a fake world.");
    }

    public boolean hasOnlyAir() {
        return this.empty;
    }
}

