/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.registration;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.client.ponder.api.registration.LangRegistryAccess;
import com.zurrtum.create.client.ponder.foundation.PonderIndex;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.Identifier;

public class PonderLocalization
implements LangRegistryAccess {
    public static final String LANG_PREFIX = "ponder.";
    public static final String UI_PREFIX = "ui.";
    public final Map<Identifier, String> shared = new HashMap<Identifier, String>();
    public final Map<Identifier, Couple<String>> tag = new HashMap<Identifier, Couple<String>>();
    public final Map<Identifier, Map<String, String>> specific = new HashMap<Identifier, Map<String, String>>();

    public void clearAll() {
        this.shared.clear();
        this.tag.clear();
        this.specific.clear();
    }

    public void clearShared() {
        this.shared.clear();
    }

    public void registerShared(Identifier key, String enUS) {
        this.shared.put(key, enUS);
    }

    public void registerTag(Identifier key, String title, String description) {
        this.tag.put(key, Couple.create(title, description));
    }

    public void registerSpecific(Identifier sceneId, String key, String enUS) {
        this.specific.computeIfAbsent(sceneId, $ -> new HashMap()).put(key, enUS);
    }

    protected static String langKeyForShared(Identifier k) {
        return k.getNamespace() + ".ponder.shared." + k.getPath();
    }

    protected static String langKeyForTag(Identifier k) {
        return k.getNamespace() + ".ponder.tag." + k.getPath();
    }

    protected static String langKeyForTagDescription(Identifier k) {
        return k.getNamespace() + ".ponder.tag." + k.getPath() + ".description";
    }

    protected static String langKeyForSpecific(Identifier sceneId, String k) {
        return sceneId.getNamespace() + ".ponder." + sceneId.getPath() + "." + k;
    }

    @Override
    public String getShared(Identifier key) {
        if (PonderIndex.editingModeActive()) {
            return this.shared.containsKey(key) ? this.shared.get(key) : "unregistered shared entry: " + String.valueOf(key);
        }
        return I18n.get((String)PonderLocalization.langKeyForShared(key), (Object[])new Object[0]);
    }

    @Override
    public String getShared(Identifier key, Object ... params) {
        if (PonderIndex.editingModeActive()) {
            return this.shared.containsKey(key) ? String.format(this.shared.get(key), params) : "unregistered shared entry: " + String.valueOf(key);
        }
        return I18n.get((String)PonderLocalization.langKeyForShared(key), (Object[])params);
    }

    @Override
    public String getTagName(Identifier key) {
        if (PonderIndex.editingModeActive()) {
            return this.tag.containsKey(key) ? (String)this.tag.get(key).getFirst() : "unregistered tag entry: " + String.valueOf(key);
        }
        return I18n.get((String)PonderLocalization.langKeyForTag(key), (Object[])new Object[0]);
    }

    @Override
    public String getTagDescription(Identifier key) {
        if (PonderIndex.editingModeActive()) {
            return this.tag.containsKey(key) ? (String)this.tag.get(key).getSecond() : "unregistered tag entry: " + String.valueOf(key);
        }
        return I18n.get((String)PonderLocalization.langKeyForTagDescription(key), (Object[])new Object[0]);
    }

    @Override
    public String getSpecific(Identifier sceneId, String k) {
        if (PonderIndex.editingModeActive()) {
            try {
                return this.specific.get(sceneId).get(k);
            }
            catch (Exception e) {
                return "MISSING_SPECIFIC";
            }
        }
        return I18n.get((String)PonderLocalization.langKeyForSpecific(sceneId, k), (Object[])new Object[0]);
    }

    @Override
    public String getSpecific(Identifier sceneId, String k, Object ... params) {
        if (PonderIndex.editingModeActive()) {
            try {
                return String.format(this.specific.get(sceneId).get(k), params);
            }
            catch (Exception e) {
                return "MISSING_SPECIFIC";
            }
        }
        return I18n.get((String)PonderLocalization.langKeyForSpecific(sceneId, k), (Object[])params);
    }
}

