/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.ponder.foundation.ui;

import com.google.common.graph.ElementOrder;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.mojang.blaze3d.platform.ClipboardManager;
import com.mojang.blaze3d.platform.Window;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.catnip.registry.RegisteredObjectsHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.NavigatableSimiScreen;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.gui.element.AbstractRenderElement;
import com.zurrtum.create.client.catnip.gui.element.BoxElement;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.element.RenderElement;
import com.zurrtum.create.client.catnip.gui.element.ScreenElement;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import com.zurrtum.create.client.catnip.gui.widget.BoxWidget;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.catnip.lang.ClientFontHelper;
import com.zurrtum.create.client.ponder.Ponder;
import com.zurrtum.create.client.ponder.api.registration.StoryBoardEntry;
import com.zurrtum.create.client.ponder.enums.PonderConfig;
import com.zurrtum.create.client.ponder.enums.PonderGuiTextures;
import com.zurrtum.create.client.ponder.foundation.PonderChapter;
import com.zurrtum.create.client.ponder.foundation.PonderIndex;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.PonderStoryBoardEntry;
import com.zurrtum.create.client.ponder.foundation.PonderTag;
import com.zurrtum.create.client.ponder.foundation.content.DebugScenes;
import com.zurrtum.create.client.ponder.foundation.element.TextWindowElement;
import com.zurrtum.create.client.ponder.foundation.render.SceneRenderState;
import com.zurrtum.create.client.ponder.foundation.render.TitleTextRenderState;
import com.zurrtum.create.client.ponder.foundation.ui.AbstractPonderScreen;
import com.zurrtum.create.client.ponder.foundation.ui.PonderButton;
import com.zurrtum.create.client.ponder.foundation.ui.PonderProgressBar;
import com.zurrtum.create.client.ponder.foundation.ui.PonderTagScreen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;

public class PonderUI
extends AbstractPonderScreen {
    public static int ponderTicks;
    public static float ponderPartialTicksPaused;
    public static final Color BACKGROUND_TRANSPARENT;
    public static final Color BACKGROUND_FLAT;
    public static final Color BACKGROUND_IMPORTANT;
    public static final Couple<Color> COLOR_IDLE;
    public static final Couple<Color> COLOR_HOVER;
    public static final Couple<Color> COLOR_HIGHLIGHT;
    public static final Couple<Color> MISSING_VANILLA_ENTRY;
    public static final Couple<Color> MISSING_MODDED_ENTRY;
    private final List<PonderScene> scenes;
    private final List<PonderTag> tags;
    private List<PonderButton> tagButtons = new ArrayList<PonderButton>();
    private List<LerpedFloat> tagFades = new ArrayList<LerpedFloat>();
    private final LerpedFloat fadeIn;
    ItemStack stack;
    GuiGameElement.GuiItemRenderBuilder itemRender;
    @Nullable
    PonderChapter chapter = null;
    private boolean userViewMode;
    private boolean identifyMode;
    private ItemStack hoveredTooltipItem = ItemStack.EMPTY;
    @Nullable
    private BlockPos hoveredBlockPos;
    private final ClipboardManager clipboardHelper;
    @Nullable
    private BlockPos copiedBlockPos;
    private final LerpedFloat finishingFlash;
    private final LerpedFloat nextUp;
    private int finishingFlashWarmup = 0;
    private int nextUpWarmup = 0;
    private final LerpedFloat lazyIndex;
    private int index = 0;
    @Nullable
    private PonderTag referredToByTag;
    private PonderButton left;
    private PonderButton right;
    private PonderButton scan;
    private PonderButton chap;
    private PonderButton userMode;
    private PonderButton close;
    private PonderButton replay;
    private PonderButton slowMode;
    private int skipCooling = 0;
    private int extendedTickLength = 0;
    private int extendedTickTimer = 0;

    public static PonderUI of(Identifier id) {
        return new PonderUI(PonderIndex.getSceneAccess().compile(id));
    }

    public static PonderUI of(ItemStack item) {
        return new PonderUI(PonderIndex.getSceneAccess().compile(RegisteredObjectsHelper.getKeyOrThrow(item.getItem())));
    }

    public static PonderUI of(ItemStack item, PonderTag tag) {
        PonderUI ponderUI = new PonderUI(PonderIndex.getSceneAccess().compile(RegisteredObjectsHelper.getKeyOrThrow(item.getItem())));
        ponderUI.referredToByTag = tag;
        return ponderUI;
    }

    protected PonderUI(List<PonderScene> scenes) {
        List<PonderScene> orderedScenes;
        Identifier location = scenes.get(0).getLocation();
        this.stack = new ItemStack(RegisteredObjectsHelper.getItemOrBlock(location));
        this.itemRender = (GuiGameElement.GuiItemRenderBuilder)GuiGameElement.of(this.stack).scale(2.0f).at(-35.0f, 1.0f);
        this.tags = new ArrayList<PonderTag>(PonderIndex.getTagAccess().getTags(location));
        Ponder.LOGGER.debug("Ponder Scenes before ordering: {}", (Object)Arrays.toString(scenes.stream().map(PonderScene::getId).toArray()));
        try {
            orderedScenes = this.orderScenes(scenes);
            Ponder.LOGGER.debug("Ponder Scenes after ordering: {}", (Object)Arrays.toString(orderedScenes.stream().map(PonderScene::getId).toArray()));
        }
        catch (Exception e) {
            Ponder.LOGGER.warn("Unable to sort PonderScenes, using unordered List", (Throwable)e);
            orderedScenes = scenes;
        }
        this.scenes = orderedScenes;
        if (this.scenes.isEmpty()) {
            List<StoryBoardEntry> list = Collections.singletonList(new PonderStoryBoardEntry(DebugScenes::empty, "ponder", "debug/scene_1", Identifier.parse((String)"stick")));
            this.scenes.addAll(PonderIndex.getSceneAccess().compile(list));
        }
        this.lazyIndex = LerpedFloat.linear().startWithValue(this.index);
        this.fadeIn = LerpedFloat.linear().startWithValue(0.0).chase(1.0, 0.1f, LerpedFloat.Chaser.EXP);
        this.clipboardHelper = new ClipboardManager();
        this.finishingFlash = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.1f, LerpedFloat.Chaser.EXP);
        this.nextUp = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.4f, LerpedFloat.Chaser.EXP);
    }

    private List<PonderScene> orderScenes(List<PonderScene> scenes) {
        Map<Boolean, List<PonderScene>> partitioned = scenes.stream().collect(Collectors.partitioningBy(scene -> scene.getOrderingEntries().isEmpty()));
        List<PonderScene> scenesWithOrdering = partitioned.get(false);
        List<PonderScene> scenesWithoutOrdering = partitioned.get(true);
        if (scenesWithOrdering.isEmpty()) {
            return scenes;
        }
        ArrayList<PonderScene> sceneList = new ArrayList<PonderScene>(scenes);
        Collections.reverse(sceneList);
        Map<Identifier, PonderScene> sceneLookup = scenes.stream().collect(Collectors.toMap(PonderScene::getId, scene -> scene));
        MutableGraph graph = GraphBuilder.directed().nodeOrder(ElementOrder.insertion()).build();
        sceneList.forEach(arg_0 -> ((MutableGraph)graph).addNode(arg_0));
        IntStream.range(1, scenesWithoutOrdering.size()).forEach(i -> graph.putEdge((Object)((PonderScene)scenesWithoutOrdering.get(i - 1)), (Object)((PonderScene)scenesWithoutOrdering.get(i))));
        scenesWithOrdering.forEach(scene -> {
            List<StoryBoardEntry.SceneOrderingEntry> relevantOrderings = scene.getOrderingEntries().stream().filter(entry -> scenes.stream().anyMatch(sc -> sc.getId().equals((Object)entry.sceneId()))).toList();
            if (relevantOrderings.isEmpty()) {
                return;
            }
            relevantOrderings.forEach(entry -> {
                PonderScene otherScene = (PonderScene)sceneLookup.get(entry.sceneId());
                if (entry.type() == StoryBoardEntry.SceneOrderingType.BEFORE) {
                    graph.putEdge(scene, (Object)otherScene);
                } else if (entry.type() == StoryBoardEntry.SceneOrderingType.AFTER) {
                    graph.putEdge((Object)otherScene, scene);
                }
            });
        });
        return PonderUI.topologicalSort((MutableGraph<PonderScene>)graph);
    }

    private static List<PonderScene> topologicalSort(MutableGraph<PonderScene> graph) {
        ArrayList<PonderScene> result = new ArrayList<PonderScene>();
        HashSet<PonderScene> visited = new HashSet<PonderScene>();
        HashSet<PonderScene> currentlyVisiting = new HashSet<PonderScene>();
        for (PonderScene node : graph.nodes()) {
            if (visited.contains(node) || PonderUI.dfs(node, graph, visited, currentlyVisiting, result)) continue;
            throw new IllegalArgumentException("Graph has a cycle!");
        }
        Collections.reverse(result);
        return result;
    }

    private static boolean dfs(PonderScene node, MutableGraph<PonderScene> graph, Set<PonderScene> visited, Set<PonderScene> currentlyVisiting, List<PonderScene> result) {
        if (currentlyVisiting.contains(node)) {
            return false;
        }
        if (!visited.contains(node)) {
            currentlyVisiting.add(node);
            for (PonderScene neighbor : graph.successors((Object)node)) {
                if (PonderUI.dfs(neighbor, graph, visited, currentlyVisiting, result)) continue;
                return false;
            }
            currentlyVisiting.remove(node);
            visited.add(node);
            result.add(node);
        }
        return true;
    }

    @Override
    protected void init() {
        super.init();
        this.tagButtons = new ArrayList<PonderButton>();
        this.tagFades = new ArrayList<LerpedFloat>();
        this.tags.forEach(t -> {
            int i = this.tagButtons.size();
            int x = 31;
            int y = 81 + i * 30;
            PonderButton b2 = (PonderButton)((AbstractSimiWidget)new PonderButton(x, y).showing((ScreenElement)t)).withCallback((mX, mY) -> {
                this.centerScalingOn((int)mX, (int)mY);
                ScreenOpener.transitionTo(new PonderTagScreen((PonderTag)t));
            });
            this.addRenderableWidget(b2);
            this.tagButtons.add(b2);
            LerpedFloat chase = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.05f, LerpedFloat.Chaser.exp(0.1));
            this.tagFades.add(chase);
        });
        Options bindings = this.minecraft.options;
        int spacing = 8;
        int bX = (this.width - 20) / 2 - (70 + 2 * spacing);
        int bY = this.height - 20 - 31;
        int pX = this.width / 2 - 110;
        int pY = bY + 20 + 4;
        int pW = this.width - 2 * pX;
        this.addRenderableWidget(new PonderProgressBar(this, pX, pY, pW, 1));
        this.scan = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX, bY).withShortcut(bindings.keyDrop)).showing(PonderGuiTextures.ICON_PONDER_IDENTIFY)).enableFade(0, 5)).withCallback(() -> {
            boolean bl = this.identifyMode = !this.identifyMode;
            if (!this.identifyMode) {
                this.scenes.get(this.index).deselect();
            } else {
                ponderPartialTicksPaused = AnimationTickHolder.getPartialTicksUI(this.minecraft.getDeltaTracker());
            }
        });
        this.addRenderableWidget(this.scan);
        this.scan.atZLevel(600.0f);
        this.slowMode = (PonderButton)((AbstractSimiWidget)((ElementWidget)new PonderButton(this.width - 20 - 31, bY).showing(PonderGuiTextures.ICON_PONDER_SLOW_MODE)).enableFade(0, 5)).withCallback(() -> this.setComfyReadingEnabled(!this.isComfyReadingEnabled()));
        this.addRenderableWidget(this.slowMode);
        if (PonderIndex.editingModeActive()) {
            this.userMode = (PonderButton)((AbstractSimiWidget)((ElementWidget)new PonderButton(this.width - 50 - 31, bY).showing(PonderGuiTextures.ICON_PONDER_USER_MODE)).enableFade(0, 5)).withCallback(() -> {
                this.userViewMode = !this.userViewMode;
            });
            this.addRenderableWidget(this.userMode);
        }
        this.left = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 50 + spacing, bY).withShortcut(bindings.keyLeft)).showing(PonderGuiTextures.ICON_PONDER_LEFT)).enableFade(0, 5)).withCallback(() -> this.scroll(false));
        this.addRenderableWidget(this.left);
        this.close = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 20 + spacing, bY).withShortcut(bindings.keyInventory)).showing(PonderGuiTextures.ICON_PONDER_CLOSE)).enableFade(0, 5)).withCallback(this::onClose);
        this.addRenderableWidget(this.close);
        this.right = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 20 + spacing, bY).withShortcut(bindings.keyRight)).showing(PonderGuiTextures.ICON_PONDER_RIGHT)).enableFade(0, 5)).withCallback(() -> this.scroll(true));
        this.addRenderableWidget(this.right);
        this.replay = (PonderButton)((AbstractSimiWidget)((ElementWidget)((ElementWidget)new PonderButton(bX += 50 + spacing, bY).withShortcut(bindings.keyDown)).showing(PonderGuiTextures.ICON_PONDER_REPLAY)).enableFade(0, 5)).withCallback(this::replay);
        this.addRenderableWidget(this.replay);
    }

    @Override
    protected void initBackTrackIcon(BoxWidget backTrack) {
        backTrack.showingElement((RenderElement)GuiGameElement.of(this.stack).scale(1.5f).at(-4.0f, -4.0f));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.skipCooling > 0) {
            --this.skipCooling;
        }
        if (this.referredToByTag != null) {
            for (int i = 0; i < this.scenes.size(); ++i) {
                PonderScene ponderScene = this.scenes.get(i);
                if (!ponderScene.getTags().contains(this.referredToByTag)) continue;
                if (i == this.index) break;
                this.scenes.get(this.index).fadeOut();
                this.index = i;
                this.scenes.get(this.index).begin();
                this.lazyIndex.chase(this.index, 0.25, LerpedFloat.Chaser.EXP);
                this.identifyMode = false;
                break;
            }
            this.referredToByTag = null;
        }
        this.lazyIndex.tickChaser();
        this.fadeIn.tickChaser();
        this.finishingFlash.tickChaser();
        this.nextUp.tickChaser();
        PonderScene activeScene = this.scenes.get(this.index);
        this.extendedTickLength = 0;
        if (this.isComfyReadingEnabled()) {
            activeScene.forEachVisible(TextWindowElement.class, twe -> {
                this.extendedTickLength = 2;
            });
        }
        if (this.extendedTickTimer == 0) {
            float lazyIndexValue;
            if (!this.identifyMode) {
                ++ponderTicks;
                if (this.skipCooling == 0) {
                    activeScene.tick();
                }
            }
            if (!this.identifyMode && Math.abs((lazyIndexValue = this.lazyIndex.getValue()) - (float)this.index) > 0.001953125f) {
                this.scenes.get(lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1).tick();
            }
            this.extendedTickTimer = this.extendedTickLength;
        } else {
            --this.extendedTickTimer;
        }
        if (activeScene.getCurrentTime() == activeScene.getTotalTime() - 1) {
            this.finishingFlashWarmup = 30;
            this.nextUpWarmup = 50;
        }
        if (this.finishingFlashWarmup > 0) {
            --this.finishingFlashWarmup;
            if (this.finishingFlashWarmup == 0) {
                this.finishingFlash.setValue(1.0);
                this.finishingFlash.setValue(1.0);
            }
        }
        if (this.nextUpWarmup > 0) {
            --this.nextUpWarmup;
            if (this.nextUpWarmup == 0) {
                this.nextUp.updateChaseTarget(1.0f);
            }
        }
        this.updateIdentifiedItem(activeScene);
    }

    public PonderScene getActiveScene() {
        return this.scenes.get(this.index);
    }

    public void seekToTime(int time) {
        if (this.getActiveScene().getCurrentTime() > time) {
            this.replay();
        }
        this.getActiveScene().seekToTime(time);
        if (time != 0) {
            this.coolDownAfterSkip();
        }
    }

    public void updateIdentifiedItem(PonderScene activeScene) {
        this.hoveredTooltipItem = ItemStack.EMPTY;
        this.hoveredBlockPos = null;
        if (!this.identifyMode) {
            return;
        }
        Window w = this.minecraft.getWindow();
        double mouseX = this.minecraft.mouseHandler.xpos() * (double)w.getGuiScaledWidth() / (double)w.getScreenWidth();
        double mouseY = this.minecraft.mouseHandler.ypos() * (double)w.getGuiScaledHeight() / (double)w.getScreenHeight();
        PonderScene.SceneTransform t = activeScene.getTransform();
        Vec3 vec1 = t.screenToScene(mouseX, mouseY, 1000, 0.0f);
        Vec3 vec2 = t.screenToScene(mouseX, mouseY, -100, 0.0f);
        Pair<ItemStack, BlockPos> pair = activeScene.rayTraceScene(vec1, vec2);
        this.hoveredTooltipItem = pair.getFirst();
        this.hoveredBlockPos = pair.getSecond();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.scroll(scrollY > 0.0)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    protected void replay() {
        this.identifyMode = false;
        PonderScene scene = this.scenes.get(this.index);
        if (AllKeys.hasShiftDown()) {
            PonderIndex.reload();
            this.scenes.clear();
            this.scenes.addAll(PonderIndex.getSceneAccess().compile(scene.getLocation()));
        }
        scene.begin();
    }

    protected boolean scroll(boolean forward) {
        int prevIndex = this.index;
        this.index = forward ? this.index + 1 : this.index - 1;
        this.index = Mth.clamp((int)this.index, (int)0, (int)(this.scenes.size() - 1));
        if (prevIndex != this.index) {
            this.scenes.get(prevIndex).fadeOut();
            this.scenes.get(this.index).begin();
            this.lazyIndex.chase(this.index, 0.25, LerpedFloat.Chaser.EXP);
            this.identifyMode = false;
            return true;
        }
        this.index = prevIndex;
        return false;
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        partialTicks = PonderUI.getPartialTicks();
        this.renderVisibleScenes(graphics, mouseX, mouseY, this.skipCooling > 0 ? 0.0f : (this.identifyMode ? ponderPartialTicksPaused : partialTicks));
        this.renderWidgets(graphics, mouseX, mouseY, this.identifyMode ? ponderPartialTicksPaused : partialTicks);
    }

    protected void renderVisibleScenes(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Window window = graphics.minecraft.getWindow();
        float uiTicks = this.lazyIndex.getValue(AnimationTickHolder.getPartialTicksUI(this.minecraft.getDeltaTracker()));
        this.renderScene(graphics, 0, window, this.index, partialTicks, uiTicks);
        float lazyIndexValue = this.lazyIndex.getValue(partialTicks);
        if (Math.abs(lazyIndexValue - (float)this.index) > 0.001953125f) {
            this.renderScene(graphics, 1, window, lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1, partialTicks, uiTicks);
        }
    }

    protected void renderScene(GuiGraphics graphics, int id, Window window, int i, float partialTicks, float uiTicks) {
        double diff = (float)i - uiTicks;
        double slide = Mth.lerp((double)(diff * diff), (double)200.0, (double)600.0) * diff;
        PonderScene scene = this.scenes.get(i);
        graphics.guiRenderState.submitPicturesInPictureState((PictureInPictureRenderState)new SceneRenderState(id, scene, this.width, this.height, slide, this.userViewMode, this.finishingFlash, partialTicks, window, new Matrix3x2f((Matrix3x2fc)graphics.pose())));
    }

    protected void renderWidgets(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        float fade = this.fadeIn.getValue(partialTicks);
        float lazyIndexValue = this.lazyIndex.getValue(partialTicks);
        float indexDiff = lazyIndexValue - (float)this.index;
        PonderScene activeScene = this.scenes.get(this.index);
        PonderScene nextScene = this.scenes.size() > this.index + 1 ? this.scenes.get(this.index + 1) : null;
        boolean noWidgetsHovered = true;
        for (GuiEventListener child : this.children()) {
            noWidgetsHovered &= !child.isMouseOver((double)mouseX, (double)mouseY);
        }
        int tooltipColor = ((Color)UIRenderHelper.COLOR_TEXT_DARKER.getFirst()).getRGB();
        this.renderSceneInformation(graphics, fade, indexDiff, activeScene, tooltipColor);
        Matrix3x2fStack ms = graphics.pose();
        Minecraft mc = Minecraft.getInstance();
        if (this.identifyMode) {
            if (noWidgetsHovered && mouseY < this.height - 80) {
                if (this.hoveredTooltipItem.isEmpty()) {
                    MutableComponent text = Ponder.lang().translate("ui.identify_mode", ((MutableComponent)this.minecraft.options.keyDrop.getTranslatedKeyMessage()).withStyle(ChatFormatting.WHITE)).style(ChatFormatting.GRAY).component();
                    List<Component> tooltipLines = this.font.getSplitter().splitLines((FormattedText)text, this.width / 3, Style.EMPTY).stream().map(t -> Component.literal((String)t.getString())).toList();
                    graphics.setComponentTooltipForNextFrame(this.font, tooltipLines, mouseX, mouseY);
                } else {
                    graphics.setTooltipForNextFrame(this.font, this.hoveredTooltipItem, mouseX, mouseY);
                }
                if (this.hoveredBlockPos != null && PonderIndex.editingModeActive() && !this.userViewMode) {
                    boolean copied = this.hoveredBlockPos.equals((Object)this.copiedBlockPos);
                    MutableComponent coords = Component.literal((String)(this.hoveredBlockPos.getX() + ", " + this.hoveredBlockPos.getY() + ", " + this.hoveredBlockPos.getZ())).withStyle(copied ? ChatFormatting.GREEN : ChatFormatting.GOLD);
                    graphics.setTooltipForNextFrame(this.font, (Component)coords, 0, -15);
                }
            }
            this.scan.flash();
        } else {
            this.scan.dim();
        }
        if (PonderIndex.editingModeActive()) {
            if (this.userViewMode) {
                this.userMode.flash();
            } else {
                this.userMode.dim();
            }
        }
        if (this.isComfyReadingEnabled()) {
            this.slowMode.flash();
        } else {
            this.slowMode.dim();
        }
        this.renderSceneOverlay(graphics, partialTicks, lazyIndexValue, Math.abs(indexDiff));
        this.renderNextUp(graphics, partialTicks, nextScene);
        this.getRenderables().forEach(w -> {
            if (w instanceof PonderButton) {
                PonderButton button = (PonderButton)w;
                button.fade().startWithValue(fade);
            }
        });
        if (this.index == 0 || this.index == 1 && lazyIndexValue < (float)this.index) {
            this.left.fade().startWithValue(lazyIndexValue);
        }
        if (this.index == this.scenes.size() - 1 || this.index == this.scenes.size() - 2 && lazyIndexValue > (float)this.index) {
            this.right.fade().startWithValue((float)this.scenes.size() - lazyIndexValue - 1.0f);
        }
        if (activeScene.isFinished()) {
            this.right.flash();
        } else {
            this.right.dim();
            this.nextUp.updateChaseTarget(0.0f);
        }
        Color c1 = ((Color)COLOR_NAV_ARROW.getFirst()).setAlpha(64);
        Color c2 = ((Color)COLOR_NAV_ARROW.getFirst()).setAlpha(32);
        Color c3 = ((Color)COLOR_NAV_ARROW.getFirst()).setAlpha(16);
        UIRenderHelper.breadcrumbArrow(graphics, this.width / 2 - 20, this.height - 51, 20, 20, 5, c1, c2);
        UIRenderHelper.breadcrumbArrow(graphics, this.width / 2 + 20, this.height - 51, -20, 20, -5, c1, c2);
        UIRenderHelper.breadcrumbArrow(graphics, this.width / 2 - 90, this.height - 51, 70, 20, 5, c1, c3);
        UIRenderHelper.breadcrumbArrow(graphics, this.width / 2 + 90, this.height - 51, -70, 20, -5, c1, c3);
        List<PonderTag> sceneTags = activeScene.getTags();
        boolean highlightAll = sceneTags.stream().anyMatch(tag -> tag.getId() == PonderTag.Highlight.ALL);
        double s = mc.getWindow().getGuiScale();
        IntStream.range(0, this.tagButtons.size()).forEach(i -> {
            ms.pushMatrix();
            PonderTag tag = this.tags.get(i);
            LerpedFloat chase = this.tagFades.get(i);
            PonderButton button = this.tagButtons.get(i);
            if (button.isMouseOver(mouseX, mouseY)) {
                chase.updateChaseTarget(1.0f);
            } else {
                chase.updateChaseTarget(0.0f);
            }
            chase.tickChaser();
            if (highlightAll || sceneTags.contains(tag)) {
                button.flash();
            } else {
                button.dim();
            }
            int x = button.getX() + button.getWidth() + 4;
            int y = button.getY() - 2;
            ms.translate((float)x, (float)y + 5.0f * (1.0f - fade));
            float fadedWidth = 200.0f * chase.getValue(partialTicks);
            UIRenderHelper.streak(graphics, 0.0f, 0, 12, 26, (int)fadedWidth);
            graphics.enableScissor(0, 8, (int)fadedWidth, 8 + this.height);
            String tagName = tag.getTitle();
            graphics.drawString(this.font, tagName, 3, 8, ((Color)UIRenderHelper.COLOR_TEXT_ACCENT.getFirst()).getRGB(), false);
            graphics.disableScissor();
            ms.popMatrix();
        });
        this.renderHoverTooltips(graphics, tooltipColor);
    }

    private void renderHoverTooltips(GuiGraphics graphics, int tooltipColor) {
        int tooltipY = this.height - 16;
        if (this.scan.isHoveredOrFocused()) {
            graphics.drawCenteredString(this.font, (Component)Ponder.lang().translate("ui.identify", new Object[0]).component(), this.scan.getX() + 10, tooltipY, tooltipColor);
        }
        if (this.index != 0 && this.left.isHoveredOrFocused()) {
            graphics.drawCenteredString(this.font, (Component)Ponder.lang().translate("ui.previous", new Object[0]).component(), this.left.getX() + 10, tooltipY, tooltipColor);
        }
        if (this.close.isHoveredOrFocused()) {
            graphics.drawCenteredString(this.font, (Component)Ponder.lang().translate("ui.close", new Object[0]).component(), this.close.getX() + 10, tooltipY, tooltipColor);
        }
        if (this.index != this.scenes.size() - 1 && this.right.isHoveredOrFocused()) {
            graphics.drawCenteredString(this.font, (Component)Ponder.lang().translate("ui.next", new Object[0]).component(), this.right.getX() + 10, tooltipY, tooltipColor);
        }
        if (this.replay.isHoveredOrFocused()) {
            graphics.drawCenteredString(this.font, (Component)Ponder.lang().translate("ui.replay", new Object[0]).component(), this.replay.getX() + 10, tooltipY, tooltipColor);
        }
        if (this.slowMode.isHoveredOrFocused()) {
            graphics.drawCenteredString(this.font, (Component)Ponder.lang().translate("ui.slow_text", new Object[0]).component(), this.slowMode.getX() + 5, tooltipY, tooltipColor);
        }
        if (PonderIndex.editingModeActive() && this.userMode.isHoveredOrFocused()) {
            graphics.drawCenteredString(this.font, "Editor View", this.userMode.getX() + 10, tooltipY, tooltipColor);
        }
    }

    private void renderNextUp(GuiGraphics graphics, float partialTicks, @Nullable PonderScene nextScene) {
        if (!this.getActiveScene().isFinished()) {
            return;
        }
        if (nextScene == null || !nextScene.isNextUpEnabled()) {
            return;
        }
        if (!(this.nextUp.getValue() > 0.0625f)) {
            return;
        }
        Matrix3x2fStack poseStack = graphics.pose();
        poseStack.pushMatrix();
        poseStack.translate((float)(this.right.getX() + 10), (float)(this.right.getY() - 6) + this.nextUp.getValue(partialTicks) * 5.0f);
        MutableComponent nextUpComponent = Ponder.lang().translate("ui.next_up", new Object[0]).component();
        int boxWidth = Math.max(this.font.width(nextScene.getTitle()), this.font.width((FormattedText)nextUpComponent)) + 5;
        PonderUI.renderSpeechBox(graphics, 0, 0, boxWidth, 20, this.right.isHoveredOrFocused(), Pointing.DOWN, false);
        poseStack.translate(0.0f, -29.0f);
        graphics.drawCenteredString(this.font, (Component)nextUpComponent, 0, 0, ((Color)UIRenderHelper.COLOR_TEXT_DARKER.getFirst()).getRGB());
        graphics.drawCenteredString(this.font, nextScene.getTitle(), 0, 10, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        poseStack.popMatrix();
    }

    private void renderSceneOverlay(GuiGraphics graphics, float partialTicks, float lazyIndexValue, float indexDiff) {
        float scenePT = this.skipCooling > 0 ? 0.0f : partialTicks;
        this.renderOverlay(graphics, this.index, scenePT);
        if (indexDiff > 0.001953125f) {
            this.renderOverlay(graphics, lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1, scenePT);
        }
    }

    private void renderSceneInformation(GuiGraphics graphics, float fade, float indexDiff, PonderScene activeScene, int tooltipColor) {
        int otherTitleWidth;
        float indexOffset;
        float absoluteIndexDiff = Math.abs(indexDiff);
        int otherIndex = this.index;
        if (this.scenes.size() != 1 && (double)absoluteIndexDiff >= 0.01 && ((otherIndex = this.index + (int)(indexOffset = Math.signum(indexDiff))) < 0 || otherIndex >= this.scenes.size())) {
            return;
        }
        String title = activeScene.getTitle();
        String otherTitle = this.scenes.get(otherIndex).getTitle();
        int maxTitleWidth = 180;
        int titleWidth = this.font.width(title);
        if (titleWidth > maxTitleWidth) {
            titleWidth = maxTitleWidth;
        }
        if ((otherTitleWidth = this.font.width(otherTitle)) > maxTitleWidth) {
            otherTitleWidth = maxTitleWidth;
        }
        int wrappedTitleHeight = this.font.wordWrapHeight((FormattedText)Component.literal((String)title), maxTitleWidth);
        int otherWrappedTitleHeight = this.font.wordWrapHeight((FormattedText)Component.literal((String)otherTitle), maxTitleWidth);
        int streakHeight = 26 + Mth.lerpInt((float)absoluteIndexDiff, (int)wrappedTitleHeight, (int)otherWrappedTitleHeight);
        int streakWidth = 70 + Mth.lerpInt((float)absoluteIndexDiff, (int)titleWidth, (int)otherTitleWidth);
        Matrix3x2fStack poseStack = graphics.pose();
        poseStack.pushMatrix();
        poseStack.translate(55.0f, 19.0f);
        UIRenderHelper.streak(graphics, 0.0f, 0, streakHeight / 2, streakHeight, (int)((float)streakWidth * fade));
        UIRenderHelper.streak(graphics, 180.0f, 0, streakHeight / 2, streakHeight, (int)(30.0f * fade));
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(BACKGROUND_FLAT)).gradientBorder(COLOR_IDLE)).at(-34.0f, 2.0f, 100.0f).withBounds(30, 30).render(graphics);
        this.itemRender.render(graphics);
        poseStack.translate(4.0f, 6.0f);
        graphics.drawString(this.font, (Component)Ponder.lang().translate("ui.pondering", new Object[0]).component(), 0, 0, tooltipColor, false);
        poseStack.translate(0.0f, 14.0f);
        if (this.scenes.size() == 1 || (double)absoluteIndexDiff < 0.01) {
            ClientFontHelper.drawSplitString(graphics, this.font, title, 0, 0, maxTitleWidth, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).scaleAlphaForText(fade).getRGB());
            poseStack.popMatrix();
            return;
        }
        graphics.guiRenderState.submitPicturesInPictureState((PictureInPictureRenderState)new TitleTextRenderState(new Matrix3x2f((Matrix3x2fc)poseStack), 0, 0, indexDiff, title, otherTitle));
        poseStack.popMatrix();
    }

    private void renderOverlay(GuiGraphics graphics, int i, float partialTicks) {
        if (this.identifyMode) {
            return;
        }
        Matrix3x2fStack matrices = graphics.pose();
        matrices.pushMatrix();
        PonderScene story = this.scenes.get(i);
        story.renderOverlay(this, graphics, this.skipCooling > 0 ? 0.0f : (this.identifyMode ? ponderPartialTicksPaused : partialTicks));
        matrices.popMatrix();
    }

    public boolean mouseClicked(MouseButtonEvent click, boolean doubled) {
        if (this.identifyMode && this.hoveredBlockPos != null && PonderIndex.editingModeActive()) {
            Window window = this.minecraft.getWindow();
            if (this.copiedBlockPos != null && click.button() == 1) {
                this.clipboardHelper.setClipboard(window, "util.select().fromTo(" + this.copiedBlockPos.getX() + ", " + this.copiedBlockPos.getY() + ", " + this.copiedBlockPos.getZ() + ", " + this.hoveredBlockPos.getX() + ", " + this.hoveredBlockPos.getY() + ", " + this.hoveredBlockPos.getZ() + ")");
                this.copiedBlockPos = this.hoveredBlockPos;
                return true;
            }
            if (AllKeys.hasShiftDown()) {
                this.clipboardHelper.setClipboard(window, "util.select().position(" + this.hoveredBlockPos.getX() + ", " + this.hoveredBlockPos.getY() + ", " + this.hoveredBlockPos.getZ() + ")");
            } else {
                this.clipboardHelper.setClipboard(window, "util.grid().at(" + this.hoveredBlockPos.getX() + ", " + this.hoveredBlockPos.getY() + ", " + this.hoveredBlockPos.getZ() + ")");
            }
            this.copiedBlockPos = this.hoveredBlockPos;
            return true;
        }
        return super.mouseClicked(click, doubled);
    }

    @Override
    protected String getBreadcrumbTitle() {
        if (this.chapter != null) {
            return this.chapter.getTitle();
        }
        return this.stack.getItem().getName().getString();
    }

    public Font getFontRenderer() {
        return this.font;
    }

    protected boolean isMouseOver(double mouseX, double mouseY, int x, int y, int w, int h) {
        boolean hovered = !(mouseX < (double)x) && !(mouseX > (double)(x + w));
        return hovered &= !(mouseY < (double)y) && !(mouseY > (double)(y + h));
    }

    public static void renderSpeechBox(GuiGraphics graphics, int x, int y, int w, int h, boolean highlighted, Pointing pointing, boolean returnWithLocalTransform) {
        int divotRotation;
        Matrix3x2fStack poseStack = graphics.pose();
        if (!returnWithLocalTransform) {
            poseStack.pushMatrix();
        }
        int boxX = x;
        int boxY = y;
        int divotX = x;
        int divotY = y;
        int divotSize = 8;
        int distance = 1;
        int divotRadius = divotSize / 2;
        Couple<Color> borderColors = highlighted ? PonderButton.COLOR_HOVER : COLOR_IDLE;
        Color c = switch (pointing) {
            default -> {
                divotRotation = 0;
                boxX -= w / 2;
                boxY -= h + divotSize + 1 + distance;
                divotX -= divotRadius;
                divotY -= divotSize + distance;
                yield (Color)borderColors.getSecond();
            }
            case Pointing.LEFT -> {
                divotRotation = 90;
                boxX += divotSize + 1 + distance;
                boxY -= h / 2;
                divotX += distance;
                divotY -= divotRadius;
                yield Color.mixColors(borderColors, 0.5f);
            }
            case Pointing.RIGHT -> {
                divotRotation = 270;
                boxX -= w + divotSize + 1 + distance;
                boxY -= h / 2;
                divotX -= divotSize + distance;
                divotY -= divotRadius;
                yield Color.mixColors(borderColors, 0.5f);
            }
            case Pointing.UP -> {
                divotRotation = 180;
                boxX -= w / 2;
                boxY += divotSize + 1 + distance;
                divotX -= divotRadius;
                divotY += distance;
                yield (Color)borderColors.getFirst();
            }
        };
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(BACKGROUND_FLAT)).gradientBorder(borderColors)).at(boxX, boxY, 100.0f).withBounds(w, h).render(graphics);
        poseStack.pushMatrix();
        poseStack.translate((float)(divotX + divotRadius), (float)(divotY + divotRadius));
        poseStack.rotate((float)divotRotation * ((float)Math.PI / 180));
        poseStack.translate((float)(-divotRadius), (float)(-divotRadius));
        PonderGuiTextures.SPEECH_TOOLTIP_BACKGROUND.render(graphics, 0, 0);
        PonderGuiTextures.SPEECH_TOOLTIP_COLOR.render(graphics, 0, 0, c);
        poseStack.popMatrix();
        if (returnWithLocalTransform) {
            poseStack.translate((float)boxX, (float)boxY);
            return;
        }
        poseStack.popMatrix();
    }

    public ItemStack getHoveredTooltipItem() {
        return this.hoveredTooltipItem;
    }

    public ItemStack getSubject() {
        return this.stack;
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        if (other instanceof PonderUI) {
            PonderUI otherUI = (PonderUI)other;
            return !otherUI.stack.isEmpty() && this.stack.is(otherUI.stack.getItem());
        }
        return super.isEquivalentTo(other);
    }

    @Override
    public void shareContextWith(NavigatableSimiScreen other) {
        if (other instanceof PonderUI) {
            PonderUI ponderUI = (PonderUI)other;
            ponderUI.referredToByTag = this.referredToByTag;
        }
    }

    public static float getPartialTicks() {
        Minecraft mc = Minecraft.getInstance();
        float renderPartialTicks = AnimationTickHolder.getPartialTicksUI(mc.getDeltaTracker());
        Screen screen = mc.screen;
        if (screen instanceof PonderUI) {
            PonderUI ui = (PonderUI)screen;
            if (ui.identifyMode) {
                return ponderPartialTicksPaused;
            }
            return (renderPartialTicks + (float)(ui.extendedTickLength - ui.extendedTickTimer)) / (float)(ui.extendedTickLength + 1);
        }
        return renderPartialTicks;
    }

    @Override
    public boolean isPauseScreen() {
        return true;
    }

    public void coolDownAfterSkip() {
        this.skipCooling = 15;
    }

    @Override
    public void removed() {
        super.removed();
        this.hoveredTooltipItem = ItemStack.EMPTY;
        this.itemRender.clear();
        for (PonderTag tag : this.tags) {
            tag.clear();
        }
    }

    public boolean isComfyReadingEnabled() {
        return (Boolean)PonderConfig.client().comfyReading.get();
    }

    public void setComfyReadingEnabled(boolean slowTextMode) {
        PonderConfig.client().comfyReading.set(slowTextMode);
    }

    static {
        BACKGROUND_TRANSPARENT = new Color(-587202560, true);
        BACKGROUND_FLAT = new Color(-16777216, true);
        BACKGROUND_IMPORTANT = new Color(-586281440, true);
        COLOR_IDLE = Couple.create(new Color(1090514653, true), new Color(553643741, true)).map(Color::setImmutable);
        COLOR_HOVER = Couple.create(new Color(0x70FFFFFF, true), new Color(0x30FFFFFF, true)).map(Color::setImmutable);
        COLOR_HIGHLIGHT = Couple.create(new Color(-251662627, true), new Color(1627385565, true)).map(Color::setImmutable);
        MISSING_VANILLA_ENTRY = Couple.create(new Color(0x505000FF, true), new Color(1344798847, true)).map(Color::setImmutable);
        MISSING_MODDED_ENTRY = Couple.create(new Color(1889027328, true), new Color(1885938688, true)).map(Color::setImmutable);
    }
}

