/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.config;

import com.zurrtum.create.client.flywheel.lib.visualization.SimpleBlockEntityVisualizer;
import com.zurrtum.create.client.vanillin.config.Configurator;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.jetbrains.annotations.Nullable;

public class BlockEntityVisualizerBuilder<T extends BlockEntity> {
    private final Configurator configurator;
    private final BlockEntityType<T> type;
    @Nullable
    private SimpleBlockEntityVisualizer.Factory<T> visualFactory;
    @Nullable
    private Predicate<T> skipVanillaRender;

    public BlockEntityVisualizerBuilder(Configurator configurator, BlockEntityType<T> type) {
        this.configurator = configurator;
        this.type = type;
    }

    public BlockEntityVisualizerBuilder<T> factory(SimpleBlockEntityVisualizer.Factory<T> visualFactory) {
        this.visualFactory = visualFactory;
        return this;
    }

    public BlockEntityVisualizerBuilder<T> skipVanillaRender(Predicate<T> skipVanillaRender) {
        this.skipVanillaRender = skipVanillaRender;
        return this;
    }

    public BlockEntityVisualizerBuilder<T> neverSkipVanillaRender() {
        this.skipVanillaRender = blockEntity -> false;
        return this;
    }

    public SimpleBlockEntityVisualizer<T> apply(boolean enabledByDefault) {
        Objects.requireNonNull(this.visualFactory, "Visual factory cannot be null!");
        if (this.skipVanillaRender == null) {
            this.skipVanillaRender = blockEntity -> true;
        }
        SimpleBlockEntityVisualizer<T> visualizer = new SimpleBlockEntityVisualizer<T>(this.visualFactory, this.skipVanillaRender);
        this.configurator.register(this.type, visualizer, enabledByDefault);
        return visualizer;
    }
}

