/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.visuals;

import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.part.InstanceTree;
import com.zurrtum.create.client.flywheel.lib.model.part.ModelTrees;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.blockentity.BellRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BellBlockEntity;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class BellVisual
extends AbstractBlockEntityVisual<BellBlockEntity>
implements SimpleDynamicVisual {
    private static final Material MATERIAL = SimpleMaterial.builder().mipmap(false).build();
    private final InstanceTree instances = InstanceTree.create(this.instancerProvider(), ModelTrees.of(ModelLayers.BELL, BellRenderer.BELL_TEXTURE, MATERIAL));
    private final InstanceTree bellBody = this.instances.childOrThrow("bell_body");
    private final Matrix4fc initialPose;
    private boolean wasShaking = false;

    public BellVisual(VisualizationContext ctx, BellBlockEntity blockEntity, float partialTick) {
        super(ctx, blockEntity, partialTick);
        BlockPos visualPos = this.getVisualPosition();
        this.initialPose = new Matrix4f().translate((float)visualPos.getX(), (float)visualPos.getY(), (float)visualPos.getZ());
        this.updateRotation(partialTick);
    }

    @Override
    public void beginFrame(DynamicVisual.Context context) {
        if (this.doDistanceLimitThisFrame(context) || !this.isVisible(context.frustum())) {
            return;
        }
        this.updateRotation(context.partialTick());
    }

    private void updateRotation(float partialTick) {
        float xRot = 0.0f;
        float zRot = 0.0f;
        if (((BellBlockEntity)this.blockEntity).shaking) {
            float ringTime = (float)((BellBlockEntity)this.blockEntity).ticks + partialTick;
            float angle = Mth.sin((double)(ringTime / (float)Math.PI)) / (4.0f + ringTime / 3.0f);
            switch (((BellBlockEntity)this.blockEntity).clickDirection) {
                case NORTH: {
                    xRot = -angle;
                    break;
                }
                case SOUTH: {
                    xRot = angle;
                    break;
                }
                case EAST: {
                    zRot = -angle;
                    break;
                }
                case WEST: {
                    zRot = angle;
                }
            }
            this.wasShaking = true;
        } else if (this.wasShaking) {
            this.wasShaking = false;
        }
        this.bellBody.xRot(xRot);
        this.bellBody.zRot(zRot);
        this.instances.updateInstancesStatic(this.initialPose);
    }

    @Override
    public void updateLight(float partialTick) {
        int packedLight = this.computePackedLight();
        this.instances.traverse(instance -> instance.light(packedLight).setChanged());
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        this.instances.traverse(consumer);
    }

    @Override
    protected void _delete() {
        this.instances.delete();
    }
}

