/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.visuals;

import com.mojang.math.Transformation;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.flywheel.lib.visual.component.ShadowComponent;
import net.minecraft.client.Camera;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BlockDisplayVisual
extends AbstractEntityVisual<Display.BlockDisplay>
implements SimpleDynamicVisual {
    private final TransformedInstance instance;
    private BlockState currentBlockState;
    private final ShadowComponent shadowComponent;

    public BlockDisplayVisual(VisualizationContext ctx, Display.BlockDisplay entity, float partialTick) {
        super(ctx, entity, partialTick);
        BlockState state;
        Display.BlockDisplay.BlockRenderState blockRenderState = entity.blockRenderState();
        this.currentBlockState = state = blockRenderState != null ? blockRenderState.blockState() : Blocks.AIR.defaultBlockState();
        this.instance = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.block(state)).createInstance();
        this.shadowComponent = new ShadowComponent(ctx, (Entity)entity);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        Display.RenderState renderState = ((Display.BlockDisplay)this.entity).renderState();
        if (renderState == null) {
            this.instance.handle().setVisible(false);
            return;
        }
        Display.BlockDisplay.BlockRenderState object = ((Display.BlockDisplay)this.entity).blockRenderState();
        if (object == null) {
            this.instance.handle().setVisible(false);
            return;
        }
        this.instance.handle().setVisible(true);
        if (this.currentBlockState != object.blockState()) {
            this.currentBlockState = object.blockState();
            this.visualizationContext.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.block(this.currentBlockState)).stealInstance(this.instance);
        }
        float f = ((Display.BlockDisplay)this.entity).calculateInterpolationProgress(ctx.partialTick());
        this.shadowComponent.radius(renderState.shadowRadius().get(f));
        this.shadowComponent.strength(renderState.shadowStrength().get(f));
        this.shadowComponent.beginFrame(ctx);
        int i = renderState.brightnessOverride();
        int j = i != -1 ? i : this.computePackedLight(ctx.partialTick());
        Transformation transformation = (Transformation)renderState.transformation().get(f);
        Vec3 pos = ((Display.BlockDisplay)this.entity).position();
        Vec3i renderOrigin = this.renderOrigin();
        this.instance.setIdentityTransform().translate((float)(pos.x - (double)renderOrigin.getX()), (float)(pos.y - (double)renderOrigin.getY()), (float)(pos.z - (double)renderOrigin.getZ()));
        float partialTick = ctx.partialTick();
        Camera camera = ctx.camera();
        switch (renderState.billboardConstraints()) {
            case FIXED: {
                this.instance.pose.rotateYXZ((float)(-Math.PI) / 180 * BlockDisplayVisual.entityYRot(this.entity, partialTick), (float)Math.PI / 180 * BlockDisplayVisual.entityXRot(this.entity, partialTick), 0.0f);
                break;
            }
            case HORIZONTAL: {
                this.instance.pose.rotateYXZ((float)(-Math.PI) / 180 * BlockDisplayVisual.entityYRot(this.entity, partialTick), (float)Math.PI / 180 * BlockDisplayVisual.cameraXRot(camera), 0.0f);
                break;
            }
            case VERTICAL: {
                this.instance.pose.rotateYXZ((float)(-Math.PI) / 180 * BlockDisplayVisual.cameraYrot(camera), (float)Math.PI / 180 * BlockDisplayVisual.entityXRot(this.entity, partialTick), 0.0f);
                break;
            }
            case CENTER: {
                this.instance.pose.rotateYXZ((float)(-Math.PI) / 180 * BlockDisplayVisual.cameraYrot(camera), (float)Math.PI / 180 * BlockDisplayVisual.cameraXRot(camera), 0.0f);
            }
        }
        this.instance.mul(transformation.getMatrix()).light(j).setChanged();
    }

    private static float cameraYrot(Camera camera) {
        return camera.yRot() - 180.0f;
    }

    private static float cameraXRot(Camera camera) {
        return -camera.xRot();
    }

    private static float entityYRot(Entity entity, float partialTick) {
        return Mth.rotLerp((float)partialTick, (float)entity.yRotO, (float)entity.getYRot());
    }

    private static float entityXRot(Entity entity, float partialTick) {
        return Mth.lerp((float)partialTick, (float)entity.xRotO, (float)entity.getXRot());
    }

    @Override
    protected void _delete() {
        this.instance.delete();
    }
}

