/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.visuals;

import com.mojang.math.Transformation;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.flywheel.lib.visual.component.ShadowComponent;
import com.zurrtum.create.client.vanillin.item.ItemModels;
import net.minecraft.client.Camera;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class ItemDisplayVisual
extends AbstractEntityVisual<Display.ItemDisplay>
implements SimpleDynamicVisual {
    private final TransformedInstance instance;
    private ItemStack currentStack;
    private final ShadowComponent shadowComponent;

    public ItemDisplayVisual(VisualizationContext ctx, Display.ItemDisplay entity, float partialTick) {
        super(ctx, entity, partialTick);
        Display.ItemDisplay.ItemRenderState itemRenderState = entity.itemRenderState();
        if (itemRenderState == null) {
            this.currentStack = ItemStack.EMPTY;
            this.instance = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.block(Blocks.AIR.defaultBlockState())).createInstance();
        } else {
            this.currentStack = itemRenderState.itemStack().copy();
            this.instance = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, ItemModels.get(this.level, this.currentStack, itemRenderState.itemTransform())).createInstance();
        }
        this.shadowComponent = new ShadowComponent(ctx, (Entity)entity);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        Display.RenderState renderState = ((Display.ItemDisplay)this.entity).renderState();
        if (renderState == null) {
            this.instance.handle().setVisible(false);
            return;
        }
        Display.ItemDisplay.ItemRenderState object = ((Display.ItemDisplay)this.entity).itemRenderState();
        if (object == null) {
            this.instance.handle().setVisible(false);
            return;
        }
        this.instance.handle().setVisible(true);
        ItemStack itemStack = object.itemStack();
        if (!ItemStack.matches((ItemStack)itemStack, (ItemStack)this.currentStack)) {
            this.currentStack = itemStack.copy();
            this.visualizationContext.instancerProvider().instancer(InstanceTypes.TRANSFORMED, ItemModels.get(this.level, this.currentStack, object.itemTransform())).stealInstance(this.instance);
        }
        float f = ((Display.ItemDisplay)this.entity).calculateInterpolationProgress(ctx.partialTick());
        this.shadowComponent.radius(renderState.shadowRadius().get(f));
        this.shadowComponent.strength(renderState.shadowStrength().get(f));
        this.shadowComponent.beginFrame(ctx);
        int i = renderState.brightnessOverride();
        int j = i != -1 ? i : this.computePackedLight(ctx.partialTick());
        Transformation transformation = (Transformation)renderState.transformation().get(f);
        Vec3 pos = ((Display.ItemDisplay)this.entity).position();
        Vec3i renderOrigin = this.renderOrigin();
        this.instance.setIdentityTransform().translate((float)(pos.x - (double)renderOrigin.getX()), (float)(pos.y - (double)renderOrigin.getY()), (float)(pos.z - (double)renderOrigin.getZ()));
        float partialTick = ctx.partialTick();
        Camera camera = ctx.camera();
        switch (renderState.billboardConstraints()) {
            case FIXED: {
                this.instance.pose.rotateYXZ((float)(-Math.PI) / 180 * ItemDisplayVisual.entityYRot(this.entity, partialTick), (float)Math.PI / 180 * ItemDisplayVisual.entityXRot(this.entity, partialTick), 0.0f);
                break;
            }
            case HORIZONTAL: {
                this.instance.pose.rotateYXZ((float)(-Math.PI) / 180 * ItemDisplayVisual.entityYRot(this.entity, partialTick), (float)Math.PI / 180 * ItemDisplayVisual.cameraXRot(camera), 0.0f);
                break;
            }
            case VERTICAL: {
                this.instance.pose.rotateYXZ((float)(-Math.PI) / 180 * ItemDisplayVisual.cameraYrot(camera), (float)Math.PI / 180 * ItemDisplayVisual.entityXRot(this.entity, partialTick), 0.0f);
                break;
            }
            case CENTER: {
                this.instance.pose.rotateYXZ((float)(-Math.PI) / 180 * ItemDisplayVisual.cameraYrot(camera), (float)Math.PI / 180 * ItemDisplayVisual.cameraXRot(camera), 0.0f);
            }
        }
        this.instance.mul(transformation.getMatrix()).rotateY((float)Math.PI).light(j).setChanged();
    }

    private static float cameraYrot(Camera camera) {
        return camera.yRot() - 180.0f;
    }

    private static float cameraXRot(Camera camera) {
        return -camera.xRot();
    }

    private static float entityYRot(Entity entity, float partialTick) {
        return Mth.rotLerp((float)partialTick, (float)entity.yRotO, (float)entity.getYRot());
    }

    private static float entityXRot(Entity entity, float partialTick) {
        return Mth.lerp((float)partialTick, (float)entity.xRotO, (float)entity.getXRot());
    }

    @Override
    protected void _delete() {
        this.instance.delete();
    }

    public static boolean shouldVisualize(Display.ItemDisplay itemDisplay) {
        Display.ItemDisplay.ItemRenderState state = itemDisplay.itemRenderState();
        return state != null && ItemModels.isSupported(state.itemStack(), state.itemTransform());
    }
}

