/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.visuals;

import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visual.EntityVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.baked.BakedModelBuilder;
import com.zurrtum.create.client.flywheel.lib.util.RendererReloadCache;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.vanillin.item.ItemModels;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.resources.model.BlockStateDefinitions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ItemFrameVisual
extends AbstractVisual
implements EntityVisual<ItemFrame>,
SimpleDynamicVisual {
    public static final RendererReloadCache<BlockStateModel, Model> MODEL_RESOURCE_LOCATION = new RendererReloadCache<BlockStateModel, Model>(model -> new BakedModelBuilder((BlockStateModel)model).build());
    private final Matrix4f baseTransform = new Matrix4f();
    private final TransformedInstance frame;
    private final TransformedInstance item;
    private final ItemFrame entity;
    private BlockStateModel lastFrameModel;
    private ItemStack lastItemStack;

    public ItemFrameVisual(VisualizationContext ctx, ItemFrame entity, float partialTick) {
        super(ctx, entity.level(), partialTick);
        this.entity = entity;
        this.lastItemStack = entity.getItem().copy();
        this.lastFrameModel = this.getFrameModel();
        Model frameModel = MODEL_RESOURCE_LOCATION.get(this.lastFrameModel);
        this.frame = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, frameModel).createInstance();
        this.frame.setTransform((Matrix4fc)this.baseTransform);
        this.item = ctx.instancerProvider().instancer(InstanceTypes.TRANSFORMED, ItemModels.get(this.level, this.lastItemStack, ItemDisplayContext.FIXED)).createInstance();
        this.animate(partialTick);
    }

    public static boolean shouldVisualize(ItemFrame entity) {
        return !entity.getItem().is(Items.FILLED_MAP) && ItemModels.isSupported(entity.getItem(), ItemDisplayContext.FIXED);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        this.animate(ctx.partialTick());
    }

    public void animate(float partialTick) {
        int light = LightTexture.pack((int)this.getBlockLightLevel(this.entity.blockPosition()), (int)this.getSkyLightLevel(this.entity.blockPosition()));
        boolean invisible = this.entity.isInvisible();
        Direction direction = this.entity.getDirection();
        Vec3i origin = this.visualizationContext.renderOrigin();
        float d = 0.46875f;
        float x = (float)(this.entity.getX() - (double)origin.getX() + (double)((float)direction.getStepX() * d));
        float y = (float)(this.entity.getY() - (double)origin.getY() + (double)((float)direction.getStepY() * d));
        float z = (float)(this.entity.getZ() - (double)origin.getZ() + (double)((float)direction.getStepZ() * d));
        this.baseTransform.translation(x, y, z);
        this.baseTransform.rotateXYZ((float)Math.PI / 180 * this.entity.getXRot(), (float)Math.PI / 180 * (180.0f - this.entity.getYRot()), 0.0f);
        ItemStack stack = this.entity.getItem();
        BlockStateModel frameLocation = this.getFrameModel();
        if (frameLocation != this.lastFrameModel) {
            this.visualizationContext.instancerProvider().instancer(InstanceTypes.TRANSFORMED, MODEL_RESOURCE_LOCATION.get(frameLocation)).stealInstance(this.frame);
            this.lastFrameModel = frameLocation;
        }
        this.frame.setVisible(!invisible);
        this.frame.setTransform((Matrix4fc)this.baseTransform).translate(-0.5f, -0.5f, -0.5f).light(light).setChanged();
        if (!ItemStack.matches((ItemStack)this.lastItemStack, (ItemStack)stack)) {
            this.lastItemStack = stack.copy();
            this.visualizationContext.instancerProvider().instancer(InstanceTypes.TRANSFORMED, ItemModels.get(this.level, this.lastItemStack, ItemDisplayContext.FIXED)).stealInstance(this.item);
        }
        this.item.setTransform((Matrix4fc)this.baseTransform);
        if (invisible) {
            this.item.translate(0.0f, 0.0f, 0.5f);
        } else {
            this.item.translate(0.0f, 0.0f, 0.4375f);
        }
        int i = this.entity.hasFramedMap() ? this.entity.getRotation() % 4 * 2 : this.entity.getRotation();
        this.item.rotateZDegrees((float)i * 360.0f / 8.0f);
        this.item.scale(0.5f, 0.5f, 0.5f);
        this.item.light(this.getLightVal(light)).setChanged();
    }

    @Override
    public void update(float partialTick) {
    }

    @Override
    protected void _delete() {
        this.frame.delete();
        this.item.delete();
    }

    private int getLightVal(int regularLightVal) {
        return this.entity.getType() == EntityType.GLOW_ITEM_FRAME ? 0xF000F0 : regularLightVal;
    }

    protected int getSkyLightLevel(BlockPos pos) {
        return this.level.getBrightness(LightLayer.SKY, pos);
    }

    protected int getBlockLightLevelBase(BlockPos pos) {
        return this.entity.isOnFire() ? 15 : this.level.getBrightness(LightLayer.BLOCK, pos);
    }

    protected int getBlockLightLevel(BlockPos pos) {
        return this.entity.getType() == EntityType.GLOW_ITEM_FRAME ? Math.max(5, this.getBlockLightLevelBase(pos)) : this.getBlockLightLevelBase(pos);
    }

    public BlockStateModel getFrameModel() {
        boolean bl = this.entity.getType() == EntityType.GLOW_ITEM_FRAME;
        BlockState state = BlockStateDefinitions.getItemFrameFakeState((boolean)bl, (boolean)false);
        return Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
    }
}

