/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.visuals;

import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.material.CutoutShaders;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.part.InstanceTree;
import com.zurrtum.create.client.flywheel.lib.model.part.ModelTrees;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ShulkerBoxVisual
extends AbstractBlockEntityVisual<ShulkerBoxBlockEntity>
implements SimpleDynamicVisual {
    private static final Material MATERIAL = SimpleMaterial.builder().cutout(CutoutShaders.ONE_TENTH).texture(Sheets.SHULKER_SHEET).mipmap(false).backfaceCulling(false).build();
    private static final Set<String> PATHS_TO_PRUNE = Set.of("/head");
    private final InstanceTree instances;
    private final InstanceTree lid;
    private final Matrix4f initialPose;
    private float lastProgress = Float.NaN;

    public ShulkerBoxVisual(VisualizationContext ctx, ShulkerBoxBlockEntity blockEntity, float partialTick) {
        super(ctx, blockEntity, partialTick);
        DyeColor color = blockEntity.getColor();
        net.minecraft.client.resources.model.Material texture = color == null ? Sheets.DEFAULT_SHULKER_TEXTURE_LOCATION : (net.minecraft.client.resources.model.Material)Sheets.SHULKER_TEXTURE_LOCATION.get(color.getId());
        this.instances = InstanceTree.create(this.instancerProvider(), ModelTrees.of(ModelLayers.SHULKER, PATHS_TO_PRUNE, texture, MATERIAL));
        this.lid = this.instances.childOrThrow("lid");
        this.initialPose = this.createInitialPose();
        this.applyTransform(partialTick);
    }

    private Matrix4f createInitialPose() {
        BlockPos visualPosition = this.getVisualPosition();
        Quaternionf rotation = this.getDirection().getRotation();
        return new Matrix4f().translate((float)visualPosition.getX(), (float)visualPosition.getY(), (float)visualPosition.getZ()).translate(0.5f, 0.5f, 0.5f).scale(0.9995f).rotate((Quaternionfc)rotation).scale(1.0f, -1.0f, -1.0f).translate(0.0f, -1.0f, 0.0f);
    }

    private Direction getDirection() {
        if (this.blockState.getBlock() instanceof ShulkerBoxBlock) {
            return (Direction)this.blockState.getValue((Property)ShulkerBoxBlock.FACING);
        }
        return Direction.UP;
    }

    @Override
    public void beginFrame(DynamicVisual.Context context) {
        if (this.doDistanceLimitThisFrame(context) || !this.isVisible(context.frustum())) {
            return;
        }
        this.applyTransform(context.partialTick());
    }

    private void applyTransform(float partialTicks) {
        float progress = ((ShulkerBoxBlockEntity)this.blockEntity).getProgress(partialTicks);
        if (progress == this.lastProgress) {
            return;
        }
        this.lastProgress = progress;
        this.lid.yRot(4.712389f * progress);
        this.lid.yPos(24.0f - progress * 8.0f);
        this.instances.updateInstancesStatic((Matrix4fc)this.initialPose);
    }

    @Override
    public void updateLight(float partialTick) {
        int packedLight = this.computePackedLight();
        this.instances.traverse(instance -> instance.light(packedLight).setChanged());
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        this.instances.traverse(consumer);
    }

    @Override
    protected void _delete() {
        this.instances.delete();
    }
}

