/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.vanillin.visuals;

import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.vanillin.visuals.MinecartVisual;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class TntMinecartVisual<T extends MinecartTNT>
extends MinecartVisual<T> {
    private static final int WHITE_OVERLAY = OverlayTexture.pack((int)OverlayTexture.u((float)1.0f), (int)10);

    public TntMinecartVisual(VisualizationContext ctx, T entity, float partialTick) {
        super(ctx, entity, partialTick, ModelLayers.TNT_MINECART);
    }

    @Override
    protected void updateContents(TransformedInstance contents, Matrix4f pose, float partialTick) {
        int fuseTime = ((MinecartTNT)this.entity).getFuse();
        if (fuseTime > -1 && (float)fuseTime - partialTick + 1.0f < 10.0f) {
            float f = 1.0f - ((float)fuseTime - partialTick + 1.0f) / 10.0f;
            f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            float scale = 1.0f + f * 0.3f;
            pose.scale(scale);
        }
        int overlay = fuseTime > -1 && fuseTime / 5 % 2 == 0 ? WHITE_OVERLAY : OverlayTexture.NO_OVERLAY;
        contents.setTransform((Matrix4fc)pose).overlay(overlay).setChanged();
    }
}

