/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllContraptionTypeTags;
import com.zurrtum.create.Create;
import com.zurrtum.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.api.contraption.BlockMovementChecks;
import com.zurrtum.create.api.contraption.ContraptionType;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.UniqueLinkedList;
import com.zurrtum.create.catnip.math.BBHelper;
import com.zurrtum.create.catnip.math.BlockFace;
import com.zurrtum.create.catnip.nbt.NBTHelper;
import com.zurrtum.create.catnip.nbt.NBTProcessors;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.ContraptionWorld;
import com.zurrtum.create.content.contraptions.MountedStorageManager;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.zurrtum.create.content.contraptions.actors.harvester.HarvesterMovementBehaviour;
import com.zurrtum.create.content.contraptions.actors.seat.SeatBlock;
import com.zurrtum.create.content.contraptions.actors.seat.SeatEntity;
import com.zurrtum.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.zurrtum.create.content.contraptions.bearing.MechanicalBearingBlock;
import com.zurrtum.create.content.contraptions.bearing.StabilizedContraption;
import com.zurrtum.create.content.contraptions.bearing.WindmillBearingBlock;
import com.zurrtum.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.chassis.AbstractChassisBlock;
import com.zurrtum.create.content.contraptions.chassis.ChassisBlockEntity;
import com.zurrtum.create.content.contraptions.chassis.StickerBlock;
import com.zurrtum.create.content.contraptions.gantry.GantryCarriageBlock;
import com.zurrtum.create.content.contraptions.glue.SuperGlueEntity;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlock;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonHeadBlock;
import com.zurrtum.create.content.contraptions.piston.PistonExtensionPoleBlock;
import com.zurrtum.create.content.contraptions.pulley.PulleyBlock;
import com.zurrtum.create.content.contraptions.pulley.PulleyBlockEntity;
import com.zurrtum.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.zurrtum.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.content.kinetics.gantry.GantryShaftBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import com.zurrtum.create.content.kinetics.simpleRelays.ShaftBlock;
import com.zurrtum.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.zurrtum.create.content.logistics.crate.CreativeCrateBlockEntity;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.zurrtum.create.content.redstone.contact.RedstoneContactBlock;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlock;
import com.zurrtum.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.codec.CreateCodecs;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.HashMapPalette;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public abstract class Contraption {
    public static final Codec<Map<UUID, Integer>> SEAT_MAP_CODEC = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, (Codec)Codec.INT);
    public static final Codec<Map<UUID, BlockFace>> SUB_CONTRAPTIONS_CODEC = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, BlockFace.CODEC);
    public Optional<List<AABB>> simplifiedEntityColliders;
    public AbstractContraptionEntity entity;
    public AABB bounds;
    public BlockPos anchor;
    public boolean stalled;
    public boolean hasUniversalCreativeCrate;
    public boolean disassembled;
    protected Map<BlockPos, StructureTemplate.StructureBlockInfo> blocks;
    protected Map<BlockPos, CompoundTag> updateTags;
    public Object2BooleanMap<BlockPos> isLegacy;
    protected List<MutablePair<StructureTemplate.StructureBlockInfo, MovementContext>> actors;
    protected Map<BlockPos, MovingInteractionBehaviour> interactors;
    protected List<ItemStack> disabledActors;
    protected List<AABB> superglue;
    protected List<BlockPos> seats;
    protected Map<UUID, Integer> seatMapping;
    protected Map<UUID, BlockFace> stabilizedSubContraptions;
    protected MountedStorageManager storage;
    protected Multimap<BlockPos, StructureTemplate.StructureBlockInfo> capturedMultiblocks;
    private Set<SuperGlueEntity> glueToRemove;
    private Map<BlockPos, Entity> initialPassengers;
    private List<BlockFace> pendingSubContraptions;
    private CompletableFuture<Void> simplifiedEntityColliderProvider;
    public final AtomicReference<?> clientContraption = new AtomicReference();
    protected ContraptionWorld collisionLevel;

    public Contraption() {
        this.blocks = new HashMap<BlockPos, StructureTemplate.StructureBlockInfo>();
        this.updateTags = new HashMap<BlockPos, CompoundTag>();
        this.isLegacy = new Object2BooleanArrayMap();
        this.seats = new ArrayList<BlockPos>();
        this.actors = new ArrayList<MutablePair<StructureTemplate.StructureBlockInfo, MovementContext>>();
        this.disabledActors = new ArrayList<ItemStack>();
        this.interactors = new HashMap<BlockPos, MovingInteractionBehaviour>();
        this.superglue = new ArrayList<AABB>();
        this.seatMapping = new HashMap<UUID, Integer>();
        this.glueToRemove = new HashSet<SuperGlueEntity>();
        this.initialPassengers = new HashMap<BlockPos, Entity>();
        this.pendingSubContraptions = new ArrayList<BlockFace>();
        this.stabilizedSubContraptions = new HashMap<UUID, BlockFace>();
        this.simplifiedEntityColliders = Optional.empty();
        this.storage = new MountedStorageManager();
        this.capturedMultiblocks = ArrayListMultimap.create();
    }

    public ContraptionWorld getContraptionWorld() {
        if (this.collisionLevel == null) {
            this.collisionLevel = new ContraptionWorld(this.entity.level(), this);
        }
        return this.collisionLevel;
    }

    public abstract boolean assemble(Level var1, BlockPos var2) throws AssemblyException;

    public abstract boolean canBeStabilized(Direction var1, BlockPos var2);

    public abstract ContraptionType getType();

    protected boolean customBlockPlacement(LevelAccessor world, BlockPos pos, BlockState state) {
        return false;
    }

    protected boolean customBlockRemoval(LevelAccessor world, BlockPos pos, BlockState state) {
        return false;
    }

    protected boolean addToInitialFrontier(Level world, BlockPos pos, Direction forcedDirection, Queue<BlockPos> frontier) throws AssemblyException {
        return true;
    }

    public static Contraption fromData(Level world, ValueInput view, boolean spawnData) {
        ContraptionType type = (ContraptionType)view.read("Type", ContraptionType.CODEC).orElseThrow();
        Contraption contraption = type.factory.get();
        contraption.read(world, view, spawnData);
        contraption.collisionLevel = new ContraptionWorld(world, contraption);
        contraption.gatherBBsOffThread();
        return contraption;
    }

    public boolean searchMovedStructure(Level world, BlockPos pos, @Nullable Direction forcedDirection) throws AssemblyException {
        this.initialPassengers.clear();
        UniqueLinkedList<BlockPos> frontier = new UniqueLinkedList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        this.anchor = pos;
        if (this.bounds == null) {
            this.bounds = new AABB(BlockPos.ZERO);
        }
        if (!BlockMovementChecks.isBrittle(world.getBlockState(pos))) {
            frontier.add(pos);
        }
        if (!this.addToInitialFrontier(world, pos, forcedDirection, frontier)) {
            return false;
        }
        for (int limit = 100000; limit > 0; --limit) {
            if (frontier.isEmpty()) {
                return true;
            }
            if (this.moveBlock(world, forcedDirection, frontier, visited)) continue;
            return false;
        }
        throw AssemblyException.structureTooLarge();
    }

    public void onEntityCreated(AbstractContraptionEntity entity) {
        this.entity = entity;
        for (BlockFace blockFace : this.pendingSubContraptions) {
            Direction face = blockFace.getFace();
            StabilizedContraption subContraption = new StabilizedContraption(face);
            Level world = entity.level();
            BlockPos pos = blockFace.getPos();
            try {
                if (!subContraption.assemble(world, pos)) {
                }
            }
            catch (AssemblyException e) {}
            continue;
            subContraption.removeBlocksFromWorld(world, BlockPos.ZERO);
            OrientedContraptionEntity movedContraption = OrientedContraptionEntity.create(world, subContraption, face);
            BlockPos anchor = blockFace.getConnectedPos();
            movedContraption.setPos((float)anchor.getX() + 0.5f, anchor.getY(), (float)anchor.getZ() + 0.5f);
            world.addFreshEntity((Entity)movedContraption);
            this.stabilizedSubContraptions.put(movedContraption.getUUID(), new BlockFace(this.toLocalPos(pos), face));
        }
        this.storage.initialize();
        this.gatherBBsOffThread();
    }

    public void onEntityRemoved(AbstractContraptionEntity entity) {
        if (this.simplifiedEntityColliderProvider != null) {
            this.simplifiedEntityColliderProvider.cancel(false);
            this.simplifiedEntityColliderProvider = null;
        }
    }

    public void onEntityInitialize(Level world, AbstractContraptionEntity contraptionEntity) {
        if (world.isClientSide()) {
            return;
        }
        for (OrientedContraptionEntity orientedCE : world.getEntitiesOfClass(OrientedContraptionEntity.class, contraptionEntity.getBoundingBox().inflate(1.0))) {
            if (!this.stabilizedSubContraptions.containsKey(orientedCE.getUUID())) continue;
            orientedCE.startRiding(contraptionEntity);
        }
        for (BlockPos seatPos : this.getSeats()) {
            int seatIndex;
            Entity passenger = this.initialPassengers.get(seatPos);
            if (passenger == null || (seatIndex = this.getSeats().indexOf(seatPos)) == -1) continue;
            contraptionEntity.addSittingPassenger(passenger, seatIndex);
        }
    }

    private boolean canStickTo(BlockState state, BlockState other) {
        Block stateBlock = state.getBlock();
        if (stateBlock == Blocks.SLIME_BLOCK) {
            return other.getBlock() != Blocks.HONEY_BLOCK;
        }
        if (stateBlock == Blocks.HONEY_BLOCK) {
            return other.getBlock() != Blocks.SLIME_BLOCK;
        }
        Block otherBlock = other.getBlock();
        return otherBlock == Blocks.SLIME_BLOCK || otherBlock == Blocks.HONEY_BLOCK;
    }

    protected boolean moveBlock(Level world, @Nullable Direction forcedDirection, Queue<BlockPos> frontier, Set<BlockPos> visited) throws AssemblyException {
        Direction offset;
        Object attached;
        BlockEntity blockEntity;
        BlockPos pos = frontier.poll();
        if (pos == null) {
            return false;
        }
        visited.add(pos);
        if (world.isOutsideBuildHeight(pos)) {
            return true;
        }
        if (!world.isLoaded(pos)) {
            throw AssemblyException.unloadedChunk(pos);
        }
        if (this.isAnchoringBlockAt(pos)) {
            return true;
        }
        BlockState state = world.getBlockState(pos);
        if (!BlockMovementChecks.isMovementNecessary(state, world, pos)) {
            return true;
        }
        if (!this.movementAllowed(state, world, pos)) {
            throw AssemblyException.unmovableBlock(pos, state);
        }
        if (state.getBlock() instanceof AbstractChassisBlock && !this.moveChassis(world, pos, forcedDirection, frontier, visited)) {
            return false;
        }
        if (state.is((Block)AllBlocks.BELT)) {
            this.moveBelt(pos, frontier, visited, state);
        }
        if (state.is((Block)AllBlocks.WINDMILL_BEARING) && (blockEntity = world.getBlockEntity(pos)) instanceof WindmillBearingBlockEntity) {
            WindmillBearingBlockEntity wbbe = (WindmillBearingBlockEntity)blockEntity;
            wbbe.disassembleForMovement();
        }
        if (state.is((Block)AllBlocks.GANTRY_CARRIAGE)) {
            this.moveGantryPinion(world, pos, frontier, visited, state);
        }
        if (state.is((Block)AllBlocks.GANTRY_SHAFT)) {
            this.moveGantryShaft(world, pos, frontier, visited, state);
        }
        if (state.is((Block)AllBlocks.STICKER) && ((Boolean)state.getValue((Property)StickerBlock.EXTENDED)).booleanValue() && !visited.contains(attached = pos.relative(offset = (Direction)state.getValue((Property)StickerBlock.FACING))) && !BlockMovementChecks.isNotSupportive(world.getBlockState((BlockPos)attached), offset.getOpposite())) {
            frontier.add((BlockPos)attached);
        }
        if ((attached = world.getBlockEntity(pos)) instanceof ChainConveyorBlockEntity) {
            ChainConveyorBlockEntity ccbe = (ChainConveyorBlockEntity)attached;
            ccbe.notifyConnectedToValidate();
        }
        if (state.hasProperty((Property)ChestBlock.TYPE) && state.hasProperty((Property)ChestBlock.FACING) && state.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE && !visited.contains(attached = pos.relative(offset = ChestBlock.getConnectedDirection((BlockState)state)))) {
            frontier.add((BlockPos)attached);
        }
        if ((attached = state.getBlock()) instanceof AbstractBogeyBlock) {
            AbstractBogeyBlock bogey = (AbstractBogeyBlock)attached;
            for (Direction d : bogey.getStickySurfaces((BlockGetter)world, pos, state)) {
                if (visited.contains(pos.relative(d))) continue;
                frontier.add(pos.relative(d));
            }
        }
        if (state.is((Block)AllBlocks.MECHANICAL_BEARING)) {
            this.moveBearing(pos, frontier, visited, state);
        }
        if (state.is((Block)AllBlocks.WINDMILL_BEARING)) {
            this.moveWindmillBearing(pos, frontier, visited, state);
        }
        if (state.getBlock() instanceof SeatBlock) {
            this.moveSeat(world, pos);
        }
        if (state.getBlock() instanceof PulleyBlock) {
            this.movePulley(world, pos, frontier, visited);
        }
        if (state.getBlock() instanceof MechanicalPistonBlock && !this.moveMechanicalPiston(world, pos, frontier, visited, state)) {
            return false;
        }
        if (MechanicalPistonBlock.isExtensionPole(state)) {
            this.movePistonPole(world, pos, frontier, visited, state);
        }
        if (MechanicalPistonBlock.isPistonHead(state)) {
            this.movePistonHead(world, pos, frontier, visited, state);
        }
        BlockPos posDown = pos.below();
        BlockState stateBelow = world.getBlockState(posDown);
        if (!visited.contains(posDown) && stateBelow.is((Block)AllBlocks.CART_ASSEMBLER)) {
            frontier.add(posDown);
        }
        for (Direction offset2 : Iterate.directions) {
            boolean canStick;
            BlockPos offsetPos = pos.relative(offset2);
            BlockState blockState = world.getBlockState(offsetPos);
            if (this.isAnchoringBlockAt(offsetPos)) continue;
            if (!this.movementAllowed(blockState, world, offsetPos)) {
                if (offset2 != forcedDirection) continue;
                throw AssemblyException.unmovableBlock(pos, state);
            }
            boolean wasVisited = visited.contains(offsetPos);
            boolean faceHasGlue = SuperGlueEntity.isGlued((LevelAccessor)world, pos, offset2, this.glueToRemove);
            boolean blockAttachedTowardsFace = BlockMovementChecks.isBlockAttachedTowards(blockState, world, offsetPos, offset2.getOpposite());
            boolean brittle = BlockMovementChecks.isBrittle(blockState);
            boolean bl = canStick = !brittle && this.canStickTo(state, blockState);
            if (canStick) {
                if (state.getPistonPushReaction() == PushReaction.PUSH_ONLY || blockState.getPistonPushReaction() == PushReaction.PUSH_ONLY) {
                    canStick = false;
                }
                if (BlockMovementChecks.isNotSupportive(state, offset2)) {
                    canStick = false;
                }
                if (BlockMovementChecks.isNotSupportive(blockState, offset2.getOpposite())) {
                    canStick = false;
                }
            }
            if (wasVisited || !canStick && !blockAttachedTowardsFace && !faceHasGlue && (offset2 != forcedDirection || BlockMovementChecks.isNotSupportive(state, forcedDirection))) continue;
            frontier.add(offsetPos);
        }
        this.addBlock(world, pos, this.capture(world, pos));
        if (this.blocks.size() <= (Integer)AllConfigs.server().kinetics.maxBlocksMoved.get()) {
            return true;
        }
        throw AssemblyException.structureTooLarge();
    }

    protected void movePistonHead(Level world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        BlockPos attached;
        Direction direction = (Direction)state.getValue((Property)MechanicalPistonHeadBlock.FACING);
        BlockPos offset = pos.relative(direction.getOpposite());
        if (!visited.contains(offset)) {
            Direction pistonFacing;
            BlockState blockState = world.getBlockState(offset);
            if (MechanicalPistonBlock.isExtensionPole(blockState) && ((Direction)blockState.getValue((Property)PistonExtensionPoleBlock.FACING)).getAxis() == direction.getAxis()) {
                frontier.add(offset);
            }
            if (blockState.getBlock() instanceof MechanicalPistonBlock && (pistonFacing = (Direction)blockState.getValue((Property)MechanicalPistonBlock.FACING)) == direction && blockState.getValue(MechanicalPistonBlock.STATE) == MechanicalPistonBlock.PistonState.EXTENDED) {
                frontier.add(offset);
            }
        }
        if (state.getValue(MechanicalPistonHeadBlock.TYPE) == PistonType.STICKY && !visited.contains(attached = pos.relative(direction))) {
            frontier.add(attached);
        }
    }

    protected void movePistonPole(Level world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        for (Direction d : Iterate.directionsInAxis(((Direction)state.getValue((Property)PistonExtensionPoleBlock.FACING)).getAxis())) {
            Direction pistonFacing;
            BlockPos offset = pos.relative(d);
            if (visited.contains(offset)) continue;
            BlockState blockState = world.getBlockState(offset);
            if (MechanicalPistonBlock.isExtensionPole(blockState) && ((Direction)blockState.getValue((Property)PistonExtensionPoleBlock.FACING)).getAxis() == d.getAxis()) {
                frontier.add(offset);
            }
            if (MechanicalPistonBlock.isPistonHead(blockState) && ((Direction)blockState.getValue((Property)MechanicalPistonHeadBlock.FACING)).getAxis() == d.getAxis()) {
                frontier.add(offset);
            }
            if (!(blockState.getBlock() instanceof MechanicalPistonBlock) || (pistonFacing = (Direction)blockState.getValue((Property)MechanicalPistonBlock.FACING)) != d && (pistonFacing != d.getOpposite() || blockState.getValue(MechanicalPistonBlock.STATE) != MechanicalPistonBlock.PistonState.EXTENDED)) continue;
            frontier.add(offset);
        }
    }

    protected void moveGantryPinion(Level world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        BlockPos offset = pos.relative((Direction)state.getValue((Property)GantryCarriageBlock.FACING));
        if (!visited.contains(offset)) {
            frontier.add(offset);
        }
        Direction.Axis rotationAxis = ((IRotate)state.getBlock()).getRotationAxis(state);
        for (Direction d : Iterate.directionsInAxis(rotationAxis)) {
            offset = pos.relative(d);
            BlockState offsetState = world.getBlockState(offset);
            if (!offsetState.is((Block)AllBlocks.GANTRY_SHAFT) || ((Direction)offsetState.getValue((Property)GantryShaftBlock.FACING)).getAxis() != d.getAxis() || visited.contains(offset)) continue;
            frontier.add(offset);
        }
    }

    protected void moveGantryShaft(Level world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        for (Direction d : Iterate.directions) {
            BlockPos offset = pos.relative(d);
            if (visited.contains(offset)) continue;
            BlockState offsetState = world.getBlockState(offset);
            Direction facing = (Direction)state.getValue((Property)GantryShaftBlock.FACING);
            if (d.getAxis() == facing.getAxis() && offsetState.is((Block)AllBlocks.GANTRY_SHAFT) && offsetState.getValue((Property)GantryShaftBlock.FACING) == facing) {
                frontier.add(offset);
                continue;
            }
            if (!offsetState.is((Block)AllBlocks.GANTRY_CARRIAGE) || offsetState.getValue((Property)GantryCarriageBlock.FACING) != d) continue;
            frontier.add(offset);
        }
    }

    private void moveWindmillBearing(BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)WindmillBearingBlock.FACING);
        BlockPos offset = pos.relative(facing);
        if (!visited.contains(offset)) {
            frontier.add(offset);
        }
    }

    private void moveBearing(BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)MechanicalBearingBlock.FACING);
        if (!this.canBeStabilized(facing, pos.subtract((Vec3i)this.anchor))) {
            BlockPos offset = pos.relative(facing);
            if (!visited.contains(offset)) {
                frontier.add(offset);
            }
            return;
        }
        this.pendingSubContraptions.add(new BlockFace(pos, facing));
    }

    private void moveBelt(BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) {
        BlockPos nextPos = BeltBlock.nextSegmentPosition(state, pos, true);
        BlockPos prevPos = BeltBlock.nextSegmentPosition(state, pos, false);
        if (nextPos != null && !visited.contains(nextPos)) {
            frontier.add(nextPos);
        }
        if (prevPos != null && !visited.contains(prevPos)) {
            frontier.add(prevPos);
        }
    }

    private void moveSeat(Level world, BlockPos pos) {
        SeatEntity seat;
        List passengers;
        BlockPos local = this.toLocalPos(pos);
        this.getSeats().add(local);
        List seatsEntities = world.getEntitiesOfClass(SeatEntity.class, new AABB(pos));
        if (!seatsEntities.isEmpty() && !(passengers = (seat = (SeatEntity)((Object)seatsEntities.getFirst())).getPassengers()).isEmpty()) {
            this.initialPassengers.put(local, (Entity)passengers.getFirst());
        }
    }

    private void movePulley(Level world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited) {
        int limit = (Integer)AllConfigs.server().kinetics.maxRopeLength.get();
        BlockPos ropePos = pos;
        while (limit-- >= 0 && world.isLoaded(ropePos = ropePos.below())) {
            BlockState ropeState = world.getBlockState(ropePos);
            Block block = ropeState.getBlock();
            if (!(block instanceof PulleyBlock.RopeBlock) && !(block instanceof PulleyBlock.MagnetBlock)) {
                if (visited.contains(ropePos)) break;
                frontier.add(ropePos);
                break;
            }
            this.addBlock(world, ropePos, this.capture(world, ropePos));
        }
    }

    private boolean moveMechanicalPiston(Level world, BlockPos pos, Queue<BlockPos> frontier, Set<BlockPos> visited, BlockState state) throws AssemblyException {
        BlockState poleState;
        Direction direction = (Direction)state.getValue((Property)MechanicalPistonBlock.FACING);
        MechanicalPistonBlock.PistonState pistonState = (MechanicalPistonBlock.PistonState)((Object)state.getValue(MechanicalPistonBlock.STATE));
        if (pistonState == MechanicalPistonBlock.PistonState.MOVING) {
            return false;
        }
        BlockPos offset = pos.relative(direction.getOpposite());
        if (!visited.contains(offset) && (poleState = world.getBlockState(offset)).is((Block)AllBlocks.PISTON_EXTENSION_POLE) && ((Direction)poleState.getValue((Property)PistonExtensionPoleBlock.FACING)).getAxis() == direction.getAxis()) {
            frontier.add(offset);
        }
        if ((pistonState == MechanicalPistonBlock.PistonState.EXTENDED || MechanicalPistonBlock.isStickyPiston(state)) && !visited.contains(offset = pos.relative(direction))) {
            frontier.add(offset);
        }
        return true;
    }

    private boolean moveChassis(Level world, BlockPos pos, Direction movementDirection, Queue<BlockPos> frontier, Set<BlockPos> visited) {
        BlockEntity be = world.getBlockEntity(pos);
        if (!(be instanceof ChassisBlockEntity)) {
            return false;
        }
        ChassisBlockEntity chassis = (ChassisBlockEntity)be;
        chassis.addAttachedChasses(frontier, visited);
        List<BlockPos> includedBlockPositions = chassis.getIncludedBlockPositions(movementDirection, false);
        if (includedBlockPositions == null) {
            return false;
        }
        for (BlockPos blockPos : includedBlockPositions) {
            if (visited.contains(blockPos)) continue;
            frontier.add(blockPos);
        }
        return true;
    }

    protected Pair<StructureTemplate.StructureBlockInfo, BlockEntity> capture(Level world, BlockPos pos) {
        BlockState blockstate = world.getBlockState(pos);
        if (blockstate.is((Block)AllBlocks.REDSTONE_CONTACT)) {
            blockstate = (BlockState)blockstate.setValue((Property)RedstoneContactBlock.POWERED, (Comparable)Boolean.valueOf(true));
        }
        if (blockstate.is((Block)AllBlocks.POWERED_SHAFT)) {
            blockstate = BlockHelper.copyProperties(blockstate, AllBlocks.SHAFT.defaultBlockState());
        }
        if (blockstate.getBlock() instanceof ControlsBlock && this.getType().is(AllContraptionTypeTags.OPENS_CONTROLS)) {
            blockstate = (BlockState)blockstate.setValue((Property)ControlsBlock.OPEN, (Comparable)Boolean.valueOf(true));
        }
        if (blockstate.hasProperty((Property)SlidingDoorBlock.VISIBLE)) {
            blockstate = (BlockState)blockstate.setValue((Property)SlidingDoorBlock.VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        if (blockstate.getBlock() instanceof ButtonBlock) {
            blockstate = (BlockState)blockstate.setValue((Property)ButtonBlock.POWERED, (Comparable)Boolean.valueOf(false));
            world.scheduleTick(pos, blockstate.getBlock(), -1);
        }
        if (blockstate.getBlock() instanceof PressurePlateBlock) {
            blockstate = (BlockState)blockstate.setValue((Property)PressurePlateBlock.POWERED, (Comparable)Boolean.valueOf(false));
            world.scheduleTick(pos, blockstate.getBlock(), -1);
        }
        CompoundTag compoundnbt = this.getBlockEntityNBT(world, pos);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof PoweredShaftBlockEntity) {
            blockEntity = new BracketedKineticBlockEntity(pos, blockstate);
        }
        if (blockEntity instanceof FactoryPanelBlockEntity) {
            FactoryPanelBlockEntity fpbe = (FactoryPanelBlockEntity)blockEntity;
            try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(blockEntity.problemPath(), Create.LOGGER);){
                fpbe.writeSafe((ValueOutput)new TagValueOutput((ProblemReporter)logging, (DynamicOps)world.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), compoundnbt));
            }
        }
        return Pair.of((Object)new StructureTemplate.StructureBlockInfo(pos, blockstate, compoundnbt), (Object)blockEntity);
    }

    protected void addBlock(Level level, BlockPos pos, Pair<StructureTemplate.StructureBlockInfo, BlockEntity> pair) {
        CreativeCrateBlockEntity crateBlockEntity;
        MovingInteractionBehaviour interactionBehaviour;
        BlockState state;
        StructureTemplate.StructureBlockInfo structureBlockInfo;
        StructureTemplate.StructureBlockInfo captured = (StructureTemplate.StructureBlockInfo)pair.getKey();
        BlockPos localPos = pos.subtract((Vec3i)this.anchor);
        if (this.blocks.put(localPos, structureBlockInfo = new StructureTemplate.StructureBlockInfo(localPos, state = captured.state(), captured.nbt())) != null) {
            return;
        }
        this.bounds = this.bounds.minmax(new AABB(localPos));
        BlockEntity be = (BlockEntity)pair.getValue();
        if (be != null) {
            CompoundTag updateTag = be.getUpdateTag((HolderLookup.Provider)level.registryAccess());
            this.updateTags.put(localPos, updateTag);
        }
        this.storage.addBlock(level, state, pos, localPos, be);
        this.captureMultiblock(localPos, structureBlockInfo, be);
        if (MovementBehaviour.REGISTRY.get((StateHolder<Block, ?>)state) != null) {
            this.actors.add((MutablePair<StructureTemplate.StructureBlockInfo, MovementContext>)MutablePair.of((Object)structureBlockInfo, null));
        }
        if ((interactionBehaviour = MovingInteractionBehaviour.REGISTRY.get((StateHolder<Block, ?>)state)) != null) {
            this.interactors.put(localPos, interactionBehaviour);
        }
        if (be instanceof CreativeCrateBlockEntity && (crateBlockEntity = (CreativeCrateBlockEntity)be).getBehaviour(ServerFilteringBehaviour.TYPE).getFilter().isEmpty()) {
            this.hasUniversalCreativeCrate = true;
        }
    }

    protected void captureMultiblock(BlockPos localPos, StructureTemplate.StructureBlockInfo structureBlockInfo, BlockEntity be) {
        if (!(be instanceof IMultiBlockEntityContainer)) {
            return;
        }
        IMultiBlockEntityContainer multiBlockBE = (IMultiBlockEntityContainer)be;
        CompoundTag nbt = structureBlockInfo.nbt();
        BlockPos controllerPos = nbt.read("Controller", BlockPos.CODEC).map(this::toLocalPos).orElse(localPos);
        nbt.store("Controller", BlockPos.CODEC, (Object)controllerPos);
        if (this.updateTags.containsKey(localPos)) {
            this.updateTags.get(localPos).store("Controller", BlockPos.CODEC, (Object)controllerPos);
        }
        if (multiBlockBE.isController() && multiBlockBE.getHeight() <= 1 && multiBlockBE.getWidth() <= 1) {
            nbt.store("LastKnownPos", BlockPos.CODEC, (Object)BlockPos.ZERO.below(0x7FFFFFFE));
            return;
        }
        nbt.remove("LastKnownPos");
        this.capturedMultiblocks.put((Object)controllerPos, (Object)structureBlockInfo);
    }

    @Nullable
    protected CompoundTag getBlockEntityNBT(Level world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity == null) {
            return null;
        }
        CompoundTag nbt = blockEntity.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess());
        nbt.remove("x");
        nbt.remove("y");
        nbt.remove("z");
        return nbt;
    }

    protected BlockPos toLocalPos(BlockPos globalPos) {
        return globalPos.subtract((Vec3i)this.anchor);
    }

    protected boolean movementAllowed(BlockState state, Level world, BlockPos pos) {
        return BlockMovementChecks.isMovementAllowed(state, world, pos);
    }

    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return pos.equals((Object)this.anchor);
    }

    public void read(Level world, ValueInput view, boolean spawnData) {
        this.readBlocksCompound(view.childOrEmpty("Blocks"), world);
        this.capturedMultiblocks.clear();
        view.childrenListOrEmpty("CapturedMultiblocks").forEach(c -> {
            BlockPos controllerPos = (BlockPos)c.read("Controller", BlockPos.CODEC).orElseThrow();
            ((List)c.read("Parts", CreateCodecs.BLOCK_POS_LIST_CODEC).orElseThrow()).forEach(pos -> this.capturedMultiblocks.put((Object)controllerPos, (Object)this.blocks.get(pos)));
        });
        this.storage.read(view, spawnData, this);
        this.actors.clear();
        view.childrenListOrEmpty("Actors").forEach(c -> c.read("Pos", BlockPos.CODEC).ifPresent(pos -> {
            StructureTemplate.StructureBlockInfo info = this.blocks.get(pos);
            if (info == null) {
                return;
            }
            MovementContext context = MovementContext.read(world, info, c, this);
            this.actors.add((MutablePair<StructureTemplate.StructureBlockInfo, MovementContext>)MutablePair.of((Object)info, (Object)context));
        }));
        this.disabledActors.clear();
        this.superglue.clear();
        this.seats.clear();
        this.seatMapping.clear();
        this.stabilizedSubContraptions.clear();
        view.read("DisabledActors", CreateCodecs.ITEM_LIST_CODEC).ifPresent(list -> {
            this.disabledActors.addAll((Collection<ItemStack>)list);
            for (ItemStack stack : this.disabledActors) {
                this.setActorsActive(stack, false);
            }
        });
        view.read("Superglue", CreateCodecs.BOX_CODEC.listOf()).ifPresent(list -> this.superglue.addAll((Collection<AABB>)list));
        view.read("Seats", CreateCodecs.BLOCK_POS_LIST_CODEC).ifPresent(list -> this.seats.addAll((Collection<BlockPos>)list));
        view.read("Passengers", SEAT_MAP_CODEC).ifPresent(map -> this.seatMapping.putAll((Map<UUID, Integer>)map));
        view.read("SubContraptions", SUB_CONTRAPTIONS_CODEC).ifPresent(map -> this.stabilizedSubContraptions.putAll((Map<UUID, BlockFace>)map));
        view.read("Interactors", CreateCodecs.BLOCK_POS_LIST_CODEC).ifPresentOrElse(list -> list.forEach(pos -> {
            StructureTemplate.StructureBlockInfo structureBlockInfo = this.blocks.get(pos);
            if (structureBlockInfo == null) {
                return;
            }
            MovingInteractionBehaviour behaviour = MovingInteractionBehaviour.REGISTRY.get((StateHolder<Block, ?>)structureBlockInfo.state());
            if (behaviour != null) {
                this.interactors.put((BlockPos)pos, behaviour);
            }
        }), this.interactors::clear);
        view.read("BoundsFront", CreateCodecs.BOX_CODEC).ifPresent(box -> {
            this.bounds = box;
        });
        this.stalled = view.getBooleanOr("Stalled", false);
        this.hasUniversalCreativeCrate = view.getBooleanOr("BottomlessSupply", false);
        this.anchor = (BlockPos)view.read("Anchor", BlockPos.CODEC).orElseThrow();
    }

    public void write(ValueOutput view, boolean spawnPacket) {
        view.store("Type", CreateRegistries.CONTRAPTION_TYPE.byNameCodec(), (Object)this.getType());
        this.writeBlocksCompound(view.child("Blocks"), spawnPacket);
        ValueOutput.ValueOutputList multiblocks = view.childrenList("CapturedMultiblocks");
        this.capturedMultiblocks.keySet().forEach(controllerPos -> {
            ValueOutput block = multiblocks.addChild();
            block.store("Controller", BlockPos.CODEC, controllerPos);
            Collection multiblockParts = this.capturedMultiblocks.get(controllerPos);
            List<BlockPos> list = multiblockParts.stream().map(StructureTemplate.StructureBlockInfo::pos).toList();
            block.store("Parts", CreateCodecs.BLOCK_POS_LIST_CODEC, list);
        });
        ValueOutput.ValueOutputList actors = view.childrenList("Actors");
        for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> actor : this.getActors()) {
            MovementBehaviour behaviour = MovementBehaviour.REGISTRY.get((StateHolder<Block, ?>)((StructureTemplate.StructureBlockInfo)actor.left).state());
            if (behaviour == null) continue;
            ValueOutput item = actors.addChild();
            item.store("Pos", BlockPos.CODEC, (Object)((StructureTemplate.StructureBlockInfo)actor.left).pos());
            behaviour.writeExtraData((MovementContext)actor.right);
            ((MovementContext)actor.right).write(item);
        }
        view.store("DisabledActors", CreateCodecs.ITEM_LIST_CODEC, this.disabledActors);
        if (!spawnPacket) {
            view.store("Superglue", CreateCodecs.BOX_CODEC.listOf(), this.superglue);
        }
        this.writeStorage(view, spawnPacket);
        view.store("Interactors", CreateCodecs.BLOCK_POS_LIST_CODEC, this.interactors.keySet().stream().toList());
        view.store("Seats", CreateCodecs.BLOCK_POS_LIST_CODEC, this.seats);
        view.store("Passengers", SEAT_MAP_CODEC, this.seatMapping);
        view.store("SubContraptions", SUB_CONTRAPTIONS_CODEC, this.stabilizedSubContraptions);
        view.store("Anchor", BlockPos.CODEC, (Object)this.anchor);
        view.putBoolean("Stalled", this.stalled);
        view.putBoolean("BottomlessSupply", this.hasUniversalCreativeCrate);
        if (this.bounds != null) {
            view.store("BoundsFront", CreateCodecs.BOX_CODEC, (Object)this.bounds);
        }
    }

    public void writeStorage(ValueOutput view, boolean spawnPacket) {
        this.storage.write(view, spawnPacket);
    }

    private void writeBlocksCompound(ValueOutput view, boolean spawnPacket) {
        HashMapPalette palette = new HashMapPalette(16);
        ValueOutput.ValueOutputList blockList = view.childrenList("BlockList");
        for (StructureTemplate.StructureBlockInfo block : this.blocks.values()) {
            int id = palette.idFor((Object)block.state(), (i, s) -> {
                throw new IllegalStateException("Palette Map index exceeded maximum");
            });
            BlockPos pos = block.pos();
            ValueOutput c = blockList.addChild();
            c.putLong("Pos", pos.asLong());
            c.putInt("State", id);
            CompoundTag updateTag = this.updateTags.get(pos);
            if (spawnPacket) {
                if (updateTag != null) {
                    c.store("Data", CompoundTag.CODEC, (Object)updateTag);
                    continue;
                }
                if (block.nbt() == null) continue;
                c.store("Data", CompoundTag.CODEC, (Object)block.nbt());
                c.putBoolean("Legacy", true);
                continue;
            }
            if (block.nbt() != null) {
                c.store("Data", CompoundTag.CODEC, (Object)block.nbt());
            }
            if (updateTag == null) continue;
            c.store("UpdateTag", CompoundTag.CODEC, (Object)updateTag);
        }
        int size = palette.getSize();
        ArrayList<BlockState> paletteData = new ArrayList<BlockState>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            paletteData.add((BlockState)palette.valueFor(i2));
        }
        view.store("Palette", CreateCodecs.BLOCK_STATE_LIST_CODEC, paletteData);
    }

    private void readBlocksCompound(ValueInput view, Level world) {
        this.blocks.clear();
        this.updateTags.clear();
        this.isLegacy.clear();
        HashMapPalette palette = new HashMapPalette(16, view.read("Palette", CreateCodecs.BLOCK_STATE_LIST_CODEC).orElseGet(ArrayList::new));
        view.childrenListOrEmpty("BlockList").forEach(c -> {
            StructureTemplate.StructureBlockInfo info = Contraption.readStructureBlockInfo(c, (HashMapPalette<BlockState>)palette);
            this.blocks.put(info.pos(), info);
            c.read("UpdateTag", CompoundTag.CODEC).ifPresent(updateTag -> this.updateTags.put(info.pos(), (CompoundTag)updateTag));
            this.isLegacy.put((Object)info.pos(), c.getBooleanOr("Legacy", false));
        });
        AllClientHandle.INSTANCE.resetClientContraption(this);
    }

    private static StructureTemplate.StructureBlockInfo readStructureBlockInfo(ValueInput view, HashMapPalette<BlockState> palette) {
        return new StructureTemplate.StructureBlockInfo(BlockPos.of((long)view.getLongOr("Pos", 0L)), Objects.requireNonNull((BlockState)palette.valueFor(view.getIntOr("State", 0))), (CompoundTag)view.read("Data", CompoundTag.CODEC).orElse(null));
    }

    private static StructureTemplate.StructureBlockInfo legacyReadStructureBlockInfo(CompoundTag blockListEntry, HolderGetter<Block> holderGetter) {
        return new StructureTemplate.StructureBlockInfo(NBTHelper.readBlockPos(blockListEntry, "Pos"), NbtUtils.readBlockState(holderGetter, (CompoundTag)blockListEntry.getCompoundOrEmpty("Block")), blockListEntry.contains("Data") ? blockListEntry.getCompoundOrEmpty("Data") : null);
    }

    public void removeBlocksFromWorld(Level world, BlockPos offset) {
        this.glueToRemove.forEach(glue -> {
            this.superglue.add(glue.getBoundingBox().move(Vec3.atLowerCornerOf((Vec3i)offset.offset((Vec3i)this.anchor)).scale(-1.0)));
            glue.discard();
        });
        ArrayList<BoundingBox> minimisedGlue = new ArrayList<BoundingBox>();
        for (int i = 0; i < this.superglue.size(); ++i) {
            minimisedGlue.add(null);
        }
        for (boolean brittles : Iterate.trueAndFalse) {
            Iterator<StructureTemplate.StructureBlockInfo> iterator = this.blocks.values().iterator();
            while (iterator.hasNext()) {
                StructureTemplate.StructureBlockInfo block = iterator.next();
                if (brittles != BlockMovementChecks.isBrittle(block.state())) continue;
                for (int i = 0; i < this.superglue.size(); ++i) {
                    AABB aabb = this.superglue.get(i);
                    if (aabb == null || !aabb.contains((double)block.pos().getX() + 0.5, (double)block.pos().getY() + 0.5, (double)block.pos().getZ() + 0.5)) continue;
                    if (minimisedGlue.get(i) == null) {
                        minimisedGlue.set(i, new BoundingBox(block.pos()));
                        continue;
                    }
                    minimisedGlue.set(i, BBHelper.encapsulate((BoundingBox)minimisedGlue.get(i), block.pos()));
                }
                BlockPos add = block.pos().offset((Vec3i)this.anchor).offset((Vec3i)offset);
                if (this.customBlockRemoval((LevelAccessor)world, add, block.state())) continue;
                BlockState oldState = world.getBlockState(add);
                Block blockIn = oldState.getBlock();
                boolean blockMismatch = block.state().getBlock() != blockIn;
                if (blockMismatch &= AllBlocks.POWERED_SHAFT != blockIn || !block.state().is((Block)AllBlocks.SHAFT)) {
                    iterator.remove();
                }
                world.removeBlockEntity(add);
                int flags = 122;
                if (blockIn instanceof SimpleWaterloggedBlock && oldState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)oldState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                    world.setBlock(add, Blocks.WATER.defaultBlockState(), flags);
                    continue;
                }
                world.setBlock(add, Blocks.AIR.defaultBlockState(), flags);
            }
        }
        this.superglue.clear();
        Object object = minimisedGlue.iterator();
        while (object.hasNext()) {
            AABB bb;
            BoundingBox box = (BoundingBox)object.next();
            if (box == null || !((bb = new AABB((double)box.minX(), (double)box.minY(), (double)box.minZ(), (double)(box.maxX() + 1), (double)(box.maxY() + 1), (double)(box.maxZ() + 1))).getSize() > 1.01)) continue;
            this.superglue.add(bb);
        }
        for (StructureTemplate.StructureBlockInfo block : this.blocks.values()) {
            BlockPos add = block.pos().offset((Vec3i)this.anchor).offset((Vec3i)offset);
            int flags = 67;
            world.sendBlockUpdated(add, block.state(), Blocks.AIR.defaultBlockState(), flags);
            ServerLevel serverWorld = (ServerLevel)world;
            PoiTypes.forState((BlockState)block.state()).ifPresent(poiType -> world.getServer().execute(() -> serverWorld.getPoiManager().add(add, poiType)));
            BlockHelper.markAndNotifyBlock(world, add, world.getChunkAt(add), block.state(), Blocks.AIR.defaultBlockState(), flags);
            block.state().updateIndirectNeighbourShapes((LevelAccessor)world, add, flags & 0xFFFFFFFE);
        }
    }

    public void addBlocksToWorld(Level world, StructureTransform transform) {
        if (this.disassembled) {
            return;
        }
        this.disassembled = true;
        boolean shouldDropBlocks = (Boolean)AllConfigs.server().kinetics.noDropWhenContraptionReplaceBlocks.get() == false;
        this.translateMultiblockControllers(transform);
        for (boolean nonBrittles : Iterate.trueAndFalse) {
            for (StructureTemplate.StructureBlockInfo block : this.blocks.values()) {
                BlockState blockState;
                BlockState state;
                BlockPos targetPos;
                if (nonBrittles == BlockMovementChecks.isBrittle(block.state()) || this.customBlockPlacement((LevelAccessor)world, targetPos = transform.apply(block.pos()), state = transform.apply(block.state()))) continue;
                if (nonBrittles) {
                    for (Direction face : Iterate.directions) {
                        state = state.updateShape((LevelReader)world, (ScheduledTickAccess)world, targetPos, face, targetPos.relative(face), world.getBlockState(targetPos.relative(face)), world.random);
                    }
                }
                if ((blockState = world.getBlockState(targetPos)).getDestroySpeed((BlockGetter)world, targetPos) == -1.0f || state.getCollisionShape((BlockGetter)world, targetPos).isEmpty() && !blockState.getCollisionShape((BlockGetter)world, targetPos).isEmpty()) {
                    if (targetPos.getY() == world.getMinY()) {
                        targetPos = targetPos.above();
                    }
                    world.levelEvent(2001, targetPos, Block.getId((BlockState)state));
                    if (!shouldDropBlocks) continue;
                    Block.dropResources((BlockState)state, (LevelAccessor)world, (BlockPos)targetPos, null);
                    continue;
                }
                if (state.getBlock() instanceof SimpleWaterloggedBlock && state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                    FluidState FluidState2 = world.getFluidState(targetPos);
                    state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(FluidState2.getType() == Fluids.WATER));
                }
                world.destroyBlock(targetPos, shouldDropBlocks);
                if (state.is((Block)AllBlocks.SHAFT)) {
                    state = ShaftBlock.pickCorrectShaftType(state, world, targetPos);
                }
                if (state.hasProperty((Property)SlidingDoorBlock.VISIBLE)) {
                    state = (BlockState)((BlockState)state.setValue((Property)SlidingDoorBlock.VISIBLE, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)SlidingDoorBlock.OPEN) == false))).setValue((Property)SlidingDoorBlock.POWERED, (Comparable)Boolean.valueOf(false));
                }
                if (state.is(Blocks.SCULK_SHRIEKER)) {
                    state = Blocks.SCULK_SHRIEKER.defaultBlockState();
                }
                world.setBlock(targetPos, state, 67);
                boolean verticalRotation = transform.rotationAxis == null || transform.rotationAxis.isHorizontal();
                boolean bl = verticalRotation = verticalRotation && transform.rotation != Rotation.NONE;
                if (verticalRotation && (state.getBlock() instanceof PulleyBlock.RopeBlock || state.getBlock() instanceof PulleyBlock.MagnetBlock || state.getBlock() instanceof DoorBlock)) {
                    world.destroyBlock(targetPos, shouldDropBlocks);
                }
                BlockEntity blockEntity = world.getBlockEntity(targetPos);
                CompoundTag tag = block.nbt();
                if (state.is(Blocks.SCULK_SENSOR) || state.is(Blocks.SCULK_SHRIEKER)) {
                    tag = null;
                }
                if (blockEntity != null) {
                    tag = NBTProcessors.process(state, blockEntity, tag, false);
                }
                if (blockEntity != null && tag != null) {
                    tag.putInt("x", targetPos.getX());
                    tag.putInt("y", targetPos.getY());
                    tag.putInt("z", targetPos.getZ());
                    if (verticalRotation && blockEntity instanceof PulleyBlockEntity) {
                        tag.remove("Offset");
                        tag.remove("InitialOffset");
                    }
                    if (blockEntity instanceof IMultiBlockEntityContainer && (tag.contains("LastKnownPos") || this.capturedMultiblocks.isEmpty())) {
                        tag.store("LastKnownPos", BlockPos.CODEC, (Object)BlockPos.ZERO.below(0x7FFFFFFE));
                        tag.remove("Controller");
                    }
                    try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(blockEntity.problemPath(), Create.LOGGER);){
                        blockEntity.loadWithComponents(TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)world.registryAccess(), (CompoundTag)tag));
                    }
                }
                this.storage.unmount(world, block, targetPos, blockEntity);
                if (blockEntity == null) continue;
                transform.apply(blockEntity);
            }
        }
        Object object = this.blocks.values().iterator();
        while (object.hasNext()) {
            StructureTemplate.StructureBlockInfo block = (StructureTemplate.StructureBlockInfo)object.next();
            if (!this.shouldUpdateAfterMovement(block)) continue;
            BlockPos targetPos = transform.apply(block.pos());
            BlockHelper.markAndNotifyBlock(world, targetPos, world.getChunkAt(targetPos), block.state(), block.state(), 67);
        }
        for (AABB box : this.superglue) {
            box = new AABB(transform.apply(new Vec3(box.minX, box.minY, box.minZ)), transform.apply(new Vec3(box.maxX, box.maxY, box.maxZ)));
            if (world.isClientSide()) continue;
            world.addFreshEntity((Entity)new SuperGlueEntity(world, box));
        }
    }

    protected void translateMultiblockControllers(StructureTransform transform) {
        if (transform.rotationAxis != null && transform.rotationAxis != Direction.Axis.Y && transform.rotation != Rotation.NONE) {
            this.capturedMultiblocks.values().forEach(info -> info.nbt().store("LastKnownPos", BlockPos.CODEC, (Object)BlockPos.ZERO.below(0x7FFFFFFE)));
            return;
        }
        this.capturedMultiblocks.keySet().forEach(controllerPos -> {
            Collection multiblockParts = this.capturedMultiblocks.get(controllerPos);
            Optional optionalBoundingBox = BoundingBox.encapsulatingPositions(multiblockParts.stream().map(info -> transform.apply(info.pos())).toList());
            if (optionalBoundingBox.isEmpty()) {
                return;
            }
            BoundingBox boundingBox = (BoundingBox)optionalBoundingBox.get();
            BlockPos newControllerPos = new BlockPos(boundingBox.minX(), boundingBox.minY(), boundingBox.minZ());
            BlockPos otherPos = transform.unapply(newControllerPos);
            multiblockParts.forEach(info -> info.nbt().store("Controller", BlockPos.CODEC, (Object)newControllerPos));
            if (controllerPos.equals((Object)otherPos)) {
                return;
            }
            StructureTemplate.StructureBlockInfo prevControllerInfo = this.blocks.get(controllerPos);
            StructureTemplate.StructureBlockInfo newControllerInfo = this.blocks.get(otherPos);
            if (prevControllerInfo == null || newControllerInfo == null) {
                return;
            }
            this.blocks.put(otherPos, new StructureTemplate.StructureBlockInfo(newControllerInfo.pos(), newControllerInfo.state(), prevControllerInfo.nbt()));
            this.blocks.put((BlockPos)controllerPos, new StructureTemplate.StructureBlockInfo(prevControllerInfo.pos(), prevControllerInfo.state(), newControllerInfo.nbt()));
        });
    }

    public void addPassengersToWorld(Level world, StructureTransform transform, List<Entity> seatedEntities) {
        for (Entity seatedEntity : seatedEntities) {
            Integer seatIndex;
            if (this.getSeatMapping().isEmpty() || (seatIndex = this.getSeatMapping().get(seatedEntity.getUUID())) == null) continue;
            BlockPos seatPos = this.getSeats().get(seatIndex);
            if (!(world.getBlockState(seatPos = transform.apply(seatPos)).getBlock() instanceof SeatBlock) || SeatBlock.isSeatOccupied(world, seatPos)) continue;
            SeatBlock.sitDown(world, seatPos, seatedEntity);
        }
    }

    public void startMoving(Level world) {
        this.disabledActors.clear();
        for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> pair : this.actors) {
            MovementContext context = new MovementContext(world, (StructureTemplate.StructureBlockInfo)pair.left, this);
            MovementBehaviour behaviour = MovementBehaviour.REGISTRY.get((StateHolder<Block, ?>)((StructureTemplate.StructureBlockInfo)pair.left).state());
            if (behaviour != null) {
                behaviour.startMoving(context);
            }
            pair.setRight((Object)context);
            if (!(behaviour instanceof ContraptionControlsMovement)) continue;
            this.disableActorOnStart(context);
        }
        for (ItemStack stack : this.disabledActors) {
            this.setActorsActive(stack, false);
        }
    }

    protected void disableActorOnStart(MovementContext context) {
        if (!ContraptionControlsMovement.isDisabledInitially(context)) {
            return;
        }
        ItemStack filter = ContraptionControlsMovement.getFilter(context);
        if (filter == null) {
            return;
        }
        if (this.isActorTypeDisabled(filter)) {
            return;
        }
        this.disabledActors.add(filter);
    }

    public boolean isActorTypeDisabled(ItemStack filter) {
        return this.disabledActors.stream().anyMatch(i -> ContraptionControlsMovement.isSameFilter(i, filter));
    }

    public void setActorsActive(ItemStack referenceStack, boolean enable) {
        for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> pair : this.actors) {
            ItemStack behaviourStack;
            MovementBehaviour behaviour = MovementBehaviour.REGISTRY.get((StateHolder<Block, ?>)((StructureTemplate.StructureBlockInfo)pair.left).state());
            if (behaviour == null || (behaviourStack = behaviour.canBeDisabledVia((MovementContext)pair.right)) == null || !referenceStack.isEmpty() && !ContraptionControlsMovement.isSameFilter(referenceStack, behaviourStack)) continue;
            boolean bl = ((MovementContext)pair.right).disabled = !enable;
            if (enable) continue;
            behaviour.onDisabledByControls((MovementContext)pair.right);
        }
    }

    public List<ItemStack> getDisabledActors() {
        return this.disabledActors;
    }

    public void stop(Level world) {
        this.forEachActor(world, (behaviour, ctx) -> {
            behaviour.stopMoving((MovementContext)ctx);
            ctx.position = null;
            ctx.motion = Vec3.ZERO;
            ctx.relativeMotion = Vec3.ZERO;
            ctx.rotation = v -> v;
        });
    }

    public void forEachActor(Level world, BiConsumer<MovementBehaviour, MovementContext> callBack) {
        for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> pair : this.actors) {
            MovementBehaviour behaviour = MovementBehaviour.REGISTRY.get((StateHolder<Block, ?>)((StructureTemplate.StructureBlockInfo)pair.getLeft()).state());
            if (behaviour == null) continue;
            callBack.accept(behaviour, (MovementContext)pair.getRight());
        }
    }

    protected boolean shouldUpdateAfterMovement(StructureTemplate.StructureBlockInfo info) {
        if (PoiTypes.forState((BlockState)info.state()).isPresent()) {
            return false;
        }
        return !(info.state().getBlock() instanceof SlidingDoorBlock);
    }

    public void expandBoundsAroundAxis(Direction.Axis axis) {
        Set<BlockPos> blocks = this.getBlocks().keySet();
        int radius = (int)Math.ceil(Contraption.getRadius(blocks, axis));
        int maxX = radius + 2;
        int maxY = radius + 2;
        int maxZ = radius + 2;
        int minX = -radius - 1;
        int minY = -radius - 1;
        int minZ = -radius - 1;
        if (axis == Direction.Axis.X) {
            maxX = (int)this.bounds.maxX;
            minX = (int)this.bounds.minX;
        } else if (axis == Direction.Axis.Y) {
            maxY = (int)this.bounds.maxY;
            minY = (int)this.bounds.minY;
        } else if (axis == Direction.Axis.Z) {
            maxZ = (int)this.bounds.maxZ;
            minZ = (int)this.bounds.minZ;
        }
        this.bounds = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public Map<UUID, Integer> getSeatMapping() {
        return this.seatMapping;
    }

    public BlockPos getSeatOf(UUID entityId) {
        if (!this.getSeatMapping().containsKey(entityId)) {
            return null;
        }
        int seatIndex = this.getSeatMapping().get(entityId);
        if (seatIndex >= this.getSeats().size()) {
            return null;
        }
        return this.getSeats().get(seatIndex);
    }

    public BlockPos getBearingPosOf(UUID subContraptionEntityId) {
        if (this.stabilizedSubContraptions.containsKey(subContraptionEntityId)) {
            return this.stabilizedSubContraptions.get(subContraptionEntityId).getConnectedPos();
        }
        return null;
    }

    public void setSeatMapping(Map<UUID, Integer> seatMapping) {
        this.seatMapping = seatMapping;
    }

    public List<BlockPos> getSeats() {
        return this.seats;
    }

    public Map<BlockPos, StructureTemplate.StructureBlockInfo> getBlocks() {
        return this.blocks;
    }

    public Object2BooleanMap<BlockPos> getIsLegacy() {
        return this.isLegacy;
    }

    public List<MutablePair<StructureTemplate.StructureBlockInfo, MovementContext>> getActors() {
        return this.actors;
    }

    @Nullable
    public MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> getActorAt(BlockPos localPos) {
        for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> pair : this.actors) {
            if (!localPos.equals((Object)((StructureTemplate.StructureBlockInfo)pair.left).pos())) continue;
            return pair;
        }
        return null;
    }

    public Map<BlockPos, MovingInteractionBehaviour> getInteractors() {
        return this.interactors;
    }

    public void invalidateColliders() {
        this.simplifiedEntityColliders = Optional.empty();
        this.gatherBBsOffThread();
    }

    private void gatherBBsOffThread() {
        this.getContraptionWorld();
        if (this.simplifiedEntityColliderProvider != null) {
            this.simplifiedEntityColliderProvider.cancel(false);
        }
        this.simplifiedEntityColliderProvider = CompletableFuture.supplyAsync(() -> {
            VoxelShape combinedShape = Shapes.empty();
            for (Map.Entry<BlockPos, StructureTemplate.StructureBlockInfo> entry : this.blocks.entrySet()) {
                StructureTemplate.StructureBlockInfo info = entry.getValue();
                BlockPos localPos = entry.getKey();
                VoxelShape collisionShape = info.state().getCollisionShape((BlockGetter)this.collisionLevel, localPos, CollisionContext.empty());
                if (collisionShape.isEmpty()) continue;
                combinedShape = Shapes.joinUnoptimized((VoxelShape)combinedShape, (VoxelShape)collisionShape.move((double)localPos.getX(), (double)localPos.getY(), (double)localPos.getZ()), (BooleanOp)BooleanOp.OR);
            }
            return combinedShape.optimize().toAabbs();
        }).thenAccept(r -> {
            this.simplifiedEntityColliders = Optional.of(r);
        });
    }

    public static double getRadius(Iterable<? extends Vec3i> blocks, Direction.Axis axis) {
        Direction.Axis axisA;
        Direction.Axis axisB = switch (axis) {
            case Direction.Axis.X -> {
                axisA = Direction.Axis.Y;
                yield Direction.Axis.Z;
            }
            case Direction.Axis.Y -> {
                axisA = Direction.Axis.X;
                yield Direction.Axis.Z;
            }
            case Direction.Axis.Z -> {
                axisA = Direction.Axis.X;
                yield Direction.Axis.Y;
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(axis));
        };
        int maxDistSq = 0;
        for (Vec3i vec3i : blocks) {
            int b;
            int a = vec3i.get(axisA);
            int distSq = a * a + (b = vec3i.get(axisB)) * b;
            if (distSq <= maxDistSq) continue;
            maxDistSq = distSq;
        }
        return Math.sqrt(maxDistSq);
    }

    public MountedStorageManager getStorage() {
        return this.storage;
    }

    public boolean isHiddenInPortal(BlockPos localPos) {
        return false;
    }

    public Optional<List<AABB>> getSimplifiedEntityColliders() {
        return this.simplifiedEntityColliders;
    }

    public void tickStorage(AbstractContraptionEntity entity) {
        this.getStorage().tick(entity);
    }

    public boolean containsBlockBreakers() {
        for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> pair : this.actors) {
            MovementBehaviour behaviour = MovementBehaviour.REGISTRY.get((StateHolder<Block, ?>)((StructureTemplate.StructureBlockInfo)pair.getLeft()).state());
            if (!(behaviour instanceof BlockBreakingMovementBehaviour) && !(behaviour instanceof HarvesterMovementBehaviour)) continue;
            return true;
        }
        return false;
    }
}

