/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.actors.roller;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.content.contraptions.actors.roller.RollerBlock;
import com.zurrtum.create.content.contraptions.actors.roller.RollerMovementBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollOptionBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RollerBlockEntity
extends SmartBlockEntity {
    private float manuallyAnimatedSpeed;
    public ServerFilteringBehaviour filtering;
    public ServerScrollOptionBehaviour<RollingMode> mode;
    private boolean dontPropagate = false;

    public RollerBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.MECHANICAL_ROLLER, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.filtering = new ServerFilteringBehaviour(this);
        behaviours.add(this.filtering);
        this.mode = new ServerScrollOptionBehaviour<RollingMode>(RollingMode.class, this);
        behaviours.add(this.mode);
        this.filtering.withCallback(this::onFilterChanged);
        this.filtering.withPredicate(this::isValidMaterial);
        this.mode.withCallback(this::onModeChanged);
    }

    protected void onModeChanged(int mode) {
        this.shareValuesToAdjacent();
    }

    protected void onFilterChanged(ItemStack newFilter) {
        this.shareValuesToAdjacent();
    }

    protected boolean isValidMaterial(ItemStack newFilter) {
        if (newFilter.isEmpty()) {
            return true;
        }
        BlockState appliedState = RollerMovementBehaviour.getStateToPaveWith(newFilter);
        if (appliedState.isAir()) {
            return false;
        }
        if (appliedState.getBlock() instanceof EntityBlock) {
            return false;
        }
        if (appliedState.getBlock() instanceof StairBlock) {
            return false;
        }
        VoxelShape shape = appliedState.getShape((BlockGetter)this.level, this.worldPosition);
        if (shape.isEmpty() || !shape.bounds().equals((Object)Shapes.block().bounds())) {
            return false;
        }
        VoxelShape collisionShape = appliedState.getCollisionShape((BlockGetter)this.level, this.worldPosition);
        return !collisionShape.isEmpty();
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return new AABB(this.worldPosition).inflate(1.0);
    }

    public float getAnimatedSpeed() {
        return this.manuallyAnimatedSpeed;
    }

    public void setAnimatedSpeed(float speed) {
        this.manuallyAnimatedSpeed = speed;
    }

    public void searchForSharedValues() {
        BlockState blockState = this.getBlockState();
        Direction facing = (Direction)blockState.getValueOrElse((Property)RollerBlock.FACING, (Comparable)Direction.SOUTH);
        for (int side : Iterate.positiveAndNegative) {
            BlockEntity blockEntity;
            BlockPos pos = this.worldPosition.relative(facing.getClockWise(), side);
            if (this.level.getBlockState(pos) != blockState || !((blockEntity = this.level.getBlockEntity(pos)) instanceof RollerBlockEntity)) continue;
            RollerBlockEntity otherRoller = (RollerBlockEntity)blockEntity;
            this.acceptSharedValues(otherRoller.mode.getValue(), otherRoller.filtering.getFilter());
            this.shareValuesToAdjacent();
            break;
        }
    }

    protected void acceptSharedValues(int mode, ItemStack filter) {
        this.dontPropagate = true;
        this.filtering.setFilter(filter.copy());
        this.mode.setValue(mode);
        this.dontPropagate = false;
        this.notifyUpdate();
    }

    public void shareValuesToAdjacent() {
        if (this.dontPropagate || this.level.isClientSide()) {
            return;
        }
        BlockState blockState = this.getBlockState();
        Direction facing = (Direction)blockState.getValueOrElse((Property)RollerBlock.FACING, (Comparable)Direction.SOUTH);
        for (int side : Iterate.positiveAndNegative) {
            BlockEntity blockEntity;
            BlockPos pos;
            for (int i = 1; i < 100 && this.level.getBlockState(pos = this.worldPosition.relative(facing.getClockWise(), side * i)) == blockState && (blockEntity = this.level.getBlockEntity(pos)) instanceof RollerBlockEntity; ++i) {
                RollerBlockEntity otherRoller = (RollerBlockEntity)blockEntity;
                otherRoller.acceptSharedValues(this.mode.getValue(), this.filtering.getFilter());
            }
        }
    }

    public static enum RollingMode {
        TUNNEL_PAVE,
        STRAIGHT_FILL,
        WIDE_FILL;

    }
}

