/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.actors.roller;

import com.mojang.serialization.DynamicOps;
import com.zurrtum.create.AllBlockTags;
import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.actors.roller.PaveTask;
import com.zurrtum.create.content.contraptions.actors.roller.RollerBlock;
import com.zurrtum.create.content.contraptions.actors.roller.RollerBlockEntity;
import com.zurrtum.create.content.contraptions.actors.roller.TrackPaverV2;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.pulley.PulleyContraption;
import com.zurrtum.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.zurrtum.create.content.logistics.filter.FilterItemStack;
import com.zurrtum.create.content.trains.bogey.StandardBogeyBlock;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageBogey;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.entity.TravellingPoint;
import com.zurrtum.create.content.trains.graph.TrackEdge;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.items.CombinedInvWrapper;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryOps;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RollerMovementBehaviour
extends BlockBreakingMovementBehaviour {
    RollerTravellingPoint rollerScout = new RollerTravellingPoint();

    @Override
    public boolean isActive(MovementContext context) {
        return super.isActive(context) && !(context.contraption instanceof PulleyContraption) && VecHelper.isVecPointingTowards(context.relativeMotion, (Direction)context.state.getValue((Property)RollerBlock.FACING));
    }

    @Override
    public boolean disableBlockEntityRendering() {
        return true;
    }

    @Override
    public Vec3 getActiveAreaOffset(MovementContext context) {
        return Vec3.atLowerCornerOf((Vec3i)((Direction)context.state.getValue((Property)RollerBlock.FACING)).getUnitVec3i()).scale(0.45).subtract(0.0, 2.0, 0.0);
    }

    @Override
    protected float getBlockBreakingSpeed(MovementContext context) {
        return Mth.clamp((float)(super.getBlockBreakingSpeed(context) * 1.5f), (float)0.0078125f, (float)16.0f);
    }

    @Override
    public boolean canBreak(Level world, BlockPos breakingPos, BlockState state) {
        for (Direction side : Iterate.directions) {
            if (!world.getBlockState(breakingPos.relative(side)).is(BlockTags.PORTALS)) continue;
            return false;
        }
        return super.canBreak(world, breakingPos, state) && !state.getCollisionShape((BlockGetter)world, breakingPos).isEmpty() && !state.is(AllBlockTags.TRACKS);
    }

    @Override
    protected DamageSource getDamageSource(Level level) {
        return AllDamageSources.get((Level)level).roller;
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        Level world = context.world;
        BlockState stateVisited = world.getBlockState(pos);
        if (!stateVisited.isRedstoneConductor((BlockGetter)world, pos)) {
            this.damageEntities(context, pos, world);
        }
        if (world.isClientSide()) {
            return;
        }
        List<BlockPos> positionsToBreak = this.getPositionsToBreak(context, pos);
        if (positionsToBreak.isEmpty()) {
            this.triggerPaver(context, pos);
            return;
        }
        BlockPos argMax = null;
        double max = -1.0;
        for (BlockPos toBreak : positionsToBreak) {
            float hardness = context.world.getBlockState(toBreak).getDestroySpeed((BlockGetter)world, toBreak);
            if ((double)hardness < max) continue;
            max = hardness;
            argMax = toBreak;
        }
        if (argMax == null) {
            this.triggerPaver(context, pos);
            return;
        }
        context.data.store("ReferencePos", BlockPos.CODEC, (Object)pos);
        context.data.store("BreakingPos", BlockPos.CODEC, argMax);
        context.stall = true;
    }

    @Override
    protected void onBlockBroken(MovementContext context, BlockPos pos, BlockState brokenState) {
        super.onBlockBroken(context, pos, brokenState);
        if (!context.data.contains("ReferencePos")) {
            return;
        }
        BlockPos referencePos = context.data.read("ReferencePos", BlockPos.CODEC).orElse(BlockPos.ZERO);
        for (BlockPos otherPos : this.getPositionsToBreak(context, referencePos)) {
            if (otherPos.equals((Object)pos)) continue;
            this.destroyBlock(context, otherPos);
        }
        this.triggerPaver(context, referencePos);
        context.data.remove("ReferencePos");
    }

    @Override
    protected void destroyBlock(MovementContext context, BlockPos breakingPos) {
        BlockState blockState = context.world.getBlockState(breakingPos);
        boolean noHarvest = blockState.is(BlockTags.NEEDS_IRON_TOOL) || blockState.is(BlockTags.NEEDS_STONE_TOOL) || blockState.is(BlockTags.NEEDS_DIAMOND_TOOL);
        BlockHelper.destroyBlock(context.world, breakingPos, 1.0f, stack -> {
            if (noHarvest || context.world.random.nextBoolean()) {
                return;
            }
            this.dropItem(context, (ItemStack)stack);
        });
        super.destroyBlock(context, breakingPos);
    }

    protected List<BlockPos> getPositionsToBreak(MovementContext context, BlockPos visitedPos) {
        PaveTask profileForTracks;
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        RollerBlockEntity.RollingMode mode = this.getMode(context);
        if (mode != RollerBlockEntity.RollingMode.TUNNEL_PAVE) {
            return positions;
        }
        int startingY = 1;
        if (!this.getStateToPaveWith(context).isAir()) {
            FilterItemStack filter = context.getFilterFromBE();
            CombinedInvWrapper inventory = context.contraption.getStorage().getAllItems();
            ItemStack itemStack = inventory.count(stack -> filter.test(context.world, (ItemStack)stack), 1);
            if (!itemStack.isEmpty()) {
                startingY = 0;
            }
        }
        if ((profileForTracks = this.createHeightProfileForTracks(context)) != null) {
            for (Couple couple : profileForTracks.keys()) {
                boolean shouldPlaceSlab;
                float height = profileForTracks.get(couple);
                BlockPos targetPosition = BlockPos.containing((double)((Integer)couple.getFirst()).intValue(), (double)height, (double)((Integer)couple.getSecond()).intValue());
                boolean bl = shouldPlaceSlab = (double)height > Math.floor(height) + 0.45;
                if (startingY == 1 && shouldPlaceSlab && context.world.getBlockState(targetPosition.above()).getValueOrElse((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE) == SlabType.BOTTOM) {
                    startingY = 2;
                }
                for (int i = startingY; i <= (shouldPlaceSlab ? 3 : 2); ++i) {
                    if (!this.testBreakerTarget(context, targetPosition.above(i), i)) continue;
                    positions.add(targetPosition.above(i));
                }
            }
            return positions;
        }
        for (int i = startingY; i <= 2; ++i) {
            if (!this.testBreakerTarget(context, visitedPos.above(i), i)) continue;
            positions.add(visitedPos.above(i));
        }
        return positions;
    }

    protected boolean testBreakerTarget(MovementContext context, BlockPos target, int columnY) {
        BlockState stateToPaveWith = this.getStateToPaveWith(context);
        BlockState stateToPaveWithAsSlab = this.getStateToPaveWithAsSlab(context);
        BlockState stateAbove = context.world.getBlockState(target);
        if (columnY == 0 && stateAbove.is(stateToPaveWith.getBlock())) {
            return false;
        }
        if (stateToPaveWithAsSlab != null && columnY == 1 && stateAbove.is(stateToPaveWithAsSlab.getBlock())) {
            return false;
        }
        return this.canBreak(context.world, target, stateAbove);
    }

    @Nullable
    protected PaveTask createHeightProfileForTracks(MovementContext context) {
        if (context.contraption == null) {
            return null;
        }
        AbstractContraptionEntity abstractContraptionEntity = context.contraption.entity;
        if (!(abstractContraptionEntity instanceof CarriageContraptionEntity)) {
            return null;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)abstractContraptionEntity;
        Carriage carriage = cce.getCarriage();
        if (carriage == null) {
            return null;
        }
        Train train = carriage.train;
        if (train == null || train.graph == null) {
            return null;
        }
        CarriageBogey mainBogey = (CarriageBogey)carriage.bogeys.getFirst();
        TravellingPoint point = mainBogey.trailing();
        this.rollerScout.node1 = point.node1;
        this.rollerScout.node2 = point.node2;
        this.rollerScout.edge = point.edge;
        this.rollerScout.position = point.position;
        Direction.Axis axis = Direction.Axis.X;
        StructureTemplate.StructureBlockInfo info = context.contraption.getBlocks().get(BlockPos.ZERO);
        if (info != null && info.state().hasProperty((Property)StandardBogeyBlock.AXIS)) {
            axis = (Direction.Axis)info.state().getValue((Property)StandardBogeyBlock.AXIS);
        }
        Direction orientation = cce.getInitialOrientation();
        Direction rollerFacing = (Direction)context.state.getValue((Property)RollerBlock.FACING);
        int step = orientation.getAxisDirection().getStep();
        double widthWiseOffset = axis.choose(-context.localPos.getZ(), 0, -context.localPos.getX()) * step;
        double lengthWiseOffset = axis.choose(-context.localPos.getX(), 0, context.localPos.getZ()) * step - 1;
        if (rollerFacing == orientation.getClockWise()) {
            lengthWiseOffset += 1.0;
        }
        double distanceToTravel = 2.0;
        PaveTask heightProfile = new PaveTask(widthWiseOffset, widthWiseOffset);
        TravellingPoint.ITrackSelector steering = this.rollerScout.steer(TravellingPoint.SteerDirection.NONE, new Vec3(0.0, 1.0, 0.0));
        this.rollerScout.traversalCallback = (edge, coords) -> {};
        this.rollerScout.travel(train.graph, lengthWiseOffset + 1.0, steering);
        this.rollerScout.traversalCallback = (edge, coords) -> {
            if (edge == null) {
                return;
            }
            if (edge.isInterDimensional()) {
                return;
            }
            if (edge.node1.getLocation().dimension != context.world.dimension()) {
                return;
            }
            TrackPaverV2.pave(heightProfile, train.graph, edge, (Double)coords.getFirst(), (Double)coords.getSecond());
        };
        this.rollerScout.travel(train.graph, distanceToTravel, steering);
        for (Couple<Integer> entry : heightProfile.keys()) {
            heightProfile.put((Integer)entry.getFirst(), (Integer)entry.getSecond(), (float)context.localPos.getY() + heightProfile.get(entry));
        }
        return heightProfile;
    }

    protected void triggerPaver(MovementContext context, BlockPos pos) {
        BlockState stateToPaveWith = this.getStateToPaveWith(context);
        BlockState stateToPaveWithAsSlab = this.getStateToPaveWithAsSlab(context);
        RollerBlockEntity.RollingMode mode = this.getMode(context);
        if (mode != RollerBlockEntity.RollingMode.TUNNEL_PAVE && stateToPaveWith.isAir()) {
            return;
        }
        Vec3 directionVec = Vec3.atLowerCornerOf((Vec3i)((Direction)context.state.getValue((Property)RollerBlock.FACING)).getClockWise().getUnitVec3i());
        directionVec = (Vec3)context.rotation.apply(directionVec);
        PaveResult paveResult = PaveResult.PASS;
        int yOffset = 0;
        ArrayList<Pair<BlockPos, Boolean>> paveSet = new ArrayList<Pair<BlockPos, Boolean>>();
        PaveTask profileForTracks = this.createHeightProfileForTracks(context);
        if (profileForTracks == null) {
            paveSet.add(Pair.of(pos, false));
        } else {
            for (Couple<Integer> coords : profileForTracks.keys()) {
                float f = profileForTracks.get(coords);
                boolean shouldPlaceSlab = (double)f > Math.floor(f) + 0.45;
                BlockPos blockPos = BlockPos.containing((double)((Integer)coords.getFirst()).intValue(), (double)f, (double)((Integer)coords.getSecond()).intValue());
                paveSet.add(Pair.of(blockPos, shouldPlaceSlab));
            }
        }
        if (paveSet.isEmpty()) {
            return;
        }
        while (paveResult == PaveResult.PASS) {
            boolean bl;
            if (yOffset > (Integer)AllConfigs.server().kinetics.rollerFillDepth.get()) {
                paveResult = PaveResult.FAIL;
                break;
            }
            HashSet<Pair<BlockPos, Boolean>> currentLayer = new HashSet<Pair<BlockPos, Boolean>>();
            if (mode == RollerBlockEntity.RollingMode.WIDE_FILL) {
                for (Pair pair : paveSet) {
                    int radius = (yOffset + 1) / 2;
                    for (int i = -radius; i <= radius; ++i) {
                        for (int j = -radius; j <= radius; ++j) {
                            if (BlockPos.ZERO.distManhattan((Vec3i)new BlockPos(i, 0, j)) > radius) continue;
                            currentLayer.add(Pair.of(((BlockPos)pair.getFirst()).offset(i, -yOffset, j), (Boolean)pair.getSecond()));
                        }
                    }
                }
            } else {
                for (Pair pair : paveSet) {
                    currentLayer.add(Pair.of(((BlockPos)pair.getFirst()).below(yOffset), (Boolean)pair.getSecond()));
                }
            }
            boolean completelyBlocked = true;
            boolean bl2 = false;
            for (Pair pair : currentLayer) {
                if (stateToPaveWithAsSlab != null && yOffset == 0 && ((Boolean)pair.getSecond()).booleanValue()) {
                    this.tryFill(context, ((BlockPos)pair.getFirst()).above(), stateToPaveWithAsSlab);
                }
                if ((paveResult = this.tryFill(context, (BlockPos)pair.getFirst(), stateToPaveWith)) != PaveResult.FAIL) {
                    completelyBlocked = false;
                }
                if (paveResult != PaveResult.SUCCESS) continue;
                bl = true;
            }
            if (bl) {
                paveResult = PaveResult.SUCCESS;
            } else if (!completelyBlocked || yOffset == 0) {
                paveResult = PaveResult.PASS;
            }
            if (paveResult == PaveResult.SUCCESS && stateToPaveWith.getBlock() instanceof FallingBlock) {
                paveResult = PaveResult.PASS;
            }
            if (paveResult != PaveResult.PASS || mode == RollerBlockEntity.RollingMode.TUNNEL_PAVE) break;
            ++yOffset;
        }
        if (paveResult == PaveResult.SUCCESS) {
            context.data.putInt("WaitingTicks", 2);
            context.data.store("LastPos", BlockPos.CODEC, (Object)pos);
            context.stall = true;
        }
    }

    public static BlockState getStateToPaveWith(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            BlockState defaultBlockState = bi.getBlock().defaultBlockState();
            if (defaultBlockState.hasProperty((Property)SlabBlock.TYPE)) {
                defaultBlockState = (BlockState)defaultBlockState.setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE);
            }
            return defaultBlockState;
        }
        return Blocks.AIR.defaultBlockState();
    }

    protected BlockState getStateToPaveWith(MovementContext context) {
        RegistryOps ops = context.world.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        ItemStack filter = context.blockEntityData.read("Filter", ItemStack.OPTIONAL_CODEC, (DynamicOps)ops).orElse(ItemStack.EMPTY);
        return RollerMovementBehaviour.getStateToPaveWith(filter);
    }

    protected BlockState getStateToPaveWithAsSlab(MovementContext context) {
        BlockState stateToPaveWith = this.getStateToPaveWith(context);
        if (stateToPaveWith.hasProperty((Property)SlabBlock.TYPE)) {
            return (BlockState)stateToPaveWith.setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM);
        }
        Block block = stateToPaveWith.getBlock();
        if (block == null) {
            return null;
        }
        Identifier rl = BuiltInRegistries.BLOCK.getKey((Object)block);
        String namespace = rl.getNamespace();
        String blockName = rl.getPath();
        int nameLength = blockName.length();
        ArrayList<CallSite> possibleSlabLocations = new ArrayList<CallSite>();
        possibleSlabLocations.add((CallSite)((Object)(blockName + "_slab")));
        if (blockName.endsWith("s") && nameLength > 1) {
            possibleSlabLocations.add((CallSite)((Object)(blockName.substring(0, nameLength - 1) + "_slab")));
        }
        if (blockName.endsWith("planks") && nameLength > 7) {
            possibleSlabLocations.add((CallSite)((Object)(blockName.substring(0, nameLength - 7) + "_slab")));
        }
        for (String string : possibleSlabLocations) {
            Optional result = BuiltInRegistries.BLOCK.getOptional(Identifier.fromNamespaceAndPath((String)namespace, (String)string));
            if (result.isEmpty()) continue;
            return ((Block)result.get()).defaultBlockState();
        }
        return null;
    }

    protected RollerBlockEntity.RollingMode getMode(MovementContext context) {
        return RollerBlockEntity.RollingMode.values()[context.blockEntityData.getIntOr("ScrollValue", 0)];
    }

    protected PaveResult tryFill(MovementContext context, BlockPos targetPos, BlockState toPlace) {
        Level level = context.world;
        if (!level.isLoaded(targetPos)) {
            return PaveResult.FAIL;
        }
        BlockState existing = level.getBlockState(targetPos);
        if (existing.is(toPlace.getBlock())) {
            return PaveResult.PASS;
        }
        if (!(existing.is(BlockTags.LEAVES) || existing.canBeReplaced() || existing.getCollisionShape((BlockGetter)level, targetPos).isEmpty() && !existing.is(BlockTags.PORTALS))) {
            return PaveResult.FAIL;
        }
        FilterItemStack filter = context.getFilterFromBE();
        CombinedInvWrapper inventory = context.contraption.getStorage().getAllItems();
        ItemStack held = inventory.extract(stack -> filter.test(context.world, (ItemStack)stack), 1);
        if (held.isEmpty()) {
            return PaveResult.FAIL;
        }
        level.setBlockAndUpdate(targetPos, toPlace);
        return PaveResult.SUCCESS;
    }

    private static final class RollerTravellingPoint
    extends TravellingPoint {
        public BiConsumer<TrackEdge, Couple<Double>> traversalCallback;

        private RollerTravellingPoint() {
        }

        @Override
        protected Double edgeTraversedFrom(TrackGraph graph, boolean forward, TravellingPoint.IEdgePointListener edgePointListener, TravellingPoint.ITurnListener turnListener, double prevPos, double totalDistance) {
            double from = forward ? prevPos : this.position;
            double to = forward ? this.position : prevPos;
            this.traversalCallback.accept(this.edge, Couple.create(from, to));
            return super.edgeTraversedFrom(graph, forward, edgePointListener, turnListener, prevPos, totalDistance);
        }
    }

    protected static enum PaveResult {
        FAIL,
        PASS,
        SUCCESS;

    }
}

