/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.elevator;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.content.contraptions.elevator.ElevatorColumn;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContactBlock;
import com.zurrtum.create.content.decoration.slidingDoor.DoorControlBehaviour;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlock;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class ElevatorContactBlockEntity
extends SmartBlockEntity {
    public DoorControlBehaviour doorControls;
    public ElevatorColumn.ColumnCoords columnCoords;
    public boolean activateBlock;
    public String shortName = "";
    public String longName = "";
    public String lastReportedCurrentFloor = "";
    private int yTargetFromNBT = Integer.MIN_VALUE;
    private boolean deferNameGenerator = false;

    public ElevatorContactBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.ELEVATOR_CONTACT, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.doorControls = new DoorControlBehaviour(this);
        behaviours.add(this.doorControls);
    }

    @Override
    protected void write(ValueOutput view, boolean clientPacket) {
        super.write(view, clientPacket);
        view.putString("ShortName", this.shortName);
        view.putString("LongName", this.longName);
        if (this.lastReportedCurrentFloor != null) {
            view.putString("LastReportedCurrentFloor", this.lastReportedCurrentFloor);
        }
        if (clientPacket) {
            return;
        }
        view.putBoolean("Activate", this.activateBlock);
        if (this.columnCoords == null) {
            return;
        }
        ElevatorColumn column = ElevatorColumn.get((LevelAccessor)this.level, this.columnCoords);
        if (column == null) {
            return;
        }
        view.putInt("ColumnTarget", column.getTargetedYLevel());
        if (column.isActive()) {
            view.putBoolean("ColumnActive", true);
        }
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        super.read(view, clientPacket);
        this.shortName = view.getStringOr("ShortName", "");
        this.longName = view.getStringOr("LongName", "");
        this.lastReportedCurrentFloor = view.getStringOr("LastReportedCurrentFloor", null);
        if (clientPacket) {
            return;
        }
        this.activateBlock = view.getBooleanOr("Activate", false);
        Optional columnTarget = view.getInt("ColumnTarget");
        if (columnTarget.isEmpty()) {
            return;
        }
        int target = (Integer)columnTarget.get();
        boolean active = view.getBooleanOr("ColumnActive", false);
        if (this.columnCoords == null) {
            this.yTargetFromNBT = target;
            return;
        }
        ElevatorColumn column = ElevatorColumn.getOrCreate((LevelAccessor)this.level, this.columnCoords);
        column.target(target);
        column.setActive(active);
    }

    public void updateDisplayedFloor(String floor) {
        if (floor.equals(this.lastReportedCurrentFloor)) {
            return;
        }
        this.lastReportedCurrentFloor = floor;
        DisplayLinkBlock.notifyGatherers((LevelAccessor)this.level, this.worldPosition);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.level.isClientSide()) {
            return;
        }
        this.columnCoords = ElevatorContactBlock.getColumnCoords((LevelAccessor)this.level, this.worldPosition);
        if (this.columnCoords == null) {
            return;
        }
        ElevatorColumn column = ElevatorColumn.getOrCreate((LevelAccessor)this.level, this.columnCoords);
        column.add(this.worldPosition);
        if (this.shortName.isBlank()) {
            this.deferNameGenerator = true;
        }
        if (this.yTargetFromNBT == Integer.MIN_VALUE) {
            return;
        }
        column.target(this.yTargetFromNBT);
        this.yTargetFromNBT = Integer.MIN_VALUE;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.deferNameGenerator) {
            return;
        }
        if (this.columnCoords != null) {
            ElevatorColumn.getOrCreate((LevelAccessor)this.level, this.columnCoords).initNames(this.level);
        }
        this.deferNameGenerator = false;
    }

    @Override
    public void invalidate() {
        ElevatorColumn column;
        if (this.columnCoords != null && (column = ElevatorColumn.get((LevelAccessor)this.level, this.columnCoords)) != null) {
            column.remove(this.worldPosition);
        }
        super.invalidate();
    }

    public void updateName(String shortName, String longName) {
        this.shortName = shortName;
        this.longName = longName;
        this.deferNameGenerator = false;
        this.notifyUpdate();
        ElevatorColumn column = ElevatorColumn.get((LevelAccessor)this.level, this.columnCoords);
        if (column != null) {
            column.namesChanged();
        }
    }

    public Couple<String> getNames() {
        return Couple.create(this.shortName, this.longName);
    }
}

