/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.minecart;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.minecart.CouplingHandler;
import com.zurrtum.create.content.contraptions.minecart.MinecartSim2020;
import com.zurrtum.create.content.contraptions.minecart.capability.MinecartController;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.entity.vehicle.OldMinecartBehavior;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;

public class CouplingPhysics {
    public static void tick(Level world) {
        CouplingHandler.forEachLoadedCoupling(world, c -> CouplingPhysics.tickCoupling(world, c));
    }

    public static void tickCoupling(Level world, Couple<MinecartController> c) {
        Couple<AbstractMinecart> carts = c.map(MinecartController::cart);
        float couplingLength = ((MinecartController)c.getFirst()).getCouplingLength(true);
        CouplingPhysics.softCollisionStep(world, carts, couplingLength);
        if (world.isClientSide()) {
            return;
        }
        CouplingPhysics.hardCollisionStep((ServerLevel)world, carts, couplingLength);
    }

    public static void hardCollisionStep(ServerLevel world, Couple<AbstractMinecart> carts, double couplingLength) {
        if (!MinecartSim2020.canAddMotion(((Couple)carts).get(false)) && MinecartSim2020.canAddMotion(((Couple)carts).get(true))) {
            carts = ((Couple)carts).swap();
        }
        Couple<Object> corrections = Couple.create(null, null);
        Couple<Double> maxSpeed = ((Couple)carts).map(cart -> cart.getMaxSpeed(world));
        boolean firstLoop = true;
        for (boolean current : new boolean[]{true, false, true}) {
            float correctionMagnitude;
            AbstractMinecart cart2 = (AbstractMinecart)((Couple)carts).get(current);
            AbstractMinecart otherCart = (AbstractMinecart)((Couple)carts).get(!current);
            float stress = (float)(couplingLength - cart2.position().distanceTo(otherCart.position()));
            if (Math.abs(stress) < 0.125f) continue;
            RailShape shape = null;
            BlockPos railPosition = CouplingPhysics.getCurrentRailPosition(cart2);
            BlockState railState = world.getBlockState(railPosition.above());
            Block block = railState.getBlock();
            if (block instanceof BaseRailBlock) {
                BaseRailBlock block2 = (BaseRailBlock)block;
                shape = (RailShape)railState.getValue(block2.getShapeProperty());
            }
            Vec3 pos = cart2.position();
            Vec3 link = otherCart.position().subtract(pos);
            float f = correctionMagnitude = firstLoop ? -stress / 2.0f : -stress;
            if (!MinecartSim2020.canAddMotion(cart2)) {
                correctionMagnitude /= 2.0f;
            }
            Vec3 correction = shape != null ? CouplingPhysics.followLinkOnRail(link, pos, correctionMagnitude, MinecartSim2020.getRailVec(shape)).subtract(pos) : link.normalize().scale((double)correctionMagnitude);
            float maxResolveSpeed = 1.75f;
            correction = VecHelper.clamp(correction, (float)Math.min((double)maxResolveSpeed, maxSpeed.get(current)));
            if (corrections.get(current) == null) {
                corrections.set(current, correction);
            }
            if (shape != null) {
                MinecartSim2020.moveCartAlongTrack(world, cart2, correction, railPosition, railState);
            } else {
                cart2.move(MoverType.SELF, correction);
                cart2.setDeltaMovement(cart2.getDeltaMovement().scale((double)0.95f));
            }
            firstLoop = false;
        }
    }

    private static BlockPos getCurrentRailPosition(AbstractMinecart cart) {
        int x = Mth.floor((double)cart.getX());
        int y = Mth.floor((double)cart.getY());
        int z = Mth.floor((double)cart.getZ());
        BlockPos pos = new BlockPos(x, y, z);
        BlockPos down = pos.below();
        if (cart.level().getBlockState(down).is(BlockTags.RAILS)) {
            return down;
        }
        return pos;
    }

    public static void softCollisionStep(Level world, Couple<AbstractMinecart> carts, double couplingLength) {
        Couple<Float> maxSpeed = carts.map(cart -> {
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                return Float.valueOf((float)cart.getMaxSpeed(serverWorld));
            }
            if (cart.getBehavior() instanceof OldMinecartBehavior) {
                return Float.valueOf((float)cart.getMaxSpeed(null));
            }
            double speed = 8.0 * (cart.isInWater() ? 0.5 : 1.0) / 20.0;
            if (cart instanceof MinecartFurnace) {
                speed *= cart.isInWater() ? 0.75 : 0.5;
            }
            return Float.valueOf((float)speed);
        });
        Couple<Boolean> canAddmotion = carts.map(MinecartSim2020::canAddMotion);
        Couple<Vec3> motions = carts.map(Entity::getDeltaMovement);
        motions.replaceWithParams(VecHelper::clamp, Couple.create(Float.valueOf(1.0f), Float.valueOf(1.0f)));
        Couple<Vec3> nextPositions = carts.map(MinecartSim2020::predictNextPositionOf);
        Couple<RailShape> shapes = carts.mapWithContext((minecart, current) -> {
            BlockPos railPosition;
            BlockState railState;
            Block patt0$temp;
            Vec3 vec = (Vec3)nextPositions.get((boolean)current);
            int x = Mth.floor((double)vec.x());
            int y = Mth.floor((double)vec.y());
            int z = Mth.floor((double)vec.z());
            BlockPos pos = new BlockPos(x, y - 1, z);
            if (minecart.level().getBlockState(pos).is(BlockTags.RAILS)) {
                pos = pos.below();
            }
            if (!((patt0$temp = (railState = world.getBlockState((railPosition = pos).above())).getBlock()) instanceof BaseRailBlock)) {
                return null;
            }
            BaseRailBlock block = (BaseRailBlock)patt0$temp;
            return (RailShape)railState.getValue(block.getShapeProperty());
        });
        float futureStress = (float)(couplingLength - ((Vec3)nextPositions.getFirst()).distanceTo((Vec3)nextPositions.getSecond()));
        if (Mth.equal((double)futureStress, (double)0.0)) {
            return;
        }
        for (boolean current2 : Iterate.trueAndFalse) {
            Vec3 correction;
            Vec3 pos = nextPositions.get(current2);
            Vec3 link = nextPositions.get(!current2).subtract(pos);
            float correctionMagnitude = -futureStress / 2.0f;
            if (canAddmotion.get(current2) != canAddmotion.get(!current2)) {
                float f = correctionMagnitude = canAddmotion.get(current2) == false ? 0.0f : correctionMagnitude * 2.0f;
            }
            if (!canAddmotion.get(current2).booleanValue()) continue;
            RailShape shape = shapes.get(current2);
            if (shape != null) {
                Vec3 railVec = MinecartSim2020.getRailVec(shape);
                correction = CouplingPhysics.followLinkOnRail(link, pos, correctionMagnitude, railVec).subtract(pos);
            } else {
                correction = link.normalize().scale((double)correctionMagnitude);
            }
            correction = VecHelper.clamp(correction, maxSpeed.get(current2).floatValue());
            motions.set(current2, motions.get(current2).add(correction));
        }
        motions.replaceWithParams(VecHelper::clamp, maxSpeed);
        carts.forEachWithParams(Entity::setDeltaMovement, motions);
    }

    public static Vec3 followLinkOnRail(Vec3 link, Vec3 cart, float diffToReduce, Vec3 railAxis) {
        double radius;
        Vec3 center;
        double dotProduct = railAxis.dot(link);
        if (Double.isNaN(dotProduct) || dotProduct == 0.0 || diffToReduce == 0.0f) {
            return cart;
        }
        Vec3 axis = railAxis.scale(-Math.signum(dotProduct));
        Vec3 intersectSphere = VecHelper.intersectSphere(cart, axis, center = cart.add(link), radius = link.length() - (double)diffToReduce);
        if (intersectSphere == null) {
            return cart.add(VecHelper.project(link, axis));
        }
        return intersectSphere;
    }
}

