/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.minecart.capability;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.content.contraptions.minecart.CouplingHandler;
import com.zurrtum.create.content.contraptions.minecart.capability.MinecartController;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CapabilityMinecartController {
    public static WorldAttached<Map<UUID, MinecartController>> loadedMinecartsByUUID = new WorldAttached<Map>($ -> new HashMap());
    public static WorldAttached<Set<UUID>> loadedMinecartsWithCoupling = new WorldAttached<Set>($ -> new HashSet());
    static WorldAttached<List<AbstractMinecart>> queuedAdditions = new WorldAttached<List>($ -> ObjectLists.synchronize((ObjectList)new ObjectArrayList()));
    static WorldAttached<List<UUID>> queuedUnloads = new WorldAttached<List>($ -> ObjectLists.synchronize((ObjectList)new ObjectArrayList()));

    public static void tick(Level world) {
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get((LevelAccessor)world);
        List<AbstractMinecart> queued = queuedAdditions.get((LevelAccessor)world);
        List<UUID> queuedRemovals = queuedUnloads.get((LevelAccessor)world);
        Set<UUID> cartsWithCoupling = loadedMinecartsWithCoupling.get((LevelAccessor)world);
        Set<UUID> keySet = carts.keySet();
        for (UUID removal : queuedRemovals) {
            keySet.remove(removal);
            cartsWithCoupling.remove(removal);
        }
        for (AbstractMinecart cart : queued) {
            AbstractMinecart minecartEntity;
            MinecartController minecartController;
            UUID uniqueID = cart.getUUID();
            if (world.isClientSide() && carts.containsKey(uniqueID) && (minecartController = carts.get(uniqueID)) != null && (minecartEntity = minecartController.cart()) != null && minecartEntity.getId() != cart.getId()) continue;
            cartsWithCoupling.remove(uniqueID);
            AllSynchedDatas.MINECART_CONTROLLER.get((Entity)cart).ifPresent(controller -> {
                carts.put(uniqueID, (MinecartController)controller);
                if (controller.isLeadingCoupling()) {
                    cartsWithCoupling.add(uniqueID);
                }
                if (!world.isClientSide()) {
                    controller.sendData();
                }
            });
        }
        queuedRemovals.clear();
        queued.clear();
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (Map.Entry<UUID, MinecartController> entry : carts.entrySet()) {
            MinecartController controller2 = entry.getValue();
            if (controller2 != null && controller2.isPresent()) continue;
            toRemove.add(entry.getKey());
        }
        for (UUID uuid : toRemove) {
            keySet.remove(uuid);
            cartsWithCoupling.remove(uuid);
        }
    }

    public static void entityTick(Entity entity) {
        if (!(entity instanceof AbstractMinecart)) {
            return;
        }
        AllSynchedDatas.MINECART_CONTROLLER.get(entity).ifPresent(MinecartController::tick);
    }

    public static void onChunkUnloaded(LevelChunk chunk) {
        ChunkPos chunkPos = chunk.getPos();
        Level world = chunk.getLevel();
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get((LevelAccessor)world);
        for (MinecartController minecartController : carts.values()) {
            AbstractMinecart cart;
            if (minecartController == null || !minecartController.isPresent() || !(cart = minecartController.cart()).chunkPosition().equals((Object)chunkPos)) continue;
            queuedUnloads.get((LevelAccessor)world).add(cart.getUUID());
        }
    }

    protected static void onCartRemoved(Level world, AbstractMinecart entity) {
        AllSynchedDatas.MINECART_CONTROLLER.set((Entity)entity, Optional.empty());
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get((LevelAccessor)world);
        List<UUID> unloads = queuedUnloads.get((LevelAccessor)world);
        UUID uniqueID = entity.getUUID();
        if (!carts.containsKey(uniqueID) || unloads.contains(uniqueID)) {
            return;
        }
        if (world.isClientSide()) {
            return;
        }
        CapabilityMinecartController.handleKilledMinecart(world, carts.get(uniqueID), entity.position());
    }

    protected static void handleKilledMinecart(Level world, MinecartController controller, Vec3 removedPos) {
        if (controller == null) {
            return;
        }
        for (boolean forward : Iterate.trueAndFalse) {
            AbstractMinecart cart;
            Optional<MinecartController> next = CouplingHandler.getNextInCouplingChain(world, controller, forward);
            if (next.isEmpty()) continue;
            MinecartController nextController = next.get();
            nextController.removeConnection(!forward);
            if (controller.hasContraptionCoupling(forward) || (cart = nextController.cart()) == null) continue;
            Vec3 itemPos = cart.position().add(removedPos).scale(0.5);
            ItemEntity itemEntity = new ItemEntity(world, itemPos.x, itemPos.y, itemPos.z, AllItems.MINECART_COUPLING.getDefaultInstance());
            itemEntity.setDefaultPickUpDelay();
            world.addFreshEntity((Entity)itemEntity);
        }
    }

    @Nullable
    public static MinecartController getIfPresent(Level world, UUID cartId) {
        Map<UUID, MinecartController> carts = loadedMinecartsByUUID.get((LevelAccessor)world);
        if (carts == null) {
            return null;
        }
        if (!carts.containsKey(cartId)) {
            return null;
        }
        return carts.get(cartId);
    }

    public static void attach(EntityAccess entity) {
        if (!(entity instanceof AbstractMinecart)) {
            return;
        }
        AbstractMinecart abstractMinecart = (AbstractMinecart)entity;
        MinecartController controller = new MinecartController(abstractMinecart);
        AllSynchedDatas.MINECART_CONTROLLER.set((Entity)abstractMinecart, Optional.of(controller));
        queuedAdditions.get((LevelAccessor)abstractMinecart.level()).add(abstractMinecart);
    }

    public static void onEntityDeath(Level world, Entity entity) {
        if (entity instanceof AbstractMinecart) {
            AbstractMinecart abstractMinecart = (AbstractMinecart)entity;
            CapabilityMinecartController.onCartRemoved(world, abstractMinecart);
        }
    }
}

