/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.contraptions.mounted;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.OrientedContraptionEntity;
import com.zurrtum.create.content.contraptions.minecart.CouplingHandler;
import com.zurrtum.create.content.contraptions.minecart.capability.MinecartController;
import com.zurrtum.create.content.contraptions.mounted.CartAssemblerBlock;
import com.zurrtum.create.content.contraptions.mounted.MountedContraption;
import com.zurrtum.create.content.redstone.rail.ControllerRailBlock;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollOptionBehaviour;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class CartAssemblerBlockEntity
extends SmartBlockEntity {
    private static final int assemblyCooldown = 8;
    protected ServerScrollOptionBehaviour<CartMovementMode> movementMode;
    private int ticksSinceMinecartUpdate = 8;
    protected AssemblyException lastException;
    protected AbstractMinecart cartToAssemble;

    public CartAssemblerBlockEntity(BlockPos pos, BlockState state) {
        super(AllBlockEntityTypes.CART_ASSEMBLER, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.ticksSinceMinecartUpdate < 8) {
            ++this.ticksSinceMinecartUpdate;
        }
        this.tryAssemble(this.cartToAssemble);
        this.cartToAssemble = null;
    }

    public void tryAssemble(AbstractMinecart cart) {
        if (cart == null) {
            return;
        }
        if (!this.isMinecartUpdateValid()) {
            return;
        }
        this.resetTicksSinceMinecartUpdate();
        BlockState state = this.level.getBlockState(this.worldPosition);
        if (!state.is((Block)AllBlocks.CART_ASSEMBLER)) {
            return;
        }
        CartAssemblerBlock.CartAssemblerAction action = CartAssemblerBlock.getActionForCart(state, cart);
        if (action.shouldAssemble()) {
            this.assemble(this.level, this.worldPosition, cart);
        }
        if (action.shouldDisassemble()) {
            this.disassemble(this.level, this.worldPosition, cart);
        }
        if (action == CartAssemblerBlock.CartAssemblerAction.ASSEMBLE_ACCELERATE && cart.getDeltaMovement().length() > 0.0078125) {
            Direction facing = cart.getMotionDirection();
            RailShape railShape = (RailShape)state.getValue(CartAssemblerBlock.RAIL_SHAPE);
            for (Direction d : Iterate.directionsInAxis(railShape == RailShape.EAST_WEST ? Direction.Axis.X : Direction.Axis.Z)) {
                if (!this.level.getBlockState(this.worldPosition.relative(d)).isRedstoneConductor((BlockGetter)this.level, this.worldPosition.relative(d))) continue;
                facing = d.getOpposite();
            }
            double speed = cart.getMaxSpeed((ServerLevel)this.level);
            cart.setDeltaMovement((double)facing.getStepX() * speed, (double)facing.getStepY() * speed, (double)facing.getStepZ() * speed);
        }
        if (action == CartAssemblerBlock.CartAssemblerAction.ASSEMBLE_ACCELERATE_DIRECTIONAL) {
            Vec3i accelerationVector = ControllerRailBlock.getAccelerationVector((BlockState)((BlockState)AllBlocks.CONTROLLER_RAIL.defaultBlockState().setValue(ControllerRailBlock.SHAPE, (Comparable)((RailShape)state.getValue(CartAssemblerBlock.RAIL_SHAPE)))).setValue((Property)ControllerRailBlock.BACKWARDS, (Comparable)((Boolean)state.getValue((Property)CartAssemblerBlock.BACKWARDS))));
            double speed = cart.getMaxSpeed((ServerLevel)this.level);
            cart.setDeltaMovement(Vec3.atLowerCornerOf((Vec3i)accelerationVector).scale(speed));
        }
        if (action == CartAssemblerBlock.CartAssemblerAction.DISASSEMBLE_BRAKE) {
            Vec3 diff = VecHelper.getCenterOf((Vec3i)this.worldPosition).subtract(cart.position());
            cart.setDeltaMovement(diff.x / 16.0, 0.0, diff.z / 16.0);
        }
    }

    protected void assemble(Level world, BlockPos pos, AbstractMinecart cart) {
        if (!cart.getPassengers().isEmpty()) {
            return;
        }
        Optional<MinecartController> value = AllSynchedDatas.MINECART_CONTROLLER.get((Entity)cart);
        if (value.map(MinecartController::isCoupledThroughContraption).orElse(false).booleanValue()) {
            return;
        }
        CartMovementMode mode = CartMovementMode.values()[this.movementMode.getValue()];
        MountedContraption contraption = new MountedContraption(mode);
        try {
            if (!contraption.assemble(world, pos)) {
                return;
            }
            this.lastException = null;
            this.sendData();
        }
        catch (AssemblyException e) {
            this.lastException = e;
            this.sendData();
            return;
        }
        boolean couplingFound = contraption.connectedCart != null;
        Direction initialOrientation = CartAssemblerBlock.getHorizontalDirection(this.getBlockState());
        if (couplingFound) {
            cart.setPos((double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f));
            if (!CouplingHandler.tryToCoupleCarts(null, world, cart.getId(), contraption.connectedCart.getId())) {
                return;
            }
        }
        contraption.removeBlocksFromWorld(world, BlockPos.ZERO);
        contraption.startMoving(world);
        contraption.expandBoundsAroundAxis(Direction.Axis.Y);
        if (couplingFound) {
            Vec3 diff = contraption.connectedCart.position().subtract(cart.position());
            initialOrientation = Direction.fromYRot((double)(Mth.atan2((double)diff.z, (double)diff.x) * 180.0 / Math.PI));
        }
        OrientedContraptionEntity entity = OrientedContraptionEntity.create(world, contraption, initialOrientation);
        if (couplingFound) {
            entity.setCouplingId(cart.getUUID());
        }
        entity.setPos((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
        world.addFreshEntity((Entity)entity);
        entity.startRiding((Entity)cart);
        if (cart instanceof MinecartFurnace) {
            try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(this.problemPath(), Create.LOGGER);){
                TagValueOutput view = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)world.registryAccess());
                if (cart.save((ValueOutput)view)) {
                    view.putDouble("PushZ", 0.0);
                    view.putDouble("PushX", 0.0);
                    ValueInput data = TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)world.registryAccess(), (CompoundTag)view.buildResult());
                    cart.load(data);
                }
            }
        }
        if (contraption.containsBlockBreakers()) {
            this.award(AllAdvancements.CONTRAPTION_ACTORS);
        }
    }

    protected void disassemble(Level world, BlockPos pos, AbstractMinecart cart) {
        if (cart.getPassengers().isEmpty()) {
            return;
        }
        Entity entity = (Entity)cart.getPassengers().getFirst();
        if (!(entity instanceof OrientedContraptionEntity)) {
            return;
        }
        OrientedContraptionEntity contraption = (OrientedContraptionEntity)entity;
        UUID couplingId = contraption.getCouplingId();
        if (couplingId == null) {
            contraption.yaw = CartAssemblerBlock.getHorizontalDirection(this.getBlockState()).toYRot();
            this.disassembleCart(cart);
            return;
        }
        Couple<MinecartController> coupledCarts = contraption.getCoupledCartsIfPresent();
        if (coupledCarts == null) {
            return;
        }
        for (boolean current : Iterate.trueAndFalse) {
            MinecartController minecartController = coupledCarts.get(current);
            if (minecartController.cart() == cart) continue;
            BlockPos otherPos = minecartController.cart().blockPosition();
            BlockState blockState = world.getBlockState(otherPos);
            if (!blockState.is((Block)AllBlocks.CART_ASSEMBLER)) {
                return;
            }
            if (CartAssemblerBlock.getActionForCart(blockState, minecartController.cart()).shouldDisassemble()) continue;
            return;
        }
        for (boolean current : Iterate.trueAndFalse) {
            coupledCarts.get(current).removeConnection(current);
        }
        this.disassembleCart(cart);
    }

    protected void disassembleCart(AbstractMinecart cart) {
        cart.ejectPassengers();
        if (cart instanceof MinecartFurnace) {
            try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(this.problemPath(), Create.LOGGER);){
                TagValueOutput view = TagValueOutput.createWithContext((ProblemReporter)logging, (HolderLookup.Provider)this.level.registryAccess());
                cart.saveAsPassenger((ValueOutput)view);
                Vec3 velocity = cart.getDeltaMovement();
                view.putDouble("PushX", velocity.x);
                view.putDouble("PushZ", velocity.z);
                ValueInput data = TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)view.buildResult());
                cart.load(data);
            }
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        this.movementMode = new ServerScrollOptionBehaviour<CartMovementMode>(CartMovementMode.class, this);
        behaviours.add(this.movementMode);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.CONTRAPTION_ACTORS);
    }

    @Override
    public void write(ValueOutput view, boolean clientPacket) {
        AssemblyException.write(view, this.lastException);
        super.write(view, clientPacket);
    }

    @Override
    protected void read(ValueInput view, boolean clientPacket) {
        this.lastException = AssemblyException.read(view);
        super.read(view, clientPacket);
    }

    public AssemblyException getLastAssemblyException() {
        return this.lastException;
    }

    public void resetTicksSinceMinecartUpdate() {
        this.ticksSinceMinecartUpdate = 0;
    }

    public void assembleNextTick(AbstractMinecart cart) {
        if (this.cartToAssemble == null) {
            this.cartToAssemble = cart;
        }
    }

    public boolean isMinecartUpdateValid() {
        return this.ticksSinceMinecartUpdate >= 8;
    }

    public static enum CartMovementMode implements StringRepresentable
    {
        ROTATE,
        ROTATE_PAUSED,
        ROTATION_LOCKED;

        public static final Codec<CartMovementMode> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(CartMovementMode::values);
        }
    }
}

